/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.integrations;

import com.google.common.collect.BiMap;
import com.ordana.immersive_weathering.blocks.cracked.Crackable;
import com.ordana.immersive_weathering.blocks.frosted.Frosty;
import com.ordana.immersive_weathering.blocks.mossy.Mossable;
import com.ordana.immersive_weathering.blocks.rusty.Rustable;
import com.ordana.immersive_weathering.blocks.sandy.Sandy;
import com.ordana.immersive_weathering.blocks.snowy.Snowy;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@EmiEntrypoint
public class EmiIntegration
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        Item barkToStrip;
        EmiStack stripped_log;
        EmiStack raw_log;
        ResourceLocation blockId;
        EmiStack output;
        EmiStack input;
        ResourceLocation blockId2;
        EmiStack output2;
        EmiStack input2;
        ResourceLocation blockId3;
        Item brick;
        Crackable cracked;
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/oak_log"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/birch_log"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/spruce_log"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/jungle_log"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/dark_oak_log"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/acacia_log"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/mangrove_log"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/cherry_log"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/bamboo_block"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/warped_stem"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/crimson_stem"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/oak_wood"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/birch_wood"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/spruce_wood"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/jungle_wood"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/dark_oak_wood"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/acacia_wood"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/mangrove_wood"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/cherry_wood"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/warped_hyphae"));
        registry.removeRecipes(new ResourceLocation("emi", "/world/stripping/minecraft/crimson_hyphae"));
        EmiIngredient pickaxes = EmiIngredient.of((TagKey)ItemTags.f_271360_);
        EmiIngredient axes = EmiIngredient.of((TagKey)ItemTags.f_271207_);
        EmiIngredient shovels = EmiIngredient.of((TagKey)ItemTags.f_271138_);
        EmiIngredient hoes = EmiIngredient.of((TagKey)ItemTags.f_271298_);
        EmiStack shears = EmiStack.of((ItemLike)Items.f_42574_);
        EmiStack azalea = EmiStack.of((ItemLike)((ItemLike)ModItems.AZALEA_FLOWERS.get()));
        EmiStack flint_n_steel = EmiStack.of((ItemLike)Items.f_42409_);
        EmiStack water = EmiStack.of((Fluid)Fluids.f_76193_);
        EmiStack lava = EmiStack.of((Fluid)Fluids.f_76195_);
        Style style = Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GREEN});
        EmiStack waterCatalyst = water.copy().setRemainder(water);
        EmiStack lavaCatalyst = lava.copy().setRemainder(lava);
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/rooted_grass_uprooting")).leftInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.ROOTED_GRASS_BLOCK.get()))).rightInput(hoes, true).output(EmiStack.of((ItemLike)Items.f_151017_)).output(EmiStack.of((ItemLike)Items.f_42276_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/campfire_extinguishing")).leftInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50683_)).rightInput(shovels, true).output(EmiStack.of((ItemLike)((ItemLike)ModBlocks.SOOT.get()))).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/clay_tilling")).leftInput(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.EARTHEN_CLAY.get(), (ItemLike)ModBlocks.GRASSY_EARTHEN_CLAY.get()}))).rightInput(hoes, true).output(EmiStack.of((ItemLike)((ItemLike)ModBlocks.EARTHEN_CLAY_FARMLAND.get()))).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/sandy_tilling")).leftInput(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.SANDY_DIRT.get(), (ItemLike)ModBlocks.GRASSY_SANDY_DIRT.get()}))).rightInput(hoes, true).output(EmiStack.of((ItemLike)((ItemLike)ModBlocks.SANDY_FARMLAND.get()))).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/silt_tilling")).leftInput(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.SILT.get(), (ItemLike)ModBlocks.GRASSY_SILT.get()}))).rightInput(hoes, true).output(EmiStack.of((ItemLike)((ItemLike)ModBlocks.SILTY_FARMLAND.get()))).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/loam_tilling")).leftInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.LOAM.get()))).rightInput(hoes, true).output(EmiStack.of((ItemLike)((ItemLike)ModBlocks.LOAMY_FARMLAND.get()))).build());
        BiMap<Block, Block> flowering = WeatheringHelper.FLOWERY_BLOCKS.get();
        for (Object key : flowering.keySet()) {
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", key.m_7705_())).leftInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)flowering.get(key)))).rightInput((EmiIngredient)azalea, false).output(EmiStack.of((ItemLike)key)).build());
        }
        BiMap unflowering = WeatheringHelper.FLOWERY_BLOCKS.get().inverse();
        for (Object key : unflowering.keySet()) {
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", key.m_7705_())).leftInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)unflowering.get(key)))).rightInput((EmiIngredient)shears, true).output(azalea).output(EmiStack.of((ItemLike)key)).build());
        }
        BiMap<Block, Block> frost = Frosty.UNFROSTY_TO_FROSTY.get();
        for (Object key : frost.keySet()) {
            ResourceLocation blockId5 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            EmiStack emiStack = EmiStack.of((ItemLike)((ItemLike)frost.get(key)));
            EmiStack output4 = EmiStack.of((ItemLike)key);
            if (key.m_49966_().m_60713_(Blocks.f_50016_)) continue;
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/block_frosting/" + blockId5.m_135827_() + "/" + blockId5.m_135815_())).leftInput((EmiIngredient)emiStack).rightInput((EmiIngredient)flint_n_steel, true).output(output4).build());
        }
        BiMap<Block, Block> unfrost = Frosty.FROSTY_TO_UNFROSTY.get();
        for (Object key : unfrost.keySet()) {
            ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            EmiStack input5 = EmiStack.of((ItemLike)((ItemLike)unfrost.get(key)));
            EmiStack output5 = EmiStack.of((ItemLike)key);
            if (key.m_49966_().m_60713_(ModBlocks.FROST.get())) continue;
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/block_frosting/" + resourceLocation.m_135827_() + "/" + resourceLocation.m_135815_())).leftInput((EmiIngredient)input5).rightInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.FROST_ITEM.get())), false).output(output5).build());
        }
        Map<TagKey<Block>, Block> charred = WeatheringHelper.WOOD_TO_CHARRED.get();
        for (TagKey tagKey : charred.keySet()) {
            EmiIngredient unburnt_block = EmiIngredient.of((TagKey)tagKey);
            EmiStack charred_block = EmiStack.of((ItemLike)((ItemLike)charred.get(tagKey)));
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/block_charring/" + tagKey.f_203868_().m_135827_() + "/" + tagKey.f_203868_().m_135815_())).leftInput(unburnt_block).rightInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.FIRE.get())), true).output(charred_block).build());
        }
        BiMap<Block, Block> cracks = Crackable.CRACK_LEVEL_INCREASES.get();
        for (Object key : cracks.keySet()) {
            ResourceLocation blockId4 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            EmiStack input3 = EmiStack.of((ItemLike)key);
            EmiStack output3 = EmiStack.of((ItemLike)((ItemLike)cracks.get(key)));
            Object object = cracks.get(key);
            if (!(object instanceof Crackable)) continue;
            cracked = (Crackable)object;
            brick = EmiStack.of((ItemLike)cracked.getRepairItem(((Block)cracks.get(key)).m_49966_()));
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/brick_cracking/" + blockId4.m_135827_() + "/" + blockId4.m_135815_())).leftInput((EmiIngredient)input3).rightInput(pickaxes, true).output(output3).output((EmiStack)brick).build());
        }
        for (Object key : cracks.keySet()) {
            ResourceLocation blockId4 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            EmiStack input3 = EmiStack.of((ItemLike)key);
            EmiStack output3 = EmiStack.of((ItemLike)((ItemLike)cracks.get(key)));
            if (!(key instanceof Crackable)) continue;
            cracked = (Crackable)key;
            brick = cracked.getRepairItem(key.m_49966_());
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/brick_repair/" + blockId4.m_135827_() + "/" + blockId4.m_135815_())).leftInput((EmiIngredient)output3).rightInput(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{brick, (ItemLike)ModItems.MORTAR.get()})), false).output(input3).build());
        }
        BiMap<Block, Block> biMap = Mossable.MOSS_LEVEL_INCREASES.get();
        for (Object key : biMap.keySet()) {
            ResourceLocation blockId32 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            EmiStack input22 = EmiStack.of((ItemLike)key);
            EmiStack output22 = EmiStack.of((ItemLike)((ItemLike)biMap.get(key)));
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/moss_shear/" + blockId32.m_135827_() + "/" + blockId32.m_135815_())).leftInput((EmiIngredient)output22).rightInput((EmiIngredient)shears, true).output(input22).output(EmiStack.of((ItemLike)((ItemLike)ModItems.MOSS_CLUMP.get()))).build());
        }
        for (Object key : biMap.keySet()) {
            blockId3 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            input2 = EmiStack.of((ItemLike)key);
            output2 = EmiStack.of((ItemLike)((ItemLike)biMap.get(key)));
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/moss_burn/" + blockId3.m_135827_() + "/" + blockId3.m_135815_())).leftInput((EmiIngredient)output2).rightInput((EmiIngredient)flint_n_steel, true).output(input2).build());
        }
        for (Object key : biMap.keySet()) {
            blockId3 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            input2 = EmiStack.of((ItemLike)key);
            output2 = EmiStack.of((ItemLike)((ItemLike)biMap.get(key)));
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/mossing/" + blockId3.m_135827_() + "/" + blockId3.m_135815_())).leftInput((EmiIngredient)input2).rightInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.MOSS_CLUMP.get())), false).output(output2).build());
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/gold_mossing/" + blockId3.m_135827_() + "/" + blockId3.m_135815_())).leftInput((EmiIngredient)input2).rightInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.ENCHANTED_GOLDEN_MOSS_CLUMP.get())), true).output(output2).build());
        }
        BiMap<Block, Block> sandy = Sandy.NORMAL_TO_SANDY.get();
        for (Object key : sandy.keySet()) {
            input2 = EmiStack.of((ItemLike)key);
            output2 = EmiStack.of((ItemLike)((ItemLike)sandy.get(key)));
            ResourceLocation blockId22 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/unsanding/" + blockId22.m_135827_() + "/" + blockId22.m_135815_())).leftInput((EmiIngredient)output2).rightInput(shovels, true).output(input2).output(EmiStack.of((ItemLike)((ItemLike)ModBlocks.SAND_LAYER_BLOCK.get()))).build());
        }
        for (Object key : sandy.keySet()) {
            input2 = EmiStack.of((ItemLike)key);
            output2 = EmiStack.of((ItemLike)((ItemLike)sandy.get(key)));
            blockId2 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/block_sanding/" + blockId2.m_135827_() + "/" + blockId2.m_135815_())).leftInput((EmiIngredient)input2).rightInput((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.SAND_LAYER_BLOCK.get())), false).output(output2).build());
        }
        BiMap<Block, Block> snowy = Snowy.NORMAL_TO_SNOWY.get();
        for (Object key : snowy.keySet()) {
            input = EmiStack.of((ItemLike)key);
            output = EmiStack.of((ItemLike)((ItemLike)snowy.get(key)));
            blockId = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/unsnowing/" + blockId.m_135827_() + "/" + blockId.m_135815_())).leftInput((EmiIngredient)output).rightInput(shovels, true).output(input).output(EmiStack.of((ItemLike)Items.f_42452_)).build());
        }
        for (Object key : snowy.keySet()) {
            input = EmiStack.of((ItemLike)key);
            output = EmiStack.of((ItemLike)((ItemLike)snowy.get(key)));
            blockId = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/block_snowing/" + blockId.m_135827_() + "/" + blockId.m_135815_())).leftInput((EmiIngredient)input).rightInput((EmiIngredient)EmiStack.of((ItemLike)Items.f_42452_), false).output(output).build());
        }
        BiMap<Block, Block> rust = Rustable.RUST_LEVEL_INCREASES.get();
        for (Block key : rust.keySet()) {
            blockId2 = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            EmiStack input6 = EmiStack.of((ItemLike)key);
            EmiStack output6 = EmiStack.of((ItemLike)((ItemLike)rust.get((Object)key)));
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/sponge_rusting/" + blockId2.m_135827_() + "/" + blockId2.m_135815_())).leftInput((EmiIngredient)input6).rightInput((EmiIngredient)EmiStack.of((ItemLike)Items.f_41903_), true).output(output6).build());
        }
        BiMap<Block, Block> log = WeatheringHelper.RAW_TO_STRIPPED.get();
        for (Block key : log.keySet()) {
            EmiStack bark2;
            blockId = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            raw_log = EmiStack.of((ItemLike)key);
            stripped_log = EmiStack.of((ItemLike)((ItemLike)log.get((Object)key)));
            barkToStrip = WeatheringHelper.getBarkToStrip(key.m_49966_());
            if (barkToStrip == null) {
                boolean bl = true;
            }
            if ((bark2 = EmiStack.of((ItemLike)barkToStrip)) == null) {
                bark2 = EmiStack.of((ItemLike)((ItemLike)WeatheringHelper.getBarkForStrippedLog(((Block)log.get((Object)key)).m_49966_()).get().getFirst()));
            }
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/block_stripping/" + blockId.m_135827_() + "/" + blockId.m_135815_())).leftInput((EmiIngredient)raw_log).rightInput(axes, true).output(bark2).output(stripped_log).build());
        }
        for (Block key : log.keySet()) {
            EmiStack bark;
            blockId = BuiltInRegistries.f_257033_.m_7981_((Object)key.m_5456_());
            raw_log = EmiStack.of((ItemLike)key);
            stripped_log = EmiStack.of((ItemLike)((ItemLike)log.get((Object)key)));
            barkToStrip = WeatheringHelper.getBarkToStrip(key.m_49966_());
            if (barkToStrip == null) {
                boolean bark2 = true;
            }
            if ((bark = EmiStack.of((ItemLike)barkToStrip)) == null) {
                bark = EmiStack.of((ItemLike)((ItemLike)WeatheringHelper.getBarkForStrippedLog(((Block)log.get((Object)key)).m_49966_()).get().getFirst()));
            }
            registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/block_unstripping/" + blockId.m_135827_() + "/" + blockId.m_135815_())).leftInput((EmiIngredient)stripped_log).rightInput((EmiIngredient)bark, false).output(raw_log).build());
        }
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/andesite")).leftInput((EmiIngredient)waterCatalyst).rightInput((EmiIngredient)lavaCatalyst, true).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50228_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_50334_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/diorite")).leftInput((EmiIngredient)waterCatalyst).rightInput((EmiIngredient)lavaCatalyst, true).rightInput(EmiIngredient.of(ModTags.QUARTZ_BLOCKS), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_50228_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/granite")).leftInput((EmiIngredient)waterCatalyst).rightInput((EmiIngredient)lavaCatalyst, true).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50228_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).rightInput(EmiIngredient.of(ModTags.QUARTZ_BLOCKS), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_50122_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/basalt_below")).leftInput((EmiIngredient)lavaCatalyst).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50137_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.below").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_50137_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/blackstone")).leftInput((EmiIngredient)lavaCatalyst).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50450_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50568_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_50730_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/calcite")).leftInput((EmiIngredient)lavaCatalyst).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50450_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50568_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50453_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.below").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_152497_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/crying_obsidian")).leftInput((EmiIngredient)lavaCatalyst).rightInput((EmiIngredient)waterCatalyst, true).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50084_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_50723_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/magma_block")).leftInput((EmiIngredient)lavaCatalyst).rightInput((EmiIngredient)waterCatalyst, true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.below").m_6270_(style)).appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.rising").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_50450_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/tuff")).leftInput((EmiIngredient)lavaCatalyst).rightInput((EmiIngredient)waterCatalyst, true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.below").m_6270_(style)).appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.sinking").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_152496_)).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(new ResourceLocation("immersive_weathering", "/smooth_basalt")).leftInput((EmiIngredient)lavaCatalyst).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50568_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.adjacent").m_6270_(style))).rightInput((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50136_), true, s -> s.appendTooltip((Component)Component.m_237115_((String)"tooltip.immersive_weathering.below").m_6270_(style))).output(EmiStack.of((ItemLike)Blocks.f_152597_)).build());
    }
}

