/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.entities;

import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModEntities;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class IcicleBlockEntity
extends BlockEntity
implements GameEventListener {
    public static final Object2IntMap<GameEvent> VOLUME_FOR_EVENT = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)GameEvent.f_157770_, 2);
        map.put((Object)GameEvent.f_157794_, 1);
        map.put((Object)GameEvent.f_223696_, 4);
        map.put((Object)GameEvent.f_157792_, 1);
        map.put((Object)GameEvent.f_157793_, 6);
        map.put((Object)GameEvent.f_157796_, 6);
        map.put((Object)GameEvent.f_157802_, 3);
        map.put((Object)GameEvent.f_157803_, 3);
        map.put((Object)GameEvent.f_157812_, 15);
        map.put((Object)GameEvent.f_157772_, 15);
    })));
    private final int radius;
    protected final PositionSource listenerSource;

    public IcicleBlockEntity(BlockPos pos, BlockState state) {
        super(ModEntities.ICICLE_TILE.get(), pos, state);
        this.listenerSource = new BlockPositionSource(this.f_58858_);
        this.radius = CommonConfigs.FALLING_ICICLES.get() != false ? 15 : 0;
    }

    public PositionSource m_142460_() {
        return this.listenerSource;
    }

    public int m_142078_() {
        return this.radius;
    }

    public boolean m_214068_(ServerLevel level, GameEvent gameEvent, GameEvent.Context context, Vec3 pos) {
        double distanceSqr;
        int volume;
        if (!new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_).equals((Object)this.f_58858_) && (double)((volume = VOLUME_FOR_EVENT.getInt((Object)context.f_223712_())) * volume) > (distanceSqr = this.f_58858_.m_203198_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_())) * 0.5 + (double)level.f_46441_.m_188501_() * distanceSqr) {
            float distScaling = 2.0f;
            int o = level.m_213780_().m_188503_(3) - 1;
            int delay = Math.max(0, (int)Mth.m_14116_((float)((float)((double)distScaling * distanceSqr)))) + o;
            level.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), delay);
        }
        return false;
    }
}

