/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.position_tests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.Operator;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import com.ordana.immersive_weathering.util.StrOpt;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

record LightTest(int targetLight, Operator operator, Optional<Vec3i> offset) implements IPositionRuleTest
{
    public static final String NAME = "light_test";
    public static final Codec<LightTest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)15).fieldOf("light").forGetter(LightTest::targetLight), (App)Operator.CODEC.fieldOf("operator").forGetter(LightTest::operator), (App)StrOpt.of(Vec3i.m_194650_((int)16), "offset").forGetter(LightTest::offset)).apply((Applicative)instance, LightTest::new));
    static final IPositionRuleTest.Type<LightTest> TYPE = new IPositionRuleTest.Type<LightTest>(CODEC, "light_test");

    public IPositionRuleTest.Type<LightTest> getType() {
        return TYPE;
    }

    @Override
    public boolean test(Supplier<Holder<Biome>> biome, BlockPos pos, Level level) {
        return this.offset.map(off -> this.operator.apply(level.m_7146_(pos.m_121955_(off)), this.targetLight)).orElseGet(() -> Arrays.stream(Direction.values()).anyMatch(d -> this.operator.apply(level.m_7146_(pos), this.targetLight)));
    }
}

