/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.entity.EntityDreadMob;
import com.github.alexthe666.iceandfire.entity.ai.DreadAITargetNonDread;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IDreadMob;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EntityDreadScuttler
extends EntityDreadMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear {
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(EntityDreadScuttler.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(EntityDreadScuttler.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final float INITIAL_WIDTH = 1.5f;
    private static final float INITIAL_HEIGHT = 1.3f;
    public static Animation ANIMATION_SPAWN = Animation.create((int)40);
    public static Animation ANIMATION_BITE = Animation.create((int)15);
    private int animationTick;
    private Animation currentAnimation;
    private float firstWidth = -1.0f;
    private float firstHeight = -1.0f;

    public EntityDreadScuttler(EntityType type, Level worldIn) {
        super((EntityType<? extends Monster>)type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{IDreadMob.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return DragonUtils.canHostilesTarget((Entity)entity);
            }
        }));
        this.f_21346_.m_25352_(3, (Goal)new DreadAITargetNonDread((Mob)this, LivingEntity.class, false, (Predicate<LivingEntity>)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(LivingEntity entity) {
                return entity instanceof LivingEntity && DragonUtils.canHostilesTarget((Entity)entity);
            }
        }));
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.34).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22284_, 10.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
    }

    public float getSize() {
        return Float.valueOf(((Float)this.f_19804_.m_135370_(SCALE)).floatValue()).floatValue();
    }

    public void setSize(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Scale", this.getSize());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSize(compound.m_128457_("Scale"));
    }

    public boolean m_7327_(@NotNull Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_BITE);
        }
        return true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (Math.abs(this.firstWidth - 1.5f * this.getSize()) > 0.01f || Math.abs(this.firstHeight - 1.3f * this.getSize()) > 0.01f) {
            this.firstWidth = 1.5f * this.getSize();
            this.firstHeight = 1.3f * this.getSize();
        }
        if (!this.m_9236_().f_46443_) {
            this.setBesideClimbableBlock(this.f_19862_);
        }
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30) {
            BlockState belowBlock = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            if (belowBlock.m_60734_() != Blocks.f_50016_) {
                for (int i = 0; i < 5; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, belowBlock), this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20191_().f_82289_, this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                }
            }
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (attackTarget != null && this.m_20270_((Entity)attackTarget) < 4.0f && this.m_142582_((Entity)attackTarget)) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_BITE);
            }
            this.m_21391_((Entity)attackTarget, 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 6) {
                attackTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
                attackTarget.m_147240_(0.25, this.m_20185_() - attackTarget.m_20185_(), this.m_20189_() - attackTarget.m_20189_());
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public void setInWeb() {
    }

    @Override
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return potioneffectIn.m_19544_() != MobEffects.f_19614_ && super.m_7301_(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setAnimation(ANIMATION_SPAWN);
        this.setSize(0.5f + this.f_19796_.m_188501_() * 1.15f);
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN, ANIMATION_BITE};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean shouldFear() {
        return true;
    }

    @Override
    public Entity getCommander() {
        return null;
    }

    @Override
    public boolean m_7307_(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.m_7307_(entityIn);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return SoundEvents.f_12434_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    public float m_6100_() {
        return super.m_6100_() * 0.7f;
    }

    public float m_6134_() {
        return this.getSize();
    }
}

