/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.registry;

import gardensofthedead.GardensOfTheDead;
import gardensofthedead.mixin.WoodTypeInvoker;
import gardensofthedead.registry.ModBlockSetTypes;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;

public class ModWoodTypes {
    public static final Set<WoodType> VALUES = new HashSet<WoodType>();
    public static final WoodType SOULBLIGHT = ModWoodTypes.createNetherWoodType("soulblight", ModBlockSetTypes.SOULBLIGHT);
    public static final WoodType WHISTLECANE = ModWoodTypes.createBambooWoodType("whistlecane", ModBlockSetTypes.WHISTLECANE);

    private static WoodType createNetherWoodType(String name, BlockSetType blockSetType) {
        return ModWoodTypes.create(name, blockSetType, SoundType.f_244244_, SoundType.f_256908_, SoundEvents.f_244593_, SoundEvents.f_244579_);
    }

    private static WoodType createBambooWoodType(String name, BlockSetType blockSetType) {
        return ModWoodTypes.create(name, blockSetType, SoundType.f_243772_, SoundType.f_256995_, SoundEvents.f_243721_, SoundEvents.f_244336_);
    }

    private static WoodType create(String id, BlockSetType blockSetType, SoundType soundType, SoundType hangingSignSoundType, SoundEvent fenceGateCloseSound, SoundEvent fenceGateOpenSound) {
        String name = GardensOfTheDead.id(id).toString();
        WoodType result = new WoodType(name, blockSetType, soundType, hangingSignSoundType, fenceGateCloseSound, fenceGateOpenSound);
        WoodTypeInvoker.invokerRegister(result);
        VALUES.add(result);
        return result;
    }

    public static void register() {
        for (WoodType woodType : VALUES) {
            String name = new ResourceLocation(woodType.f_61839_()).m_135815_();
            Sheets.f_110743_.put(woodType, new Material(Sheets.f_110739_, GardensOfTheDead.id("entity/signs/" + name)));
            Sheets.f_244291_.put(woodType, new Material(Sheets.f_110739_, GardensOfTheDead.id("entity/signs/hanging/" + name)));
        }
    }
}

