/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.registry;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;

public class ModSoundTypes {
    public static final SoundType WHISTLECANE = Builder.copy(SoundType.f_56754_).setPitch(0.5f).build();

    private static class Builder {
        private float volume = 1.0f;
        private float pitch = 1.0f;
        Supplier<SoundEvent> breakSound;
        Supplier<SoundEvent> stepSound;
        Supplier<SoundEvent> placeSound;
        Supplier<SoundEvent> hitSound;
        Supplier<SoundEvent> fallSound;

        private Builder() {
        }

        public static Builder copy(SoundType soundType) {
            return new Builder().setVolume(soundType.m_56773_()).setPitch(soundType.m_56774_()).setBreakSound(() -> ((SoundType)soundType).m_56775_()).setStepSound(() -> ((SoundType)soundType).m_56776_()).setPlaceSound(() -> ((SoundType)soundType).m_56777_()).setHitSound(() -> ((SoundType)soundType).m_56778_()).setFallSound(() -> ((SoundType)soundType).m_56779_());
        }

        public SoundType build() {
            return new CustomSoundType(this.volume, this.pitch, this.breakSound, this.stepSound, this.placeSound, this.hitSound, this.fallSound);
        }

        public Builder setVolume(float volume) {
            this.volume = volume;
            return this;
        }

        public Builder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder setBreakSound(Supplier<SoundEvent> breakSound) {
            this.breakSound = breakSound;
            return this;
        }

        public Builder setStepSound(Supplier<SoundEvent> stepSound) {
            this.stepSound = stepSound;
            return this;
        }

        public Builder setPlaceSound(Supplier<SoundEvent> placeSound) {
            this.placeSound = placeSound;
            return this;
        }

        public Builder setHitSound(Supplier<SoundEvent> hitSound) {
            this.hitSound = hitSound;
            return this;
        }

        public Builder setFallSound(Supplier<SoundEvent> fallSound) {
            this.fallSound = fallSound;
            return this;
        }
    }

    private static class CustomSoundType
    extends SoundType {
        private final Supplier<SoundEvent> breakSound;
        private final Supplier<SoundEvent> stepSound;
        private final Supplier<SoundEvent> placeSound;
        private final Supplier<SoundEvent> hitSound;
        private final Supplier<SoundEvent> fallSound;

        public CustomSoundType(float volume, float pitch, Supplier<SoundEvent> breakSound, Supplier<SoundEvent> stepSound, Supplier<SoundEvent> placeSound, Supplier<SoundEvent> hitSound, Supplier<SoundEvent> fallSound) {
            super(volume, pitch, null, null, null, null, null);
            this.breakSound = breakSound;
            this.stepSound = stepSound;
            this.placeSound = placeSound;
            this.hitSound = hitSound;
            this.fallSound = fallSound;
        }

        public SoundEvent m_56775_() {
            return this.breakSound.get();
        }

        public SoundEvent m_56776_() {
            return this.stepSound.get();
        }

        public SoundEvent m_56777_() {
            return this.placeSound.get();
        }

        public SoundEvent m_56778_() {
            return this.hitSound.get();
        }

        public SoundEvent m_56779_() {
            return this.fallSound.get();
        }
    }
}

