/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.mixin.render.MissingTextureAtlasSpriteAccessor;
import org.figuramc.figura.mixin.render.TextureAtlasAccessor;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import org.luaj.vm2.LuaError;

public class TextureCustomization {
    private final FiguraTextureSet.OverrideType first;
    private final Object second;

    public TextureCustomization(FiguraTextureSet.OverrideType first, Object second) {
        this.first = first;
        this.second = second;
    }

    public FiguraTextureSet.OverrideType getOverrideType() {
        return this.first;
    }

    public Object getValue() {
        return this.second;
    }

    public FiguraTexture getTexture(Avatar avatar, FiguraTextureSet textureSet) {
        if (avatar.render == null) {
            return null;
        }
        ResourceLocation resourceLocation = textureSet.getOverrideTexture(avatar.owner, this);
        String name = resourceLocation.toString();
        if (avatar.renderer.customTextures.containsKey(name)) {
            return avatar.renderer.customTextures.get(name);
        }
        try {
            TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(resourceLocation);
            atlas.m_117966_();
            TextureAtlasAccessor atlasAccessor = (TextureAtlasAccessor)atlas;
            NativeImage nativeImage = new NativeImage(atlasAccessor.getWidth(), atlasAccessor.getHeight(), false);
            nativeImage.m_85045_(0, false);
            return avatar.registerTexture(name, nativeImage, false);
        }
        catch (Exception atlas) {
            try {
                Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation);
                NativeImage image = resource.isPresent() ? NativeImage.m_85058_((InputStream)((Resource)resource.get()).m_215507_()) : MissingTextureAtlasSpriteAccessor.generateImage(16, 16);
                return avatar.registerTexture(name, image, false);
            }
            catch (Exception e) {
                throw new LuaError(e.getMessage());
            }
        }
    }
}

