/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AbstractSkullBlock;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.ducks.SkullBlockRendererAccessor;
import org.figuramc.figura.lua.api.vanilla_model.VanillaModelPart;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public abstract class ItemInHandRendererMixin {
    @Shadow
    private ItemStack f_109300_;
    @Unique
    Avatar avatar;

    @Shadow
    protected abstract void m_109346_(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Inject(method={"renderHandsWithItems"}, at={@At(value="HEAD")})
    private void onRenderHandsWithItems(float tickDelta, PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, LocalPlayer player, int light, CallbackInfo ci) {
        this.avatar = AvatarManager.getAvatarForPlayer(player.m_20148_());
        if (this.avatar == null) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this.avatar);
        FiguraMod.pushProfiler("renderEvent");
        this.avatar.renderMode = EntityRenderMode.FIRST_PERSON;
        this.avatar.renderEvent(tickDelta, new FiguraMat4().set(matrices.m_85850_().m_252922_()));
        FiguraMod.popProfiler(3);
    }

    @Inject(method={"renderHandsWithItems"}, at={@At(value="RETURN")})
    private void afterRenderHandsWithItems(float tickDelta, PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, LocalPlayer player, int light, CallbackInfo ci) {
        if (this.avatar == null) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this.avatar);
        FiguraMod.pushProfiler("postRenderEvent");
        this.avatar.postRenderEvent(tickDelta, new FiguraMat4().set(matrices.m_85850_().m_252922_()));
        this.avatar = null;
        FiguraMod.popProfiler(3);
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderArmWithItem(AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float swingProgress, ItemStack item, float equipProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        VanillaModelPart part;
        boolean willRenderArm;
        if (player.m_150108_() || this.avatar == null || this.avatar.luaRuntime == null) {
            return;
        }
        boolean main = hand == InteractionHand.MAIN_HAND;
        HumanoidArm arm = main ? player.m_5737_() : player.m_5737_().m_20828_();
        Boolean armVisible = arm == HumanoidArm.LEFT ? this.avatar.luaRuntime.renderer.renderLeftArm : this.avatar.luaRuntime.renderer.renderRightArm;
        boolean willRenderItem = !item.m_41619_();
        boolean bl = willRenderArm = !willRenderItem && main || item.m_150930_(Items.f_42573_) || !willRenderItem && this.f_109300_.m_150930_(Items.f_42573_);
        if (willRenderArm && !willRenderItem && armVisible != null && !armVisible.booleanValue()) {
            ci.cancel();
            return;
        }
        if (!willRenderArm && !player.m_20145_() && armVisible != null && armVisible.booleanValue()) {
            matrices.m_85836_();
            this.m_109346_(matrices, vertexConsumers, light, equipProgress, swingProgress, arm);
            matrices.m_85849_();
        }
        VanillaModelPart vanillaModelPart = part = arm == HumanoidArm.LEFT ? this.avatar.luaRuntime.vanilla_model.LEFT_ITEM : this.avatar.luaRuntime.vanilla_model.RIGHT_ITEM;
        if (willRenderItem && !part.checkVisible()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderStatic(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/level/Level;III)V")})
    private void renderItem(LivingEntity entity, ItemStack stack, ItemDisplayContext itemDisplayContext, boolean leftHanded, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        BlockItem bl;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (bl = (BlockItem)item).m_40614_() instanceof AbstractSkullBlock) {
            SkullBlockRendererAccessor.setEntity((Entity)entity);
            SkullBlockRendererAccessor.setRenderMode(switch (itemDisplayContext) {
                case ItemDisplayContext.FIRST_PERSON_LEFT_HAND -> SkullBlockRendererAccessor.SkullRenderMode.FIRST_PERSON_LEFT_HAND;
                case ItemDisplayContext.FIRST_PERSON_RIGHT_HAND -> SkullBlockRendererAccessor.SkullRenderMode.FIRST_PERSON_RIGHT_HAND;
                case ItemDisplayContext.THIRD_PERSON_LEFT_HAND -> SkullBlockRendererAccessor.SkullRenderMode.THIRD_PERSON_LEFT_HAND;
                case ItemDisplayContext.THIRD_PERSON_RIGHT_HAND -> SkullBlockRendererAccessor.SkullRenderMode.THIRD_PERSON_RIGHT_HAND;
                default -> leftHanded ? SkullBlockRendererAccessor.SkullRenderMode.THIRD_PERSON_LEFT_HAND : SkullBlockRendererAccessor.SkullRenderMode.THIRD_PERSON_RIGHT_HAND;
            });
        }
    }
}

