/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.layers.elytra;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.mixin.render.layers.elytra.ElytraModelAccessor;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.PlatformUtils;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ElytraLayer.class})
public abstract class ElytraLayerMixin<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @Shadow
    @Final
    private ElytraModel<T> f_116935_;
    @Shadow
    @Final
    private static ResourceLocation f_116934_;
    @Unique
    private VanillaPart vanillaPart;
    @Unique
    private Avatar figura$avatar;
    @Unique
    private boolean renderedPivot;

    public ElytraLayerMixin(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void setAvatar(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        this.figura$avatar = AvatarManager.getAvatar(livingEntity);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/ElytraModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V", shift=At.Shift.AFTER)}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void onRender(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        this.vanillaPart = null;
        if (this.figura$avatar == null) {
            return;
        }
        if (this.figura$avatar.luaRuntime != null) {
            VanillaGroupPart part = this.figura$avatar.luaRuntime.vanilla_model.ELYTRA;
            ((VanillaPart)part).save((EntityModel<?>)this.f_116935_);
            if (this.figura$avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                this.vanillaPart = part;
                this.vanillaPart.preTransform((EntityModel<?>)this.f_116935_);
            }
        }
        this.figura$avatar.elytraRender((Entity)livingEntity, multiBufferSource, poseStack, light, tickDelta, (EntityModel<?>)this.f_116935_);
        if (this.vanillaPart != null) {
            this.vanillaPart.posTransform((EntityModel<?>)this.f_116935_);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/ElytraModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, cancellable=true)
    public void cancelVanillaPart(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        if (this.vanillaPart != null) {
            this.vanillaPart.restore((EntityModel<?>)this.f_116935_);
        }
        this.renderedPivot = true;
        this.renderElytraPivot(poseStack, multiBufferSource, light, livingEntity, limbAngle, limbDistance, tickDelta, animationProgress);
        if (this.renderedPivot) {
            poseStack.m_85849_();
            ci.cancel();
        }
    }

    public void renderElytraPivot(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress) {
        ItemStack itemStack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        if (!itemStack.m_150930_(Items.f_42741_) && !PlatformUtils.isModLoaded("origins")) {
            return;
        }
        if (this.figura$avatar != null && this.figura$avatar.luaRuntime != null && this.figura$avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1 && this.figura$avatar.luaRuntime.vanilla_model.ELYTRA.checkVisible()) {
            boolean rightWing;
            boolean leftWing;
            AbstractClientPlayer abstractClientPlayer;
            this.f_116935_.m_6973_(livingEntity, limbAngle, limbDistance, tickDelta, (float)light, animationProgress);
            VanillaPart part = RenderUtils.pivotToPart(this.figura$avatar, ParentType.LeftElytraPivot);
            ResourceLocation resourceLocation = livingEntity instanceof AbstractClientPlayer ? ((abstractClientPlayer = (AbstractClientPlayer)livingEntity).m_108562_() && abstractClientPlayer.m_108563_() != null ? abstractClientPlayer.m_108563_() : (abstractClientPlayer.m_108555_() && abstractClientPlayer.m_108561_() != null && abstractClientPlayer.m_36170_(PlayerModelPart.CAPE) ? abstractClientPlayer.m_108561_() : f_116934_)) : f_116934_;
            VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)resourceLocation), (boolean)false, (boolean)itemStack.m_41790_());
            if (part != null && part.checkVisible() && !(leftWing = this.figura$avatar.pivotPartRender(ParentType.LeftElytraPivot, stack -> {
                stack.m_85836_();
                stack.m_85841_(16.0f, 16.0f, 16.0f);
                stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_252880_(0.0f, 0.0f, 0.125f);
                ((ElytraModelAccessor)this.f_116935_).getLeftWing().m_104306_(stack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                stack.m_85849_();
            }))) {
                ((ElytraModelAccessor)this.f_116935_).getLeftWing().m_104306_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if ((part = RenderUtils.pivotToPart(this.figura$avatar, ParentType.RightElytraPivot)) != null && part.checkVisible() && !(rightWing = this.figura$avatar.pivotPartRender(ParentType.RightElytraPivot, stack -> {
                stack.m_85836_();
                stack.m_85841_(16.0f, 16.0f, 16.0f);
                stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_252880_(0.0f, 0.0f, 0.125f);
                ((ElytraModelAccessor)this.f_116935_).getRightWing().m_104306_(stack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                stack.m_85849_();
            }))) {
                ((ElytraModelAccessor)this.f_116935_).getRightWing().m_104306_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.renderedPivot = this.figura$avatar != null && this.figura$avatar.luaRuntime != null && this.figura$avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1 && !this.figura$avatar.luaRuntime.vanilla_model.ELYTRA.checkVisible();
        }
    }
}

