/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.ducks.PlayerModelAccessor;
import org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Unique
    private Avatar avatar;

    public CapeLayerMixin(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="HEAD")})
    private void preRender(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        ItemStack itemStack = entity.m_6844_(EquipmentSlot.CHEST);
        if (entity.m_20145_() || itemStack.m_150930_(Items.f_42741_)) {
            return;
        }
        this.avatar = AvatarManager.getAvatar((Entity)entity);
        if (this.avatar == null) {
            return;
        }
        ModelPart fakeCloak = ((PlayerModelAccessor)this.m_117386_()).figura$getFakeCloak();
        ModelPart realCloak = ((PlayerModelAccessor)this.m_117386_()).figura$getCloak();
        fakeCloak.m_104315_(realCloak);
        double d = Mth.m_14139_((double)tickDelta, (double)entity.f_36102_, (double)entity.f_36105_) - Mth.m_14139_((double)tickDelta, (double)entity.f_19854_, (double)entity.m_20185_());
        double e = Mth.m_14139_((double)tickDelta, (double)entity.f_36103_, (double)entity.f_36106_) - Mth.m_14139_((double)tickDelta, (double)entity.f_19855_, (double)entity.m_20186_());
        double m = Mth.m_14139_((double)tickDelta, (double)entity.f_36104_, (double)entity.f_36075_) - Mth.m_14139_((double)tickDelta, (double)entity.f_19856_, (double)entity.m_20189_());
        float n = Mth.m_14189_((float)tickDelta, (float)entity.f_20884_, (float)entity.f_20883_);
        n = (float)Math.toRadians(n);
        double o = Mth.m_14031_((float)n);
        double p = -Mth.m_14089_((float)n);
        float q = (float)e * 10.0f;
        q = Mth.m_14036_((float)q, (float)-6.0f, (float)32.0f);
        float r = (float)(d * o + m * p) * 100.0f;
        r = Mth.m_14036_((float)r, (float)0.0f, (float)150.0f);
        float s = (float)(d * p - m * o) * 100.0f;
        s = Mth.m_14036_((float)s, (float)-20.0f, (float)20.0f);
        r = Math.max(r, 0.0f);
        float t = Mth.m_14179_((float)tickDelta, (float)entity.f_36099_, (float)entity.f_36100_);
        q += Mth.m_14031_((float)(Mth.m_14179_((float)tickDelta, (float)entity.f_19867_, (float)entity.f_19787_) * 6.0f)) * 32.0f * t;
        if (itemStack.m_41619_() || this.avatar.luaRuntime != null && !this.avatar.luaRuntime.vanilla_model.CHESTPLATE_BODY.checkVisible()) {
            if (entity.m_6047_()) {
                q += 25.0f;
                fakeCloak.f_104201_ = 2.25f;
                fakeCloak.f_104202_ = -0.25f;
            } else {
                fakeCloak.f_104201_ = 0.0f;
                fakeCloak.f_104202_ = 0.0f;
            }
        } else if (entity.m_6047_()) {
            q += 25.0f;
            fakeCloak.f_104201_ = 0.85f;
            fakeCloak.f_104202_ = 0.15f;
        } else {
            fakeCloak.f_104201_ = -1.0f;
            fakeCloak.f_104202_ = 1.0f;
        }
        fakeCloak.m_171327_((float)Math.toRadians(6.0f + r / 2.0f + q), (float)(-Math.toRadians(s / 2.0f)), (float)Math.toRadians(s / 2.0f));
        if (this.avatar.luaRuntime != null) {
            VanillaGroupPart part = this.avatar.luaRuntime.vanilla_model.CAPE;
            EntityModel model = this.m_117386_();
            ((VanillaPart)part).save(model);
            if (this.avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                ((VanillaPart)part).preTransform(model);
            }
        }
        this.avatar.capeRender((Entity)entity, multiBufferSource, poseStack, light, tickDelta, fakeCloak);
        if (RenderUtils.vanillaModelAndScript(this.avatar)) {
            this.avatar.luaRuntime.vanilla_model.CAPE.posTransform(this.m_117386_());
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="RETURN")})
    private void postRender(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (this.avatar == null) {
            return;
        }
        if (this.avatar.luaRuntime != null) {
            this.avatar.luaRuntime.vanilla_model.CAPE.restore(this.m_117386_());
        }
        this.avatar = null;
    }
}

