/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.gui.ActionWheel;
import org.figuramc.figura.gui.FiguraGui;
import org.figuramc.figura.lua.api.RendererAPI;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class GuiMixin {
    @Shadow
    @Final
    private Minecraft f_92986_;
    @Unique
    private FiguraVec2 crosshairOffset;

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    private void onRender(GuiGraphics guiGraphics, float tickDelta, CallbackInfo ci) {
        FiguraGui.onRender(guiGraphics, tickDelta, ci);
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    private void afterRender(GuiGraphics guiGraphics, float tickDelta, CallbackInfo ci) {
        if (!AvatarManager.panic) {
            FiguraGui.renderOverlays(guiGraphics);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderCrosshair"}, cancellable=true)
    private void renderCrosshair(GuiGraphics guiGraphics, CallbackInfo ci) {
        Avatar avatar;
        this.crosshairOffset = null;
        if (ActionWheel.isEnabled()) {
            ci.cancel();
            return;
        }
        Entity entity = this.f_92986_.m_91288_();
        if (entity == null || (avatar = AvatarManager.getAvatar(entity)) == null || avatar.luaRuntime == null) {
            return;
        }
        RendererAPI renderer = avatar.luaRuntime.renderer;
        if (!renderer.renderCrosshair) {
            ci.cancel();
            return;
        }
        this.crosshairOffset = renderer.crosshairOffset;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V")}, method={"renderCrosshair"})
    private void blitRenderCrosshair(GuiGraphics guiGraphics, CallbackInfo ci) {
        if (this.crosshairOffset != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(this.crosshairOffset.x, this.crosshairOffset.y, 0.0);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V", shift=At.Shift.AFTER)}, method={"renderCrosshair"})
    private void afterBlitRenderCrosshair(GuiGraphics guiGraphics, CallbackInfo ci) {
        if (this.crosshairOffset != null) {
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

