/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.docs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.lua.docs.FiguraDocsManager;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraClientCommandSource;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;

public abstract class FiguraDoc {
    public static final MutableComponent HEADER = Component.m_237119_().m_130948_(ColorUtils.Colors.AWESOME_BLUE.style).m_7220_((Component)Component.m_237113_((String)"\n\u2022*+\u2022* ").m_7220_((Component)FiguraText.of()).m_130946_(" Docs *\u2022+*\u2022").m_130940_(ChatFormatting.UNDERLINE));
    public final String name;
    public final String description;

    public FiguraDoc(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public abstract int print();

    public LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder command = LiteralArgumentBuilder.literal((String)this.name);
        command.executes(context -> this.print());
        return command;
    }

    public JsonObject toJson(boolean translate) {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("description", (String)(translate ? Language.m_128107_().m_6834_(FiguraText.of("docs." + this.description).getString()) : "figura.docs." + this.description));
        return json;
    }

    public static int printRoot() {
        FiguraMod.sendChatMessage((Component)HEADER.m_6881_().m_130946_("\n\n").m_7220_((Component)FiguraText.of("docs").m_130948_(ColorUtils.Colors.BLUE.style)));
        return 1;
    }

    public static class FieldDoc
    extends FiguraDoc {
        public final Class<?> type;
        public final boolean editable;
        public final List<FiguraDoc> children;

        public FieldDoc(Field field, LuaFieldDoc luaFieldDoc, List<FiguraDoc> children) {
            super(field.getName(), luaFieldDoc.value());
            this.type = field.getType();
            this.editable = !Modifier.isFinal(field.getModifiers());
            this.children = children;
        }

        @Override
        public int print() {
            MutableComponent message = HEADER.m_6881_().m_130946_("\n\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_7220_((Component)FiguraText.of("docs.text.field")).m_130946_(":").m_130948_(ColorUtils.Colors.PURPLE.style)).m_130946_("\n\t").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_130948_(ColorUtils.Colors.BLUE.style)).m_7220_((Component)FiguraDocsManager.getClassText(this.type).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(" " + this.name)).m_130948_(ColorUtils.Colors.BLUE.style)).m_7220_((Component)Component.m_237113_((String)" (").m_7220_((Component)FiguraText.of(this.editable ? "docs.text.editable" : "docs.text.not_editable")).m_130946_(")").m_130940_(this.editable ? ChatFormatting.GREEN : ChatFormatting.DARK_RED));
            message.m_130946_("\n\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_7220_((Component)FiguraText.of("docs.text.description")).m_130946_(":").m_130948_(ColorUtils.Colors.PURPLE.style));
            MutableComponent descText = Component.m_237119_().m_130948_(ColorUtils.Colors.BLUE.style);
            for (Component component : TextUtils.splitText((FormattedText)FiguraText.of("docs." + this.description), "\n")) {
                descText.m_130946_("\n\t").m_130946_("\u2022 ").m_7220_(component);
            }
            message.m_7220_((Component)descText);
            FiguraMod.sendChatMessage((Component)message);
            return 1;
        }

        @Override
        public LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
            LiteralArgumentBuilder<FiguraClientCommandSource> command = super.getCommand();
            if (this.children != null) {
                for (FiguraDoc child : this.children) {
                    command.then(child.getCommand());
                }
            }
            return command;
        }

        @Override
        public JsonObject toJson(boolean translate) {
            JsonObject json = super.toJson(translate);
            json.addProperty("type", FiguraDocsManager.getNameFor(this.type));
            json.addProperty("editable", Boolean.valueOf(this.editable));
            JsonArray children = new JsonArray();
            if (this.children != null) {
                for (FiguraDoc child : this.children) {
                    children.add((JsonElement)child.toJson(translate));
                }
            }
            json.add("children", (JsonElement)children);
            return json;
        }
    }

    public static class MethodDoc
    extends FiguraDoc {
        public final Class<?>[][] parameterTypes;
        public final String[][] parameterNames;
        public final Class<?>[] returnTypes;
        public final String typeName;
        public final String[] aliases;
        public final boolean isStatic;
        public final List<FiguraDoc> children;

        public MethodDoc(Method method, LuaMethodDoc methodDoc, List<FiguraDoc> children, String typeName) {
            super(method.getName(), methodDoc.value());
            LuaMethodOverload[] overloads = methodDoc.overloads();
            this.parameterTypes = new Class[overloads.length][];
            this.parameterNames = new String[overloads.length][];
            this.returnTypes = new Class[overloads.length];
            this.isStatic = Modifier.isStatic(method.getModifiers());
            this.aliases = methodDoc.aliases();
            this.typeName = typeName;
            this.children = children;
            for (int i = 0; i < overloads.length; ++i) {
                this.parameterTypes[i] = overloads[i].argumentTypes();
                this.parameterNames[i] = overloads[i].argumentNames();
                this.returnTypes[i] = overloads[i].returnType() == LuaMethodOverload.DEFAULT.class ? method.getReturnType() : overloads[i].returnType();
            }
        }

        @Override
        public int print() {
            MutableComponent message = HEADER.m_6881_();
            message.m_130946_("\n\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_7220_((Component)FiguraText.of("docs.text.function")).m_130946_(":").m_130948_(ColorUtils.Colors.PURPLE.style)).m_130946_("\n\t").m_7220_((Component)Component.m_237113_((String)("\u2022 " + this.name)).m_130948_(ColorUtils.Colors.BLUE.style));
            if (this.aliases.length > 0) {
                message.m_130946_("\n\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_7220_((Component)FiguraText.of("docs.text.aliases")).m_130946_(":").m_130948_(ColorUtils.Colors.PURPLE.style));
                for (String alias : this.aliases) {
                    message.m_130946_("\n\t").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_130946_(alias).m_130948_(ColorUtils.Colors.BLUE.style));
                }
            }
            message.m_130946_("\n\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_7220_((Component)FiguraText.of("docs.text.syntax")).m_130946_(":").m_130948_(ColorUtils.Colors.PURPLE.style));
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                message.m_130946_("\n\t").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_130948_(ColorUtils.Colors.BLUE.style)).m_7220_((Component)Component.m_237113_((String)("<" + this.typeName + ">")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(this.isStatic ? "." : ":")).m_130940_(ChatFormatting.BOLD)).m_7220_((Component)Component.m_237113_((String)this.name).m_130948_(ColorUtils.Colors.BLUE.style)).m_130946_("(");
                for (int j = 0; j < this.parameterTypes[i].length; ++j) {
                    message.m_7220_((Component)FiguraDocsManager.getClassText(this.parameterTypes[i][j]).m_130940_(ChatFormatting.YELLOW)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)this.parameterNames[i][j]).m_130940_(ChatFormatting.WHITE));
                    if (j == this.parameterTypes[i].length - 1) continue;
                    message.m_130946_(", ");
                }
                message.m_130946_(") \u2192 ").m_7220_((Component)FiguraText.of("docs.text.returns").m_130946_(" ").m_130948_(ColorUtils.Colors.BLUE.style)).m_7220_((Component)FiguraDocsManager.getClassText(this.returnTypes[i]).m_130940_(ChatFormatting.YELLOW));
            }
            message.m_130946_("\n\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_7220_((Component)FiguraText.of("docs.text.description")).m_130946_(":").m_130948_(ColorUtils.Colors.PURPLE.style));
            MutableComponent descText = Component.m_237119_().m_130948_(ColorUtils.Colors.BLUE.style);
            for (Component component : TextUtils.splitText((FormattedText)FiguraText.of("docs." + this.description), "\n")) {
                descText.m_130946_("\n\t").m_130946_("\u2022 ").m_7220_(component);
            }
            message.m_7220_((Component)descText);
            FiguraMod.sendChatMessage((Component)message);
            return 1;
        }

        @Override
        public LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
            LiteralArgumentBuilder<FiguraClientCommandSource> command = super.getCommand();
            if (this.children != null) {
                for (FiguraDoc child : this.children) {
                    command.then(child.getCommand());
                }
            }
            return command;
        }

        @Override
        public JsonObject toJson(boolean translate) {
            JsonObject json = super.toJson(translate);
            JsonArray params = new JsonArray();
            for (int i = 0; i < this.parameterNames.length; ++i) {
                Class<?>[] param = new JsonArray();
                for (int j = 0; j < this.parameterNames[i].length; ++j) {
                    JsonObject paramObj = new JsonObject();
                    paramObj.addProperty("name", this.parameterNames[i][j]);
                    paramObj.addProperty("type", FiguraDocsManager.getNameFor(this.parameterTypes[i][j]));
                    param.add((JsonElement)paramObj);
                }
                params.add(param);
            }
            json.add("parameters", (JsonElement)params);
            JsonArray returns = new JsonArray();
            for (Class<?> returnType : this.returnTypes) {
                returns.add(FiguraDocsManager.getNameFor(returnType));
            }
            json.add("returns", (JsonElement)returns);
            JsonArray aliases = new JsonArray();
            for (String alias : this.aliases) {
                aliases.add(alias);
            }
            json.add("aliases", (JsonElement)aliases);
            JsonArray children = new JsonArray();
            if (this.children != null) {
                for (FiguraDoc child : this.children) {
                    children.add((JsonElement)child.toJson(translate));
                }
            }
            json.add("children", (JsonElement)children);
            json.addProperty("static", Boolean.valueOf(this.isStatic));
            return json;
        }
    }

    public static class ClassDoc
    extends FiguraDoc {
        public final ArrayList<MethodDoc> documentedMethods;
        public final ArrayList<FieldDoc> documentedFields;
        public final Class<?> thisClass;
        public final Class<?> superclass;

        public ClassDoc(Class<?> clazz, LuaTypeDoc typeDoc) {
            this(clazz, typeDoc, null);
        }

        public ClassDoc(Class<?> clazz, LuaTypeDoc typeDoc, Map<String, List<FiguraDoc>> children) {
            super(typeDoc.name(), typeDoc.value());
            this.thisClass = clazz;
            this.superclass = clazz.getSuperclass().isAnnotationPresent(LuaTypeDoc.class) ? clazz.getSuperclass() : null;
            this.documentedMethods = new ArrayList();
            HashSet<String> foundIndices = new HashSet<String>();
            for (Method method : clazz.getDeclaredMethods()) {
                this.parseMethodIfNeeded(foundIndices, children, typeDoc, method);
            }
            for (Method method : clazz.getMethods()) {
                this.parseMethodIfNeeded(foundIndices, children, typeDoc, method);
            }
            this.documentedFields = new ArrayList();
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                this.parseFieldIfNeeded(children, foundIndices, (Field)accessibleObject);
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                this.parseFieldIfNeeded(children, foundIndices, (Field)accessibleObject);
            }
        }

        private void parseMethodIfNeeded(Set<String> foundIndices, Map<String, List<FiguraDoc>> children, LuaTypeDoc typeDoc, Method method) {
            String name = method.getName();
            if (foundIndices.contains(name) || !method.isAnnotationPresent(LuaMethodDoc.class)) {
                return;
            }
            foundIndices.add(name);
            LuaMethodDoc doc = method.getAnnotation(LuaMethodDoc.class);
            List<FiguraDoc> childList = children == null ? null : children.get(name);
            this.documentedMethods.add(new MethodDoc(method, doc, childList, typeDoc.name()));
        }

        private void parseFieldIfNeeded(Map<String, List<FiguraDoc>> children, Set<String> foundIndices, Field field) {
            String name = field.getName();
            if (foundIndices.contains(name) || !field.isAnnotationPresent(LuaFieldDoc.class)) {
                return;
            }
            foundIndices.add(name);
            List<FiguraDoc> childList = children == null ? null : children.get(name);
            this.documentedFields.add(new FieldDoc(field, field.getAnnotation(LuaFieldDoc.class), childList));
        }

        @Override
        public int print() {
            MutableComponent message = HEADER.m_6881_().m_130946_("\n\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_7220_((Component)FiguraText.of("docs.text.type")).m_130946_(":").m_130948_(ColorUtils.Colors.PURPLE.style));
            message.m_130946_("\n\t").m_7220_((Component)Component.m_237113_((String)("\u2022 " + this.name)).m_130948_(ColorUtils.Colors.BLUE.style));
            if (this.superclass != null) {
                message.m_130946_(" (").m_7220_((Component)FiguraText.of("docs.text.extends")).m_130946_(" ").m_7220_((Component)FiguraDocsManager.getClassText(this.superclass).m_130940_(ChatFormatting.YELLOW)).m_130946_(")");
            }
            message.m_130946_("\n\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_7220_((Component)FiguraText.of("docs.text.description")).m_130946_(":").m_130948_(ColorUtils.Colors.PURPLE.style));
            MutableComponent descText = Component.m_237119_().m_130948_(ColorUtils.Colors.BLUE.style);
            for (Component component : TextUtils.splitText((FormattedText)FiguraText.of("docs." + this.description), "\n")) {
                descText.m_130946_("\n\t").m_130946_("\u2022 ").m_7220_(component);
            }
            message.m_7220_((Component)descText);
            FiguraMod.sendChatMessage((Component)message);
            return 1;
        }

        @Override
        public LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
            LiteralArgumentBuilder<FiguraClientCommandSource> command = super.getCommand();
            for (MethodDoc methodDoc : this.documentedMethods) {
                command.then(methodDoc.getCommand());
            }
            for (FieldDoc fieldDoc : this.documentedFields) {
                command.then(fieldDoc.getCommand());
            }
            return command;
        }

        @Override
        public JsonObject toJson(boolean translate) {
            JsonObject json = super.toJson(translate);
            if (this.superclass != null) {
                json.addProperty("parent", FiguraDocsManager.getNameFor(this.superclass));
            }
            JsonArray methods = new JsonArray();
            for (MethodDoc methodDoc : this.documentedMethods) {
                methods.add((JsonElement)methodDoc.toJson(translate));
            }
            json.add("methods", (JsonElement)methods);
            JsonArray fields = new JsonArray();
            for (FieldDoc fieldDoc : this.documentedFields) {
                fields.add((JsonElement)fieldDoc.toJson(translate));
            }
            json.add("fields", (JsonElement)fields);
            return json;
        }
    }
}

