/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="ItemStack", value="itemstack")
public class ItemStackAPI {
    public final ItemStack itemStack;
    @LuaWhitelist
    @LuaFieldDoc(value="itemstack.id")
    public final String id;
    @LuaWhitelist
    @LuaFieldDoc(value="itemstack.tag")
    public final LuaTable tag;

    public static ItemStackAPI verify(ItemStack itemStack) {
        if (itemStack == null || itemStack == ItemStack.f_41583_) {
            itemStack = Items.f_41852_.m_7968_();
        }
        return new ItemStackAPI(itemStack);
    }

    public ItemStackAPI(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.id = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).toString();
        this.tag = new ReadOnlyLuaTable((LuaValue)(itemStack.m_41783_() != null ? NbtToLua.convert((Tag)itemStack.m_41783_()) : new LuaTable()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_id")
    public String getID() {
        return this.id;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_tag")
    public LuaTable getTag() {
        return this.tag;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_count")
    public int getCount() {
        return this.itemStack.m_41613_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_damage")
    public int getDamage() {
        return this.itemStack.m_41773_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_pop_time")
    public int getPopTime() {
        return this.itemStack.m_41612_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.has_glint")
    public boolean hasGlint() {
        return this.itemStack.m_41790_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_tags")
    public List<String> getTags() {
        ArrayList<String> list = new ArrayList<String>();
        Registry registry = WorldAPI.getCurrentWorld().m_9598_().m_175515_(Registries.f_256913_);
        Optional key = registry.m_7854_((Object)this.itemStack.m_41720_());
        if (key.isEmpty()) {
            return list;
        }
        for (TagKey itemTagKey : registry.m_246971_((ResourceKey)key.get()).m_203616_().toList()) {
            list.add(itemTagKey.f_203868_().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_block_item")
    public boolean isBlockItem() {
        return this.itemStack.m_41720_() instanceof BlockItem;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_food")
    public boolean isFood() {
        return this.itemStack.m_41614_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_use_action")
    public String getUseAction() {
        return this.itemStack.m_41780_().name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_name")
    public String getName() {
        return this.itemStack.m_41786_().getString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_max_count")
    public int getMaxCount() {
        return this.itemStack.m_41741_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_rarity")
    public String getRarity() {
        return this.itemStack.m_41791_().name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_enchantable")
    public boolean isEnchantable() {
        return this.itemStack.m_41792_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_max_damage")
    public int getMaxDamage() {
        return this.itemStack.m_41776_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_damageable")
    public boolean isDamageable() {
        return this.itemStack.m_41763_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_stackable")
    public boolean isStackable() {
        return this.itemStack.m_41753_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_repair_cost")
    public int getRepairCost() {
        return this.itemStack.m_41610_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_use_duration")
    public int getUseDuration() {
        return this.itemStack.m_41779_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.to_stack_string")
    public String toStackString() {
        ItemStack stack = this.itemStack;
        Object ret = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            ret = (String)ret + nbt.toString();
        }
        return ret;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_armor")
    public boolean isArmor() {
        return this.itemStack.m_41720_() instanceof ArmorItem;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_tool")
    public boolean isTool() {
        return this.itemStack.m_41720_() instanceof DiggerItem;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_equipment_slot")
    public String getEquipmentSlot() {
        return LivingEntity.m_147233_((ItemStack)this.itemStack).name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.copy")
    public ItemStackAPI copy() {
        return new ItemStackAPI(this.itemStack.m_41777_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_blockstate")
    public BlockStateAPI getBlockstate() {
        BlockStateAPI blockStateAPI;
        Item item = this.itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockStateAPI = new BlockStateAPI(blockItem.m_40614_().m_49966_(), null);
        } else {
            blockStateAPI = null;
        }
        return blockStateAPI;
    }

    @LuaWhitelist
    public boolean __eq(ItemStackAPI other) {
        if (this == other) {
            return true;
        }
        ItemStack t = this.itemStack;
        ItemStack o = other.itemStack;
        if (t.m_41613_() != o.m_41613_()) {
            return false;
        }
        if (!t.m_150930_(o.m_41720_())) {
            return false;
        }
        CompoundTag tag1 = t.m_41783_();
        CompoundTag tag2 = o.m_41783_();
        if (tag1 == null && tag2 != null) {
            return false;
        }
        return tag1 == null || tag1.equals((Object)tag2);
    }

    @LuaWhitelist
    public Object __index(String arg) {
        if (arg == null) {
            return null;
        }
        return switch (arg) {
            case "id" -> this.id;
            case "tag" -> this.tag;
            default -> null;
        };
    }

    public String toString() {
        return this.id + " x" + this.getCount() + " (ItemStack)";
    }
}

