/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.figuramc.figura.animation.Animation;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaTypeDoc;

@LuaWhitelist
@LuaTypeDoc(name="AnimationAPI", value="animations")
public class AnimationAPI {
    private final Map<String, Map<String, Animation>> animTable;
    private final Avatar avatar;

    public AnimationAPI(Avatar avatar) {
        this.avatar = avatar;
        this.animTable = AnimationAPI.generateAnimTable(avatar);
    }

    private static Map<String, Map<String, Animation>> generateAnimTable(Avatar avatar) {
        HashMap<String, Map<String, Animation>> root = new HashMap<String, Map<String, Animation>>();
        for (Animation animation : avatar.animations.values()) {
            Map<String, Animation> animations = root.get(animation.modelName);
            if (animations == null) {
                animations = new HashMap<String, Animation>();
            }
            animations.put(animation.name, animation);
            root.put(animation.modelName, animations);
        }
        return root;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="animations.get_animations")
    public List<Animation> getAnimations() {
        ArrayList<Animation> list = new ArrayList<Animation>();
        for (Map<String, Animation> value : this.animTable.values()) {
            list.addAll(value.values());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="animations.get_playing")
    public List<Animation> getPlaying() {
        ArrayList<Animation> list = new ArrayList<Animation>();
        for (Animation animation : this.avatar.animations.values()) {
            if (animation.playState != Animation.PlayState.PLAYING) continue;
            list.add(animation);
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="animations.stop_all")
    public AnimationAPI stopAll() {
        for (Animation animation : this.avatar.animations.values()) {
            animation.stop();
        }
        return this;
    }

    @LuaWhitelist
    public Map<String, Animation> __index(String val) {
        return val == null ? null : this.animTable.get(val);
    }

    public String toString() {
        return "AnimationsAPI";
    }
}

