/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.gui.screens.PermissionsScreen;
import org.figuramc.figura.gui.widgets.SearchBar;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.gui.widgets.permissions.AbstractPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.CategoryPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.PlayerPermPackElement;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class PlayerList
extends AbstractList {
    private final HashMap<UUID, PlayerPermPackElement> players = new HashMap();
    private final HashSet<UUID> missingPlayers = new HashSet();
    private final ArrayList<AbstractPermPackElement> permissionsList = new ArrayList();
    public final PermissionsScreen parent;
    private final SearchBar searchBar;
    private final SwitchButton showFigura;
    private final SwitchButton showDisconnected;
    private static boolean showFiguraBl;
    private static boolean showDisconnectedBl;
    private final int entryWidth;
    private int totalHeight = 0;
    private AbstractPermPackElement maxCategory;
    public AbstractPermPackElement selectedEntry;
    private String filter = "";

    public PlayerList(int x, int y, int width, int height, PermissionsScreen parent) {
        super(x, y, width, height);
        this.updateScissors(1, 24, -2, -25);
        this.parent = parent;
        this.entryWidth = Math.min(width - this.scrollBar.m_5711_() - 12, 174);
        this.scrollBar.m_253211_(y + 28);
        this.scrollBar.setHeight(height - 32);
        this.searchBar = new SearchBar(x + 4, y + 4, width - 56, 20, s -> {
            if (!this.filter.equals(s)) {
                this.scrollBar.setScrollProgress(0.0);
            }
            this.filter = s;
        });
        this.children.add(this.searchBar);
        this.showFigura = new SwitchButton(x + width - 48, y + 4, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/show_figura.png"), 60, 40, (Component)FiguraText.of("gui.permissions.figura_only.tooltip"), button -> {
            showFiguraBl = ((SwitchButton)button).isToggled();
        });
        this.children.add(this.showFigura);
        this.showFigura.setToggled(showFiguraBl);
        this.showDisconnected = new SwitchButton(x + width - 24, y + 4, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/show_disconnected.png"), 60, 40, (Component)FiguraText.of("gui.permissions.disconnected.tooltip"), button -> {
            showDisconnectedBl = ((SwitchButton)button).isToggled();
        });
        this.children.add(this.showDisconnected);
        this.showDisconnected.setToggled(showDisconnectedBl);
        this.loadGroups();
        this.loadPlayers();
        this.selectLocalPlayer();
    }

    @Override
    public void tick() {
        this.loadPlayers();
        super.tick();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.totalHeight = 0;
        for (AbstractPermPackElement pack : this.permissionsList) {
            if (!pack.isVisible()) continue;
            this.totalHeight += pack.m_93694_() + 8;
        }
        boolean hasScrollbar = this.totalHeight > height - 32;
        this.scrollBar.setVisible(hasScrollbar);
        this.scrollBar.setScrollRatio(this.permissionsList.isEmpty() ? 0.0 : (double)((float)this.totalHeight / (float)this.permissionsList.size()), this.totalHeight - (height - 32));
        this.scissorsWidth = hasScrollbar ? -this.scrollBar.m_5711_() - 5 : -2;
        this.enableScissors(gui);
        int xOffset = (width - this.entryWidth - (this.scrollBar.isVisible() ? 13 : 0)) / 2;
        int playerY = this.scrollBar.isVisible() ? (int)(-Mth.m_14139_((double)this.scrollBar.getScrollProgress(), (double)-32.0, (double)(this.totalHeight - height))) : 32;
        int minY = y + this.scissorsY;
        int maxY = minY + height + this.scissorsHeight;
        for (AbstractPermPackElement pack : this.permissionsList) {
            if (!pack.isVisible()) continue;
            pack.m_252865_(x + xOffset);
            pack.m_253211_(y + playerY);
            if (pack.m_252907_() + pack.m_93694_() > minY && pack.m_252907_() < maxY) {
                pack.m_88315_(gui, mouseX, mouseY, delta);
            }
            playerY += pack.m_93694_() + 8;
        }
        gui.m_280618_();
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    @Override
    public List<? extends GuiEventListener> contents() {
        return this.permissionsList;
    }

    private void loadGroups() {
        for (PermissionPack permissionPack : PermissionManager.CATEGORIES.values()) {
            CategoryPermPackElement group = new CategoryPermPackElement(this.entryWidth, permissionPack, this);
            this.permissionsList.add(group);
            this.children.add(group);
            this.maxCategory = group;
        }
    }

    private void loadPlayers() {
        PlayerPermPackElement player;
        this.missingPlayers.clear();
        this.missingPlayers.addAll(this.players.keySet());
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        ArrayList playerList = connection == null ? List.of() : new ArrayList(connection.m_105143_());
        for (UUID uuid2 : playerList) {
            PlayerInfo player2 = connection.m_104949_(uuid2);
            if (player2 == null) continue;
            String name = player2.m_105312_().getName();
            ResourceLocation skin = player2.m_105337_();
            Avatar avatar = AvatarManager.getAvatarForPlayer(uuid2);
            if (!name.toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !uuid2.toString().contains(this.filter.toLowerCase(Locale.US)) || this.showFigura.isToggled() && !FiguraMod.isLocal(uuid2) && (avatar == null || avatar.nbt == null)) continue;
            this.missingPlayers.remove(uuid2);
            PlayerPermPackElement element = this.players.computeIfAbsent(uuid2, uuid1 -> {
                PlayerPermPackElement entry = new PlayerPermPackElement(this.entryWidth, name, PermissionManager.get(uuid1), skin, (UUID)uuid1, this);
                this.permissionsList.add(entry);
                this.children.add(entry);
                return entry;
            });
            element.disconnected = false;
        }
        if (this.filter.isEmpty() && this.showDisconnected.isToggled()) {
            for (Avatar avatar : AvatarManager.getLoadedAvatars()) {
                UUID id = avatar.owner;
                if (playerList.contains(id)) continue;
                this.missingPlayers.remove(id);
                PlayerPermPackElement element = this.players.computeIfAbsent(id, uuid -> {
                    PlayerPermPackElement entry = new PlayerPermPackElement(this.entryWidth, avatar.entityName, PermissionManager.get(uuid), null, (UUID)uuid, this);
                    this.permissionsList.add(entry);
                    this.children.add(entry);
                    return entry;
                });
                element.disconnected = true;
            }
        }
        for (UUID missingID : this.missingPlayers) {
            PlayerPermPackElement entry = this.players.remove(missingID);
            this.permissionsList.remove(entry);
            this.children.remove(entry);
        }
        this.sortList();
        AbstractPermPackElement abstractPermPackElement = this.selectedEntry;
        if (abstractPermPackElement instanceof PlayerPermPackElement && this.missingPlayers.contains((player = (PlayerPermPackElement)abstractPermPackElement).getOwner())) {
            this.selectLocalPlayer();
        }
    }

    private void sortList() {
        this.permissionsList.sort(AbstractPermPackElement::compareTo);
        this.children.sort((element1, element2) -> {
            if (element1 instanceof AbstractPermPackElement) {
                AbstractPermPackElement container1 = (AbstractPermPackElement)element1;
                if (element2 instanceof AbstractPermPackElement) {
                    AbstractPermPackElement container2 = (AbstractPermPackElement)element2;
                    return container1.compareTo(container2);
                }
            }
            return 0;
        });
    }

    private void selectLocalPlayer() {
        AbstractPermPackElement local;
        AbstractPermPackElement abstractPermPackElement = local = Minecraft.m_91087_().f_91074_ != null ? this.players.get(Minecraft.m_91087_().f_91074_.m_20148_()) : null;
        if (local != null) {
            local.m_5691_();
        } else {
            this.maxCategory.m_5691_();
        }
        this.scrollToSelected();
    }

    public void updateScroll() {
        double pastScroll = (double)(this.totalHeight - this.m_93694_()) * this.scrollBar.getScrollProgress();
        this.totalHeight = 0;
        for (AbstractPermPackElement pack : this.permissionsList) {
            if (!pack.isVisible()) continue;
            this.totalHeight += pack.m_93694_() + 8;
        }
        this.scrollBar.setScrollProgress(pastScroll / (double)(this.totalHeight - this.m_93694_()));
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.scrollBar.m_253211_(y + 28);
        this.searchBar.m_253211_(y + 4);
        this.showFigura.m_253211_(y + 4);
        this.showDisconnected.m_253211_(y + 4);
    }

    public int getCategoryAt(double y) {
        int ret = -1;
        for (AbstractPermPackElement element : this.permissionsList) {
            CategoryPermPackElement group;
            if (!(element instanceof CategoryPermPackElement) || !(group = (CategoryPermPackElement)element).isVisible() || !(y >= (double)group.m_252907_())) continue;
            ++ret;
        }
        return Math.max(ret, 0);
    }

    public void scrollToSelected() {
        double y = 0.0;
        this.totalHeight = 0;
        for (AbstractPermPackElement pack : this.permissionsList) {
            if (pack instanceof PlayerPermPackElement && !pack.isVisible()) continue;
            if (pack == this.selectedEntry) {
                y = this.totalHeight;
                continue;
            }
            this.totalHeight += pack.m_93694_() + 8;
        }
        this.scrollBar.setScrollProgressNoAnim(y / (double)this.totalHeight);
    }
}

