/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.screens.AvatarWizardScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.SearchBar;
import org.figuramc.figura.gui.widgets.avatar.AbstractAvatarWidget;
import org.figuramc.figura.gui.widgets.avatar.AvatarFolderWidget;
import org.figuramc.figura.gui.widgets.avatar.AvatarWidget;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class AvatarList
extends AbstractList {
    private final HashMap<Path, AbstractAvatarWidget> avatars = new HashMap();
    private final ArrayList<AbstractAvatarWidget> avatarList = new ArrayList();
    private int totalHeight = 0;
    private String filter = "";
    public static Path selectedEntry;

    public AvatarList(int x, int y, int width, int height, AbstractPanelScreen parentScreen) {
        super(x, y, width, height);
        this.children.add(new SearchBar(x + 4, y + 4, width - 8, 20, s -> {
            if (!this.filter.equals(s)) {
                this.scrollBar.setScrollProgress(0.0);
            }
            this.filter = s;
        }));
        this.children.add(new Button(x + width / 2 - 46, y + 28, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/new_avatar.png"), 60, 20, (Component)FiguraText.of("gui.wardrobe.new_avatar.tooltip"), button -> Minecraft.m_91087_().m_91152_((Screen)new AvatarWizardScreen(parentScreen))));
        this.children.add(new Button(x + width / 2 - 10, y + 28, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/unselect.png"), 60, 20, (Component)FiguraText.of("gui.wardrobe.unselect.tooltip"), button -> {
            AvatarManager.loadLocalAvatar(null);
            selectedEntry = null;
        }));
        this.children.add(new Button(x + width / 2 + 26, y + 28, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/folder.png"), 60, 20, (Component)FiguraText.of("gui.wardrobe.folder.tooltip"), button -> Util.m_137581_().m_137648_(LocalAvatarFetcher.getLocalAvatarDirectory().toUri())));
        this.scrollBar.m_253211_(y + 48);
        this.scrollBar.setHeight(height - 52);
        this.updateScissors(1, 49, -2, -50);
        this.loadContents();
        this.scrollToSelected();
    }

    @Override
    public void tick() {
        this.loadContents();
        super.tick();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        this.totalHeight = 2;
        for (AbstractAvatarWidget avatar : this.avatarList) {
            this.totalHeight += avatar.m_93694_() + 2;
        }
        int entryHeight = this.avatarList.isEmpty() ? 0 : this.totalHeight / this.avatarList.size();
        this.scrollBar.setVisible(this.totalHeight > height - 49);
        this.scrollBar.setScrollRatio(entryHeight, this.totalHeight - (height - 49));
        int xOffset = this.scrollBar.isVisible() ? 4 : 11;
        int yOffset = this.scrollBar.isVisible() ? (int)(-Mth.m_14139_((double)this.scrollBar.getScrollProgress(), (double)-49.0, (double)(this.totalHeight - height))) : 49;
        boolean hidden = false;
        for (AbstractAvatarWidget avatar : this.avatarList) {
            if (hidden) continue;
            avatar.m_252865_(x + xOffset);
            avatar.m_253211_(y + yOffset);
            if (avatar.m_252907_() + avatar.m_93694_() > y + this.scissorsY) {
                avatar.m_88315_(gui, mouseX, mouseY, delta);
            }
            if ((yOffset += avatar.m_93694_() + 2) <= height) continue;
            hidden = true;
        }
        gui.m_280618_();
        super.m_88315_(gui, mouseX, mouseY, delta);
        if (!LocalAvatarFetcher.isLoaded()) {
            UIHelper.renderLoading(gui, x + width / 2, y + height / 2);
        }
    }

    private void loadContents() {
        LocalAvatarFetcher.reloadAvatars();
        HashSet<Path> missingPaths = new HashSet<Path>(this.avatars.keySet());
        for (LocalAvatarFetcher.AvatarPath avatar : List.copyOf(LocalAvatarFetcher.ALL_AVATARS)) {
            Path path = avatar.getTheActualPathForThis();
            if (!avatar.search(this.filter)) continue;
            AbstractAvatarWidget widget = this.avatars.get(path);
            if (widget != null) {
                widget.update(avatar, this.filter);
            }
            missingPaths.remove(path);
            this.avatars.computeIfAbsent(path, p -> {
                AbstractAvatarWidget abstractAvatarWidget;
                int width = this.m_5711_() - 22;
                if (avatar instanceof LocalAvatarFetcher.FolderPath) {
                    LocalAvatarFetcher.FolderPath folder = (LocalAvatarFetcher.FolderPath)avatar;
                    abstractAvatarWidget = new AvatarFolderWidget(0, width, folder, this);
                } else {
                    abstractAvatarWidget = new AvatarWidget(0, width, avatar, this);
                }
                AbstractAvatarWidget entry = abstractAvatarWidget;
                this.avatarList.add(entry);
                this.children.add(entry);
                return entry;
            });
        }
        for (Path missingPath : missingPaths) {
            AbstractAvatarWidget obj = this.avatars.remove(missingPath);
            this.avatarList.remove(obj);
            this.children.remove(obj);
        }
        this.avatarList.sort(AbstractAvatarWidget::compareTo);
        this.children.sort((children1, children2) -> {
            if (children1 instanceof AbstractAvatarWidget) {
                AbstractAvatarWidget avatar1 = (AbstractAvatarWidget)children1;
                if (children2 instanceof AbstractAvatarWidget) {
                    AbstractAvatarWidget avatar2 = (AbstractAvatarWidget)children2;
                    return avatar1.compareTo(avatar2);
                }
            }
            return 0;
        });
    }

    public void updateScroll() {
        double pastScroll = (double)(this.totalHeight - this.m_93694_()) * this.scrollBar.getScrollProgress();
        this.totalHeight = 2;
        for (AbstractAvatarWidget avatar : this.avatarList) {
            this.totalHeight += avatar.m_93694_() + 2;
        }
        this.scrollBar.setScrollProgress(pastScroll / (double)(this.totalHeight - this.m_93694_()));
    }

    public void scrollToSelected() {
        double y = 0.0;
        this.totalHeight = 0;
        for (AbstractAvatarWidget avatar : this.avatarList) {
            if (avatar.isOf(selectedEntry)) {
                y = this.totalHeight;
                continue;
            }
            this.totalHeight += avatar.m_93694_() + 2;
        }
        this.scrollBar.setScrollProgressNoAnim(y / (double)this.totalHeight);
    }

    @Override
    public List<? extends GuiEventListener> contents() {
        return this.avatarList;
    }
}

