/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.ConfigScreen;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.ContainerButton;
import org.figuramc.figura.gui.widgets.config.AbstractConfigElement;
import org.figuramc.figura.gui.widgets.config.BooleanElement;
import org.figuramc.figura.gui.widgets.config.ButtonElement;
import org.figuramc.figura.gui.widgets.config.EnumElement;
import org.figuramc.figura.gui.widgets.config.InputElement;
import org.figuramc.figura.gui.widgets.config.KeybindElement;
import org.figuramc.figura.gui.widgets.lists.ConfigList;
import org.figuramc.figura.utils.ui.UIHelper;

public class CategoryWidget
extends AbstractContainerElement {
    protected final List<AbstractConfigElement> entries = new ArrayList<AbstractConfigElement>();
    private final ConfigType.Category config;
    private final ConfigList parent;
    private ContainerButton parentConfig;

    public CategoryWidget(int width, ConfigType.Category config, ConfigList parent) {
        super(0, 0, width, 20);
        this.config = config;
        this.parent = parent;
        this.parentConfig = new ContainerButton(parent, 0, 0, width, 20, (Component)(config == null ? Component.m_237119_() : config.name), config == null ? null : config.tooltip, button -> {
            boolean toggled = this.parentConfig.isToggled();
            this.setShowChildren(toggled);
            ConfigScreen.CATEGORY_DATA.put(config, toggled);
            parent.updateScroll();
        });
        Boolean expanded = ConfigScreen.CATEGORY_DATA.get(config);
        this.parentConfig.setToggled(expanded == null || expanded != false);
        this.parentConfig.shouldHaveBackground(false);
        this.children.add(this.parentConfig);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        if (this.parentConfig.isToggled() && this.entries.size() > 0) {
            gui.m_280509_(this.m_252754_(), this.m_252907_() + 21, this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), 0x11FFFFFF);
        }
        if (this.config == Configs.PAPERDOLL) {
            this.parent.parentScreen.renderPaperdoll = this.parentConfig.isToggled() && this.parent.m_5953_(mouseX, mouseY) && this.m_5953_(mouseX, mouseY);
        }
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return UIHelper.isMouseOver(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), mouseX, mouseY);
    }

    public void addConfig(ConfigType<?> config) {
        AbstractConfigElement element;
        if (config.hidden && !FiguraMod.debugModeEnabled()) {
            return;
        }
        int width = this.m_5711_();
        if (config instanceof ConfigType.BoolConfig) {
            ConfigType.BoolConfig boolConfig = (ConfigType.BoolConfig)config;
            element = new BooleanElement(width, boolConfig, this.parent, this);
        } else if (config instanceof ConfigType.EnumConfig) {
            ConfigType.EnumConfig enumConfig = (ConfigType.EnumConfig)config;
            element = new EnumElement(width, enumConfig, this.parent, this);
        } else if (config instanceof ConfigType.InputConfig) {
            ConfigType.InputConfig inputConfig = (ConfigType.InputConfig)config;
            element = new InputElement(width, inputConfig, this.parent, this);
        } else if (config instanceof ConfigType.KeybindConfig) {
            ConfigType.KeybindConfig keybindConfig = (ConfigType.KeybindConfig)config;
            element = new KeybindElement(width, keybindConfig, this.parent, this);
        } else if (config instanceof ConfigType.ButtonConfig) {
            ConfigType.ButtonConfig buttonConfig = (ConfigType.ButtonConfig)config;
            element = new ButtonElement(width, buttonConfig, this.parent, this);
        } else {
            return;
        }
        this.setHeight(super.m_93694_() + 22);
        this.children.add(element);
        this.entries.add(element);
    }

    public boolean isChanged() {
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int m_93694_() {
        if (!this.parentConfig.isToggled()) {
            return 20;
        }
        int height = 20;
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isVisible()) continue;
            height += entry.m_93694_() + 2;
        }
        return height;
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.parentConfig.m_252865_(x);
        for (AbstractConfigElement entry : this.entries) {
            entry.m_252865_(x);
        }
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.parentConfig.m_253211_(y);
        int i = 0;
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isVisible()) continue;
            entry.m_253211_(y + 22 * (i + 1));
            ++i;
        }
    }

    public void setShowChildren(boolean bool) {
        this.parentConfig.setToggled(bool);
        for (AbstractConfigElement element : this.entries) {
            element.setVisible(bool);
        }
    }

    public boolean isShowingChildren() {
        return this.parentConfig.isToggled();
    }

    public void updateKeybinds() {
        for (AbstractConfigElement element : this.entries) {
            if (!(element instanceof KeybindElement)) continue;
            KeybindElement keybind = (KeybindElement)element;
            keybind.updateText();
        }
    }

    public void updateFilter(String query) {
        boolean visible = false;
        for (AbstractConfigElement entry : this.entries) {
            entry.updateFilter(query);
            visible |= entry.matchesFilter();
        }
        this.setVisible(visible);
        if (visible) {
            this.m_253211_(this.m_252907_());
        }
        this.parent.updateScroll();
    }
}

