/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class ContainerButton
extends SwitchButton {
    private final AbstractList parent;

    public ContainerButton(AbstractList parent, int x, int y, int width, int height, Component text, Component tooltip, Button.OnPress pressAction) {
        super(x, y, width, height, text, tooltip, pressAction);
        this.parent = parent;
    }

    @Override
    protected void renderText(GuiGraphics gui, float delta) {
        Font font = Minecraft.m_91087_().f_91062_;
        int color = this.getTextColor();
        Component arrow = this.toggled ? UIHelper.DOWN_ARROW : UIHelper.UP_ARROW;
        int arrowWidth = font.m_92852_((FormattedText)arrow);
        Component message = TextUtils.trimToWidthEllipsis(font, this.m_6035_(), this.m_5711_() - arrowWidth - 6, (Component)TextUtils.ELLIPSIS.m_6881_().m_130948_(this.m_6035_().m_7383_()));
        int n = this.m_252754_() + arrowWidth + 6;
        float f = (float)this.m_252907_() + (float)this.m_93694_() / 2.0f;
        Objects.requireNonNull(font);
        gui.m_280430_(font, message, n, (int)(f - 9.0f / 2.0f), color);
        int n2 = this.m_252754_() + 3;
        float f2 = (float)this.m_252907_() + (float)this.m_93694_() / 2.0f;
        Objects.requireNonNull(font);
        gui.m_280430_(font, arrow, n2, (int)(f2 - 9.0f / 2.0f), color);
        if (message != this.m_6035_()) {
            this.setTooltip(this.m_6035_());
        }
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return this.parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
    }

    @Override
    protected int getTextColor() {
        return !this.isToggled() ? ChatFormatting.DARK_GRAY.m_126665_().intValue() : super.getTextColor();
    }
}

