/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.EntityPreview;
import org.figuramc.figura.gui.widgets.SliderWidget;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.lists.PermissionsList;
import org.figuramc.figura.gui.widgets.lists.PlayerList;
import org.figuramc.figura.gui.widgets.permissions.AbstractPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.PlayerPermPackElement;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class PermissionsScreen
extends AbstractPanelScreen {
    private PlayerList playerList;
    private EntityPreview entityWidget;
    private SliderWidget slider;
    private PermissionsList permissionsList;
    private SwitchButton expandButton;
    private Button reloadAll;
    private Button back;
    private Button resetButton;
    private SwitchButton precisePermissions;
    private float listYPrecise;
    private float expandYPrecise;
    private float resetYPrecise;
    private boolean expanded;
    private PlayerPermPackElement dragged = null;

    public PermissionsScreen(Screen parentScreen) {
        super(parentScreen, (Component)FiguraText.of("gui.panels.title.permissions"));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int middle = this.f_96543_ / 2;
        int listWidth = Math.min(middle - 6, 208);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        int entitySize = (int)Math.min((double)(this.f_96544_ - 95) - (double)lineHeight * 1.5 - (double)(FiguraMod.debugModeEnabled() ? 24 : 0), (double)listWidth);
        int modelSize = 11 * entitySize / 29;
        int entityX = Math.max(middle + (listWidth - entitySize) / 2 + 1, middle + 2);
        this.entityWidget = new EntityPreview(entityX, 28, entitySize, entitySize, modelSize, -15.0f, 30.0f, (LivingEntity)Minecraft.m_91087_().f_91074_, this);
        this.slider = new SliderWidget(middle + 2, (int)((double)(this.entityWidget.m_252907_() + this.entityWidget.m_93694_()) + (double)lineHeight * 1.5 + 20.0), listWidth, 11, 1.0, 5, true){

            @Override
            public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
                super.m_87963_(gui, mouseX, mouseY, delta);
                PermissionPack selectedPack = PermissionsScreen.this.playerList.selectedEntry.getPack();
                MutableComponent text = selectedPack.getCategoryName();
                int x = (int)((float)this.m_252754_() + (float)this.m_5711_() / 2.0f - (float)PermissionsScreen.this.f_96547_.m_92852_((FormattedText)text) * 0.75f);
                int n = this.m_252907_() - 4;
                Objects.requireNonNull(PermissionsScreen.this.f_96547_);
                int y = n - 9 * 2;
                PoseStack pose = gui.m_280168_();
                pose.m_85836_();
                pose.m_252880_((float)x, (float)y, 0.0f);
                pose.m_85841_(1.5f, 1.5f, 1.0f);
                UIHelper.renderOutlineText(gui, PermissionsScreen.this.f_96547_, (Component)text, 0, 0, 0xFFFFFF, 0x202020);
                pose.m_85849_();
                MutableComponent info = Component.m_237113_((String)"?").m_130948_(Style.f_131099_.m_131150_(UIHelper.UI_FONT));
                int color = 0x404040;
                int width = PermissionsScreen.this.f_96547_.m_92852_((FormattedText)info);
                x = Math.min((int)((float)x + (float)PermissionsScreen.this.f_96547_.m_92852_((FormattedText)text) * 1.5f + (float)PermissionsScreen.this.f_96547_.m_92895_("  ")), PermissionsScreen.this.f_96543_ - width);
                float f = y;
                Objects.requireNonNull(PermissionsScreen.this.f_96547_);
                y = (int)(f + 9.0f * 0.25f);
                Objects.requireNonNull(PermissionsScreen.this.f_96547_);
                if (UIHelper.isMouseOver(x, y, width, 9, mouseX, mouseY)) {
                    color = 0xFFFFFF;
                    UIHelper.setTooltip((Component)selectedPack.getCategory().info);
                }
                gui.m_280430_(PermissionsScreen.this.f_96547_, (Component)info, x, y, color);
            }
        };
        this.permissionsList = new PermissionsList(middle + 2, this.f_96544_, listWidth, this.f_96544_ - 54);
        this.playerList = new PlayerList(middle - listWidth - 2, 28, listWidth, this.f_96544_ - 32, this);
        this.m_142416_((GuiEventListener)this.playerList);
        this.m_142416_((GuiEventListener)this.entityWidget);
        this.m_142416_((GuiEventListener)this.slider);
        int bottomButtonsWidth = (listWidth - 24) / 2 - 2;
        this.reloadAll = new Button(middle + 2, this.f_96544_ - 24, bottomButtonsWidth, 20, (Component)FiguraText.of("gui.permissions.reload_all"), null, bx -> {
            AvatarManager.clearAllAvatars();
            FiguraToast.sendToast(FiguraText.of("toast.reload_all"));
        });
        this.m_142416_((GuiEventListener)this.reloadAll);
        this.back = new Button(middle + 6 + bottomButtonsWidth, this.f_96544_ - 24, bottomButtonsWidth, 20, (Component)FiguraText.of("gui.done"), null, bx -> this.m_7379_());
        this.m_142416_((GuiEventListener)this.back);
        this.expandButton = new SwitchButton(middle + listWidth - 18, this.f_96544_ - 24, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/expand_v.png"), 60, 40, (Component)FiguraText.of("gui.permissions.expand_permissions.tooltip"), btn -> {
            this.expanded = this.expandButton.isToggled();
            this.entityWidget.setVisible(!this.expanded);
            this.slider.setVisible(!this.expanded);
            this.slider.setActive(!this.expanded);
            this.reloadAll.setVisible(!this.expanded);
            this.back.setVisible(!this.expanded);
            this.expandButton.setTooltip((Component)(this.expanded ? FiguraText.of("gui.permissions.minimize_permissions.tooltip") : FiguraText.of("gui.permissions.expand_permissions.tooltip")));
            this.resetButton.setActive(this.expanded);
        });
        this.m_142416_((GuiEventListener)this.expandButton);
        this.resetButton = new Button(middle + 2, this.f_96544_, 60, 20, (Component)FiguraText.of("gui.permissions.reset"), null, btn -> {
            PermissionPack pack = this.playerList.selectedEntry.getPack();
            pack.clear();
            this.updatePermissions(pack);
        });
        this.m_142416_((GuiEventListener)this.resetButton);
        this.precisePermissions = new SwitchButton(middle + 66, this.f_96544_, listWidth - 88, 20, (Component)FiguraText.of("gui.permissions.precise"), false){

            @Override
            public void m_5691_() {
                super.m_5691_();
                PermissionsScreen.this.permissionsList.precise = this.isToggled();
                PermissionsScreen.this.permissionsList.updateList(PermissionsScreen.this.playerList.selectedEntry.getPack());
            }
        };
        this.m_142416_((GuiEventListener)this.precisePermissions);
        this.precisePermissions.setUnderline(false);
        this.m_142416_((GuiEventListener)this.permissionsList);
        this.listYPrecise = this.permissionsList.m_252907_();
        this.expandYPrecise = this.expandButton.m_252907_();
        this.resetYPrecise = this.resetButton.m_252907_();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        AbstractPermPackElement entity = this.playerList.selectedEntry;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null && entity instanceof PlayerPermPackElement) {
            PlayerPermPackElement player = (PlayerPermPackElement)entity;
            this.entityWidget.setEntity((LivingEntity)world.m_46003_(UUID.fromString(player.getPack().name)));
        } else {
            this.entityWidget.setEntity(null);
        }
        float lerpDelta = MathUtils.magicDelta(0.6f, delta);
        this.listYPrecise = Mth.m_14179_((float)lerpDelta, (float)this.listYPrecise, (float)(this.expandButton.isToggled() ? 50.0f : (float)(this.f_96544_ + 1)));
        this.permissionsList.m_253211_((int)this.listYPrecise);
        this.expandYPrecise = Mth.m_14179_((float)lerpDelta, (float)this.expandYPrecise, (float)(this.expandButton.isToggled() ? this.listYPrecise - 22.0f : this.listYPrecise - 24.0f));
        this.expandButton.m_253211_((int)this.expandYPrecise);
        this.resetYPrecise = Mth.m_14179_((float)lerpDelta, (float)this.resetYPrecise, (float)(this.expandButton.isToggled() ? this.listYPrecise - 22.0f : (float)this.f_96544_));
        this.resetButton.m_253211_((int)this.resetYPrecise);
        this.precisePermissions.m_253211_((int)this.resetYPrecise);
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    @Override
    public void renderOverlays(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (this.dragged != null && this.dragged.dragged) {
            this.dragged.renderDragged(gui, mouseX, mouseY, delta);
        }
        super.renderOverlays(gui, mouseX, mouseY, delta);
    }

    public void m_7861_() {
        PermissionManager.saveToDisk();
        super.m_7861_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.expandButton.isToggled()) {
            this.expandButton.m_5691_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        PlayerPermPackElement element;
        AbstractPermPackElement abstractPermPackElement;
        boolean bool = super.m_6375_(mouseX, mouseY, button);
        this.dragged = null;
        if (button == 0 && (abstractPermPackElement = this.playerList.selectedEntry) instanceof PlayerPermPackElement && (element = (PlayerPermPackElement)abstractPermPackElement).m_5953_(mouseX, mouseY)) {
            this.dragged = element;
            element.anchorX = (int)mouseX;
            element.anchorY = (int)mouseY;
            element.initialY = element.m_252907_();
        }
        return bool;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragged != null) {
            this.dragged.index = this.playerList.getCategoryAt(mouseY);
            this.dragged.dragged = true;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean bool = super.m_6348_(mouseX, mouseY, button);
        if (this.dragged == null || !this.dragged.dragged) {
            return bool;
        }
        PermissionPack pack = this.dragged.getPack();
        Permissions.Category category = Permissions.Category.indexOf(Math.min(this.dragged.index, Permissions.Category.values().length - 1));
        pack.setCategory(PermissionManager.CATEGORIES.get((Object)category));
        this.updatePermissions(pack);
        this.dragged.dragged = false;
        this.dragged = null;
        return bool;
    }

    public void updatePermissions(PermissionPack pack) {
        this.slider.setAction(null);
        this.slider.setActive(pack instanceof PermissionPack.PlayerPermissionPack && !this.expanded);
        this.slider.setMax(Permissions.Category.values().length);
        this.slider.setScrollProgress((double)pack.getCategory().index / ((double)this.slider.getMax() - 1.0));
        this.slider.setAction(scroll -> {
            Permissions.Category category = Permissions.Category.indexOf(((SliderWidget)scroll).getIntValue());
            pack.setCategory(PermissionManager.CATEGORIES.get((Object)category));
            this.permissionsList.updateList(pack);
        });
        this.permissionsList.updateList(pack);
    }
}

