/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.animation;

import java.util.List;
import java.util.Map;
import net.minecraft.util.Mth;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.animation.Animation;
import org.figuramc.figura.animation.Interpolation;
import org.figuramc.figura.animation.Keyframe;
import org.figuramc.figura.animation.TransformType;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.model.FiguraModelPart;

public class AnimationPlayer {
    public static int tick(Animation anim, int limit) {
        if (anim.playState == Animation.PlayState.STOPPED) {
            return limit;
        }
        FiguraMod.pushProfiler(anim.name);
        if (anim.playState != Animation.PlayState.PAUSED) {
            anim.tick();
        }
        for (Map.Entry<FiguraModelPart, List<Animation.AnimationChannel>> entry : anim.animationParts) {
            FiguraModelPart part = entry.getKey();
            if (part.lastAnimationPriority > anim.priority) continue;
            FiguraMod.pushProfiler(part.name);
            boolean merge = part.lastAnimationPriority == anim.priority;
            part.lastAnimationPriority = anim.priority;
            part.animated = true;
            for (Animation.AnimationChannel channel : entry.getValue()) {
                float delta;
                int nextIndex;
                Keyframe next;
                if (limit <= 0) {
                    FiguraMod.popProfiler(2);
                    return limit;
                }
                TransformType type = channel.type();
                FiguraMod.pushProfiler(type.name());
                Keyframe[] keyframes = channel.keyframes();
                if (keyframes.length == 0) {
                    FiguraMod.popProfiler(3);
                    return limit;
                }
                int currentIndex = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, index -> anim.frameTime <= keyframes[index].getTime()) - 1);
                Keyframe current = keyframes[currentIndex];
                if (current == (next = keyframes[nextIndex = Math.min(keyframes.length - 1, currentIndex + 1)])) {
                    delta = 0.0f;
                } else {
                    float timeDiff = anim.frameTime - current.getTime();
                    delta = Math.min(Math.max(timeDiff / (next.getTime() - current.getTime()), 0.0f), 1.0f);
                }
                Interpolation interpolation = next.getInterpolation() == Interpolation.BEZIER ? Interpolation.BEZIER : current.getInterpolation();
                FiguraVec3 transform = interpolation.generate(keyframes, currentIndex, nextIndex, anim.blend, delta, type);
                type.apply(part, transform, merge);
                switch (type) {
                    case ROTATION: 
                    case GLOBAL_ROT: {
                        if (anim.getOverrideRot()) {
                            part.animationOverride |= 1;
                            break;
                        }
                        if (merge) break;
                        part.animationOverride &= 6;
                        break;
                    }
                    case POSITION: {
                        if (anim.getOverridePos()) {
                            part.animationOverride |= 2;
                            break;
                        }
                        if (merge) break;
                        part.animationOverride &= 5;
                        break;
                    }
                    case SCALE: {
                        if (anim.getOverrideScale()) {
                            part.animationOverride |= 4;
                            break;
                        }
                        if (merge) break;
                        part.animationOverride &= 3;
                    }
                }
                --limit;
                FiguraMod.popProfiler();
            }
            FiguraMod.popProfiler();
        }
        FiguraMod.popProfiler();
        return limit;
    }

    public static void clear(Animation anim) {
        FiguraVec3 zero = FiguraVec3.of();
        for (Map.Entry<FiguraModelPart, List<Animation.AnimationChannel>> entry : anim.animationParts) {
            FiguraModelPart part = entry.getKey();
            if (!part.animated) continue;
            part.animPosition(zero, false);
            part.animRotation(zero, false);
            part.animScale(FiguraVec3.of(1.0, 1.0, 1.0), false);
            part.lastAnimationPriority = Integer.MIN_VALUE;
            part.animated = false;
            part.animationOverride = 0;
        }
    }
}

