/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.feathers.event;

import com.elenai.feathers.client.ClientFeathersData;
import com.elenai.feathers.client.gui.FeathersHudOverlay;
import com.elenai.feathers.config.FeathersClientConfig;
import com.elenai.feathers.enchantment.FeathersEnchantments;
import com.elenai.feathers.networking.FeathersMessages;
import com.elenai.feathers.networking.packet.RequestWeightCTSPacket;
import com.elenai.feathers.util.ArmorHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientEvents {
    public static int currentWeight;

    @Mod.EventBusSubscriber(modid="feathers", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void clientTickEvents(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START && Minecraft.m_91087_().f_91073_ != null) {
                ClientFeathersData.setOverflowing(ClientFeathersData.getFeathers() > 20);
                if (ClientFeathersData.getAnimationCooldown() > 0) {
                    ClientFeathersData.setAnimationCooldown(ClientFeathersData.getAnimationCooldown() - 1);
                }
                if (ClientFeathersData.getFeathers() != ClientFeathersData.getPreviousFeathers()) {
                    if (ClientFeathersData.getFeathers() > ClientFeathersData.getPreviousFeathers() && ((Boolean)FeathersClientConfig.REGEN_EFFECT.get()).booleanValue()) {
                        ClientFeathersData.setAnimationCooldown(18);
                    }
                    ClientFeathersData.setPreviousFeathers(ClientFeathersData.getFeathers());
                }
                if (((Boolean)FeathersClientConfig.FADE_WHEN_FULL.get()).booleanValue()) {
                    int cooldown = ClientFeathersData.getFadeCooldown();
                    if (ClientFeathersData.getFeathers() == ClientFeathersData.getMaxFeathers() || ClientFeathersData.getEnduranceFeathers() > 0) {
                        if (cooldown < (Integer)FeathersClientConfig.FADE_COOLDOWN.get()) {
                            ClientFeathersData.setFadeCooldown(ClientFeathersData.getFadeCooldown() + 1);
                        }
                    } else {
                        ClientFeathersData.setFadeCooldown(0);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void tooltipRenderer(ItemTooltipEvent event) {
            if (Minecraft.m_91087_().f_91073_ != null && !event.getItemStack().m_41619_() && event.getItemStack().m_41720_() instanceof ArmorItem && ((Boolean)FeathersClientConfig.DISPLAY_WEIGHTS.get()).booleanValue()) {
                FeathersMessages.sendToServer(new RequestWeightCTSPacket(Item.m_41393_((Item)event.getItemStack().m_41720_()), ArmorHandler.getItemEnchantmentLevel((Enchantment)FeathersEnchantments.LIGHTWEIGHT.get(), event.getItemStack()), ArmorHandler.getItemEnchantmentLevel((Enchantment)FeathersEnchantments.HEAVY.get(), event.getItemStack())));
                if (currentWeight > 0) {
                    StringBuilder s = new StringBuilder();
                    List tooltip = event.getToolTip();
                    if (((Boolean)FeathersClientConfig.VISUAL_WEIGHTS.get()).booleanValue()) {
                        for (int i = 2; i <= currentWeight + 1; i += 2) {
                            if (i - 1 == currentWeight) {
                                s.append("b");
                                continue;
                            }
                            s.append("a ");
                        }
                        s.reverse();
                        tooltip.add(Component.m_237113_((String)s.toString()).m_130948_(Style.f_131099_.m_131150_(new ResourceLocation("feathers", "feather_font"))));
                    } else {
                        tooltip.add(Component.m_237110_((String)"text.feathers.tooltip", (Object[])new Object[]{currentWeight}).m_130940_(ChatFormatting.BLUE));
                    }
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="feathers", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAbove(VanillaGuiOverlay.FOOD_LEVEL.id(), "feathers", FeathersHudOverlay.FEATHERS);
        }
    }
}

