/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.feathers.attributes;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="feathers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FeathersAttributes {
    public static final HashMap<RegistryObject<Attribute>, UUID> UUIDS = new HashMap();
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"feathers");
    public static final RegistryObject<Attribute> MAX_FEATHERS = FeathersAttributes.registerAttribute("feathers.max_feathers", (String id) -> new RangedAttribute(id, 20.0, 0.0, 1024.0).m_22084_(true), "1ce4960d-c50e-44bf-ad23-7bcd77f4c1dc");
    public static final RegistryObject<Attribute> FEATHER_REGEN = FeathersAttributes.registerAttribute("feathers.feather_regen", (String id) -> new RangedAttribute(id, 1.0, 0.0, 1024.0).m_22084_(true), "d74ded8f-c5b6-4222-80e2-dbea7ccf8d02");

    public static RegistryObject<Attribute> registerAttribute(String name, Function<String, Attribute> attribute, String uuid) {
        return FeathersAttributes.registerAttribute(name, attribute, UUID.fromString(uuid));
    }

    public static RegistryObject<Attribute> registerAttribute(String name, Function<String, Attribute> attribute, UUID uuid) {
        RegistryObject registryObject = ATTRIBUTES.register(name, () -> (Attribute)attribute.apply(name));
        UUIDS.put((RegistryObject<Attribute>)registryObject, uuid);
        return registryObject;
    }

    public static void register(IEventBus modEventBus) {
        ATTRIBUTES.register(modEventBus);
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
        for (EntityType e : event.getTypes()) {
            if (e != EntityType.f_20532_) continue;
            for (RegistryObject v : ATTRIBUTES.getEntries()) {
                event.add(e, (Attribute)v.get());
            }
        }
    }
}

