/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.feathers.api;

import com.elenai.feathers.attributes.FeathersAttributes;
import com.elenai.feathers.capability.PlayerFeathers;
import com.elenai.feathers.capability.PlayerFeathersProvider;
import com.elenai.feathers.client.ClientFeathersData;
import com.elenai.feathers.config.FeathersCommonConfig;
import com.elenai.feathers.enchantment.FeathersEnchantments;
import com.elenai.feathers.networking.FeathersMessages;
import com.elenai.feathers.networking.packet.ColdSyncSTCPacket;
import com.elenai.feathers.networking.packet.FeatherSyncCTSPacket;
import com.elenai.feathers.networking.packet.FeatherSyncSTCPacket;
import com.elenai.feathers.util.ArmorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;

public class FeathersHelper {
    public static void setFeathers(ServerPlayer player, int feathers) {
        player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
            f.setFeathers(feathers);
            f.setCooldown(0);
            FeathersMessages.sendToPlayer(new FeatherSyncSTCPacket(f.getFeathers(), f.getMaxFeathers(), f.getRegen(), FeathersHelper.getPlayerWeight(player), f.getEnduranceFeathers()), player);
        });
    }

    public static void setMaxFeathers(ServerPlayer player, int feathers) {
        player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
            if (player.m_21133_((Attribute)FeathersAttributes.MAX_FEATHERS.get()) != (double)feathers) {
                player.m_21051_((Attribute)FeathersAttributes.MAX_FEATHERS.get()).m_22100_((double)feathers);
            }
            f.setMaxFeathers(feathers);
            FeathersMessages.sendToPlayer(new FeatherSyncSTCPacket(f.getFeathers(), f.getMaxFeathers(), f.getRegen(), FeathersHelper.getPlayerWeight(player), f.getEnduranceFeathers()), player);
        });
    }

    public static void setFeatherRegen(ServerPlayer player, int ticks) {
        player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
            f.setRegen(ticks);
            FeathersMessages.sendToPlayer(new FeatherSyncSTCPacket(f.getFeathers(), f.getMaxFeathers(), f.getRegen(), FeathersHelper.getPlayerWeight(player), f.getEnduranceFeathers()), player);
        });
    }

    public static int getFeathers(ServerPlayer player) {
        return player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).map(PlayerFeathers::getFeathers).orElse(0);
    }

    public static int getMaxFeathers(ServerPlayer player) {
        return player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).map(PlayerFeathers::getMaxFeathers).orElse(0);
    }

    public static int getFeathers() {
        return ClientFeathersData.getFeathers();
    }

    public static int getMaxFeathers() {
        return ClientFeathersData.getMaxFeathers();
    }

    public static int getEndurance(ServerPlayer player) {
        return player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).map(PlayerFeathers::getEnduranceFeathers).orElse(0);
    }

    public static int getEndurance() {
        return ClientFeathersData.getEnduranceFeathers();
    }

    public static void addFeathers(ServerPlayer player, int feathers) {
        player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
            f.addFeathers(feathers);
            f.setCooldown(0);
            FeathersMessages.sendToPlayer(new FeatherSyncSTCPacket(f.getFeathers(), f.getMaxFeathers(), f.getRegen(), FeathersHelper.getPlayerWeight(player), f.getEnduranceFeathers()), player);
        });
    }

    public static void subFeathers(ServerPlayer player, int feathers) {
        player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
            f.subFeathers(feathers);
            f.setCooldown(0);
            FeathersMessages.sendToPlayer(new FeatherSyncSTCPacket(f.getFeathers(), f.getMaxFeathers(), f.getRegen(), FeathersHelper.getPlayerWeight(player), f.getEnduranceFeathers()), player);
        });
    }

    public static boolean spendFeathers(ServerPlayer player, int feathers) {
        if (player.m_7500_() || player.m_5833_()) {
            return true;
        }
        if (Math.min(FeathersHelper.getPlayerWeight(player), 20) <= FeathersHelper.getFeathers(player) + FeathersHelper.getEndurance(player) - feathers) {
            player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
                int amount = f.getEnduranceFeathers() - feathers;
                if (f.getEnduranceFeathers() > 0) {
                    f.setEnduranceFeathers(Math.max(0, amount));
                }
                if (amount < 0) {
                    f.addFeathers(amount);
                }
                f.setCooldown(0);
                FeathersMessages.sendToPlayer(new FeatherSyncSTCPacket(f.getFeathers(), f.getMaxFeathers(), f.getRegen(), FeathersHelper.getPlayerWeight(player), f.getEnduranceFeathers()), player);
            });
            return true;
        }
        return false;
    }

    public static boolean spendFeathers(int feathers) {
        Minecraft instance = Minecraft.m_91087_();
        if (instance.f_91074_.m_7500_() || instance.f_91074_.m_5833_()) {
            return true;
        }
        if (Math.min(ClientFeathersData.getWeight(), 20) <= FeathersHelper.getFeathers() + FeathersHelper.getEndurance() - feathers) {
            int amount = ClientFeathersData.getEnduranceFeathers() - feathers;
            if (ClientFeathersData.getEnduranceFeathers() > 0) {
                ClientFeathersData.setEnduranceFeathers(Math.max(0, amount));
                ClientFeathersData.setFadeCooldown(0);
            }
            if (amount < 0) {
                ClientFeathersData.setFeathers(ClientFeathersData.getFeathers() + amount);
            }
            FeathersMessages.sendToServer(new FeatherSyncCTSPacket(ClientFeathersData.getFeathers(), ClientFeathersData.getEnduranceFeathers(), 0));
            return true;
        }
        return false;
    }

    public static int getArmorWeight(Item item, int lightweightLevel, int heavyLevel) {
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            return Math.max(ArmorHandler.getArmorWeight(armor) - lightweightLevel + heavyLevel * ArmorHandler.getArmorWeight(armor), 0);
        }
        if (item == Items.f_41852_) {
            return 0;
        }
        return 0;
    }

    public static int getArmorWeightByStack(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            return Math.max(ArmorHandler.getArmorWeight(armor) - ArmorHandler.getItemEnchantmentLevel((Enchantment)FeathersEnchantments.LIGHTWEIGHT.get(), itemStack) + ArmorHandler.getItemEnchantmentLevel((Enchantment)FeathersEnchantments.HEAVY.get(), itemStack) * ArmorHandler.getArmorWeight(armor), 0);
        }
        if (itemStack.m_41720_() == Items.f_41852_) {
            return 0;
        }
        return 0;
    }

    public static int getPlayerWeight(ServerPlayer player) {
        if (!((Boolean)FeathersCommonConfig.ENABLE_ARMOR_WEIGHTS.get()).booleanValue()) {
            return 0;
        }
        int weight = 0;
        for (ItemStack i : player.m_6168_()) {
            weight += FeathersHelper.getArmorWeightByStack(i);
        }
        return weight;
    }

    public static boolean getCold(ServerPlayer player) {
        return player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).map(f -> f.isCold()).orElse(false);
    }

    public static void setCold(ServerPlayer player, boolean cold) {
        player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
            f.setCold(cold);
            FeathersMessages.sendToPlayer(new ColdSyncSTCPacket(f.isCold()), player);
        });
    }

    public static boolean checkFeathersRemaining() {
        return FeathersHelper.getFeathers() + FeathersHelper.getEndurance() > ClientFeathersData.getWeight();
    }
}

