/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item.armor.lib;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public abstract class FAArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    protected FAArmorItem(ArmorItem.Type type, double knockbackResistance, double movementSpeed, double maxHealth, double attackDamage, double attackSpeed, double luck) {
        super((ArmorMaterial)ArmorMaterials.NETHERITE, type, new Item.Properties().m_41487_(1));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (knockbackResistance > 0.0) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(UUID.randomUUID(), "Armor knockback resistance", knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        if (movementSpeed > 0.0) {
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.randomUUID(), "Armor movement speed", movementSpeed, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (maxHealth > 0.0) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.randomUUID(), "Armor health gain", maxHealth, AttributeModifier.Operation.ADDITION));
        }
        if (attackDamage > 0.0) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.randomUUID(), "Armor attack damage", attackDamage, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (attackSpeed > 0.0) {
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.randomUUID(), "Armor attack speed", attackSpeed, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (luck > 0.0) {
            builder.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.randomUUID(), "Armor luck", luck, AttributeModifier.Operation.ADDITION));
        }
        this.attributeModifiers = builder.build();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        String translationKey = this.m_5524_() + ".tooltip";
        tooltip.add((Component)Component.m_237115_((String)translationKey));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<? extends FAArmorItem> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = FAArmorItem.this.createArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == this.f_265916_.m_266308_()) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.putAll(this.attributeModifiers);
            return builder.build();
        }
        return modifiers;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract GeoArmorRenderer<? extends FAArmorItem> createArmorRenderer();

    public abstract List<MobEffectInstance> getFullSetEffects();
}

