/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item.armor.lib;

import net.kenddie.fantasyarmor.item.armor.lib.FAArmorItem;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FAArmorEffectHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && FAArmorEffectHandler.hasFullSet(player = event.player)) {
            FAArmorEffectHandler.applyFullSetEffects(player);
        }
    }

    private static boolean hasFullSet(Player player) {
        ItemStack helmetItemStack = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplateItemStack = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggingsItemStack = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack bootsItemStack = player.m_6844_(EquipmentSlot.FEET);
        if (helmetItemStack.m_41720_() instanceof FAArmorItem && chestplateItemStack.m_41720_() instanceof FAArmorItem && leggingsItemStack.m_41720_() instanceof FAArmorItem && bootsItemStack.m_41720_() instanceof FAArmorItem) {
            Class<?> armorClass = helmetItemStack.m_41720_().getClass();
            return armorClass.isInstance(chestplateItemStack.m_41720_()) && armorClass.isInstance(leggingsItemStack.m_41720_()) && armorClass.isInstance(bootsItemStack.m_41720_());
        }
        return false;
    }

    private static void applyFullSetEffects(Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        FAArmorItem armorItem = (FAArmorItem)helmet.m_41720_();
        for (MobEffectInstance effectInstance : armorItem.getFullSetEffects()) {
            MobEffect effect = effectInstance.m_19544_();
            MobEffectInstance existingEffect = player.m_21124_(effect);
            if (existingEffect != null && existingEffect.m_19557_() >= 221) continue;
            player.m_7292_(new MobEffectInstance(effect, effectInstance.m_19557_(), effectInstance.m_19564_()));
        }
    }
}

