/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.entity.client.armor.render.lib;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.kenddie.fantasyarmor.entity.client.armor.render.lib.FARenderUtils;
import net.kenddie.fantasyarmor.item.armor.lib.FAArmorItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class FAArmorRenderer<T extends FAArmorItem>
extends GeoArmorRenderer<T> {
    protected GeoBone cape = null;
    protected GeoBone leftLegCloth = null;
    protected GeoBone rightLegCloth = null;

    public FAArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    @Nullable
    public GeoBone getCapeBone(GeoModel<T> model) {
        return model.getBone("armorCape").orElse(null);
    }

    @Nullable
    public GeoBone getLeftLegClothBone(GeoModel<T> model) {
        return model.getBone("armorLeftLegCloth").orElse(null);
    }

    @Nullable
    public GeoBone getRightLegClothBone(GeoModel<T> model) {
        return model.getBone("armorRightLegCloth").orElse(null);
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        super.grabRelevantBones(bakedModel);
        GeoModel model = this.getGeoModel();
        this.cape = this.getCapeBone(model);
        this.leftLegCloth = this.getLeftLegClothBone(model);
        this.rightLegCloth = this.getRightLegClothBone(model);
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        super.applyBoneVisibilityBySlot(currentSlot);
        if (currentSlot == EquipmentSlot.CHEST) {
            this.setBoneVisible(this.cape, true);
            this.setBoneVisible(this.leftLegCloth, true);
            this.setBoneVisible(this.rightLegCloth, true);
        }
    }

    public void applyBoneVisibilityByPart(EquipmentSlot currentSlot, ModelPart currentPart, HumanoidModel<?> model) {
        super.applyBoneVisibilityByPart(currentSlot, currentPart, model);
        if (currentPart == model.f_102810_) {
            this.cape.setHidden(false);
            this.leftLegCloth.setHidden(false);
            this.rightLegCloth.setHidden(false);
        }
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.cape == null) {
            return;
        }
        Entity entity = this.currentEntity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FARenderUtils.applyCapeRotation(player, this.cape, partialTick);
        } else {
            this.cape.updateRotation((float)(-Math.toRadians(5.0)), 0.0f, 0.0f);
        }
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        super.applyBaseTransformations(baseModel);
        if (this.cape != null) {
            ModelPart bodyPart = baseModel.f_102810_;
            this.cape.updatePosition(bodyPart.f_104200_, 1.0f - bodyPart.f_104201_, bodyPart.f_104202_);
        }
        if (this.leftLegCloth != null) {
            ModelPart leftLegPart = baseModel.f_102814_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.leftLegCloth);
            this.leftLegCloth.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
        }
        if (this.rightLegCloth != null) {
            ModelPart rightLegPart = baseModel.f_102813_;
            RenderUtils.matchModelPartRot((ModelPart)rightLegPart, (CoreGeoBone)this.rightLegCloth);
            this.rightLegCloth.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - rightLegPart.f_104201_, rightLegPart.f_104202_);
        }
    }

    public void m_8009_(boolean pVisible) {
        super.m_8009_(pVisible);
        this.setBoneVisible(this.cape, pVisible);
        this.setBoneVisible(this.leftLegCloth, pVisible);
        this.setBoneVisible(this.rightLegCloth, pVisible);
    }
}

