/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.arbor.extrasounds.debug.DebugUtils;
import org.arbor.extrasounds.sounds.CategoryLoader;
import org.arbor.extrasounds.sounds.Mixers;
import org.arbor.extrasounds.sounds.SoundType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="extrasounds")
public class ExtraSounds {
    public static final String MODID = "extrasounds";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Mixers MIXERS = new Mixers();
    public static final Map<SoundSource, SoundSource> PARENTS = new HashMap<SoundSource, SoundSource>();
    public static final Map<String, SoundSource> MASTERS = new HashMap<String, SoundSource>();
    public static final Map<SoundSource, Float> DEFAULT_LEVELS = new HashMap<SoundSource, Float>();
    public static final Map<SoundSource, Pair<Boolean, Boolean>> TOGGLEABLE_CATS = new HashMap<SoundSource, Pair<Boolean, Boolean>>();
    public static final Map<SoundSource, Component> TOOLTIPS = new HashMap<SoundSource, Component>();
    public static final ResourceLocation SETTINGS_ICON = new ResourceLocation("extrasounds", "textures/gui/settings.png");
    private static final List<String> SUPPRESSED_NAMES = new ArrayList<String>();
    public static String[] MASTER_CLASSES;
    public static final SoundEvent MISSING;

    public ExtraSounds() {
        ExtraSounds.initCategoryLoader();
    }

    public static Pair<CategoryLoader, List<Field>> getCategories() {
        return Pair.of((Object)MIXERS, ExtraSounds.getRegistrations());
    }

    private static List<Field> getRegistrations() {
        return Arrays.stream(MIXERS.getClass().getDeclaredFields()).filter(it -> it.isAnnotationPresent(CategoryLoader.Register.class)).toList();
    }

    @Nullable
    public static ResourceLocation getClickId(ResourceLocation id, SoundType type) {
        if (id == null || type == null) {
            return null;
        }
        return new ResourceLocation(MODID, "%s.%s.%s".formatted(type.prefix, id.m_135827_(), id.m_135815_()));
    }

    public static SoundEvent createEvent(String path) {
        try {
            return SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MODID, path));
        }
        catch (Throwable ex) {
            LOGGER.error("[%s] Failed to create SoundEvent".formatted(ExtraSounds.class.getSimpleName()), ex);
            return MISSING;
        }
    }

    public static SoundEvent createEvent(ResourceLocation path) {
        try {
            return SoundEvent.m_262824_((ResourceLocation)path);
        }
        catch (Throwable ex) {
            LOGGER.error("[%s] Failed to create SoundEvent".formatted(ExtraSounds.class.getSimpleName()), ex);
            return MISSING;
        }
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation(MODID, id);
    }

    private static String generateFieldClassName(Class<?> clazz, Field field) {
        return "%s#%s".formatted(clazz.getCanonicalName(), field.getName());
    }

    public static void initCategoryLoader() {
        SoundSource.MASTER.getClass().getClassLoader();
        try {
            Object object;
            String className;
            CategoryLoader.Register annotation;
            CategoryLoader categoryLoader;
            Pair<CategoryLoader, List<Field>> allAnnotations = ExtraSounds.getCategories();
            for (Field field : (List)allAnnotations.getSecond()) {
                categoryLoader = (CategoryLoader)allAnnotations.getFirst();
                annotation = field.getAnnotation(CategoryLoader.Register.class);
                className = categoryLoader.getClass().getCanonicalName();
                object = field.get(categoryLoader);
                if (!(object instanceof SoundSource)) {
                    String fieldClassName = ExtraSounds.generateFieldClassName(categoryLoader.getClass(), field);
                    if (SUPPRESSED_NAMES.contains(fieldClassName)) continue;
                    LOGGER.error("[%s] Cast check failed for the member '%s'.".formatted(ExtraSounds.class.getSimpleName(), fieldClassName), (Throwable)new ClassCastException("Can not cast %s to SoundCategory".formatted(field.get(categoryLoader).getClass().getCanonicalName())));
                    SUPPRESSED_NAMES.add(fieldClassName);
                    continue;
                }
                SoundSource source = (SoundSource)object;
                if (!annotation.master()) continue;
                if (MASTERS.containsKey(className)) {
                    if (!SUPPRESSED_NAMES.contains(className)) {
                        LOGGER.warn("[%s] Unexpected annotation was found.".formatted(ExtraSounds.class.getSimpleName()), (Throwable)new AnnotationFormatError("Class '%s' has a duplicate member with annotation value 'master'!".formatted(className)));
                        SUPPRESSED_NAMES.add(className);
                    }
                    PARENTS.put(source, MASTERS.get(className));
                }
                MASTERS.putIfAbsent(className, source);
            }
            MASTER_CLASSES = (String[])MASTERS.keySet().toArray(String[]::new);
            Arrays.sort(MASTER_CLASSES);
            for (Field field : (List)allAnnotations.getSecond()) {
                categoryLoader = (CategoryLoader)allAnnotations.getFirst();
                annotation = field.getAnnotation(CategoryLoader.Register.class);
                className = categoryLoader.getClass().getCanonicalName();
                object = field.get(categoryLoader);
                if (!(object instanceof SoundSource)) continue;
                SoundSource category = (SoundSource)object;
                if (!annotation.master()) {
                    if (MASTERS.containsKey(className)) {
                        PARENTS.put(category, MASTERS.get(className));
                    } else if (!SUPPRESSED_NAMES.contains(className)) {
                        LOGGER.warn("[{}] Missing annotation value 'master' in class '{}'. This is deprecated.", (Object)ExtraSounds.class.getSimpleName(), (Object)className);
                        LOGGER.warn("[{}] To avoid this message, please specify \"master = true\" in one of the @Register annotation in your class.", (Object)ExtraSounds.class.getSimpleName());
                        SUPPRESSED_NAMES.add(className);
                    }
                }
                if (annotation.defaultLevel() != 1.0f) {
                    DEFAULT_LEVELS.put(category, Float.valueOf(annotation.defaultLevel()));
                }
                if (annotation.toggle()) {
                    TOGGLEABLE_CATS.put(category, (Pair<Boolean, Boolean>)Pair.of((Object)true, (Object)annotation.defaultOn()));
                }
                if (annotation.tooltip().isEmpty()) continue;
                TOOLTIPS.put(category, (Component)Component.m_237115_((String)annotation.tooltip()));
            }
        }
        catch (Exception ex) {
            LOGGER.error("[%s] Unexpected error has caught".formatted(ExtraSounds.class.getSimpleName()), (Throwable)ex);
        }
        SUPPRESSED_NAMES.clear();
    }

    static {
        MISSING = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MODID, "missing"));
    }

    @Mod.EventBusSubscriber(modid="extrasounds", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            DebugUtils.init();
        }
    }
}

