/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.sound.instance;

import io.github.mortuusars.exposure.item.CameraItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShutterTimerTickingSoundInstance
extends AbstractTickableSoundInstance {
    private final Player player;
    private int delay = 2;
    private final float originalVolume;

    public ShutterTimerTickingSoundInstance(Player player, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, RandomSource random) {
        super(soundEvent, soundSource, random);
        this.player = player;
        this.f_119575_ = player.m_20185_();
        this.f_119576_ = player.m_20186_();
        this.f_119577_ = player.m_20189_();
        this.f_119573_ = volume;
        this.originalVolume = volume;
        this.f_119574_ = pitch;
        this.f_119578_ = true;
    }

    public void m_7788_() {
        this.f_119575_ = this.player.m_20185_();
        this.f_119576_ = this.player.m_20186_();
        this.f_119577_ = this.player.m_20189_();
        if (this.hasShutterOpen(this.player.m_21205_()) || this.hasShutterOpen(this.player.m_21206_())) {
            this.f_119573_ = Mth.m_14179_((float)0.3f, (float)this.f_119573_, (float)this.originalVolume);
            return;
        }
        this.f_119573_ = Mth.m_14179_((float)0.2f, (float)this.f_119573_, (float)(this.originalVolume * 0.3f));
        if (!this.hasCameraWithOpenShutterInInventory(this.player)) {
            if (!this.player.equals((Object)Minecraft.m_91087_().f_91074_) && this.delay > 0) {
                --this.delay;
                return;
            }
            this.m_119609_();
        }
    }

    private boolean hasCameraWithOpenShutterInInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!this.hasShutterOpen(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean hasShutterOpen(ItemStack stack) {
        CameraItem cameraItem;
        Item item = stack.m_41720_();
        return item instanceof CameraItem && (cameraItem = (CameraItem)item).isShutterOpen(stack);
    }
}

