/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class ExposurePredicate {
    public static final ExposurePredicate ANY = new ExposurePredicate(MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, NbtPredicate.f_57471_, MinMaxBounds.Ints.f_55364_, EntityPredicate.f_36550_);
    private final MinMaxBounds.Ints dayTime;
    private final MinMaxBounds.Ints lightLevel;
    private final NbtPredicate nbt;
    private final MinMaxBounds.Ints entitiesInFrameCount;
    private final EntityPredicate entityInFrame;

    public ExposurePredicate(MinMaxBounds.Ints dayTime, MinMaxBounds.Ints lightLevel, NbtPredicate nbtPredicate, MinMaxBounds.Ints entitiesInFrameCount, EntityPredicate entityInFramePredicate) {
        this.dayTime = dayTime;
        this.lightLevel = lightLevel;
        this.nbt = nbtPredicate;
        this.entitiesInFrameCount = entitiesInFrameCount;
        this.entityInFrame = entityInFramePredicate;
    }

    public boolean matches(ServerPlayer player, CompoundTag frameTag, List<Entity> entitiesInFrame) {
        if (this.equals(ANY)) {
            return true;
        }
        return this.dayTime.m_55390_(frameTag.m_128425_("DayTime", 3) ? frameTag.m_128451_("DayTime") : -1) && this.lightLevel.m_55390_(frameTag.m_128425_("LightLevel", 3) ? frameTag.m_128451_("LightLevel") : -1) && this.entitiesInFrameCount.m_55390_(entitiesInFrame.size()) && this.nbt.m_57483_((Tag)frameTag) && this.entitiesMatch(player, entitiesInFrame);
    }

    protected boolean entitiesMatch(ServerPlayer player, List<Entity> entitiesInFrame) {
        if (this.entityInFrame.equals(EntityPredicate.f_36550_)) {
            return true;
        }
        for (Entity entity : entitiesInFrame) {
            if (!this.entityInFrame.m_36611_(player, entity)) continue;
            return true;
        }
        return false;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        json.add("day_time", this.lightLevel.m_55328_());
        json.add("light_level", this.lightLevel.m_55328_());
        json.add("nbt", this.nbt.m_57476_());
        json.add("entities_count", this.entitiesInFrameCount.m_55328_());
        json.add("entity_in_frame", this.entityInFrame.m_36606_());
        return json;
    }

    public static ExposurePredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)"exposure");
        return new ExposurePredicate(MinMaxBounds.Ints.m_55373_((JsonElement)jsonobject.get("day_time")), MinMaxBounds.Ints.m_55373_((JsonElement)jsonobject.get("light_level")), NbtPredicate.m_57481_((JsonElement)jsonobject.get("nbt")), MinMaxBounds.Ints.m_55373_((JsonElement)jsonobject.get("entities_count")), EntityPredicate.m_36614_((JsonElement)jsonobject.get("entity_in_frame")));
    }
}

