/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.item.BlueprintRecordItem;
import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import com.teamabnormals.environmental.common.item.DuckEggItem;
import com.teamabnormals.environmental.common.item.GiantLilyPadItem;
import com.teamabnormals.environmental.common.item.HibiscusBlockItem;
import com.teamabnormals.environmental.common.item.KoiBucketItem;
import com.teamabnormals.environmental.common.item.LargeLilyPadItem;
import com.teamabnormals.environmental.common.item.MudBallItem;
import com.teamabnormals.environmental.common.item.SlabfishBucketItem;
import com.teamabnormals.environmental.common.item.YakPantsItem;
import com.teamabnormals.environmental.common.item.explorer.ArchitectBeltItem;
import com.teamabnormals.environmental.common.item.explorer.HealerPouchItem;
import com.teamabnormals.environmental.common.item.explorer.ThiefHoodItem;
import com.teamabnormals.environmental.common.item.explorer.WandererBootsItem;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalTiers;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBannerPatternTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import com.teamabnormals.environmental.integration.boatload.EnvironmentalBoatTypes;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalItems {
    public static final ItemSubRegistryHelper HELPER = (ItemSubRegistryHelper)Environmental.REGISTRY_HELPER.getItemSubHelper();
    public static final RegistryObject<Item> THIEF_HOOD = HELPER.createItem("thief_hood", () -> new ThiefHoodItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> HEALER_POUCH = HELPER.createItem("healer_pouch", () -> new HealerPouchItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> ARCHITECT_BELT = HELPER.createItem("architect_belt", () -> new ArchitectBeltItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> WANDERER_BOOTS = HELPER.createItem("wanderer_boots", () -> new WandererBootsItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> CHERRIES = HELPER.createItem("cherries", () -> new Item(new Item.Properties().m_41489_(EnvironmentalFoods.CHERRIES)));
    public static final RegistryObject<Item> PLUM = HELPER.createItem("plum", () -> new Item(new Item.Properties().m_41489_(EnvironmentalFoods.PLUM)));
    public static final RegistryObject<Item> VENISON = HELPER.createItem("venison", () -> new Item(new Item.Properties().m_41489_(EnvironmentalFoods.VENISON)));
    public static final RegistryObject<Item> COOKED_VENISON = HELPER.createItem("cooked_venison", () -> new Item(new Item.Properties().m_41489_(EnvironmentalFoods.COOKED_VENISON)));
    public static final RegistryObject<Item> KOI = HELPER.createItem("koi", () -> new Item(new Item.Properties().m_41489_(EnvironmentalFoods.KOI)));
    public static final RegistryObject<Item> DUCK = HELPER.createItem("duck", () -> new Item(new Item.Properties().m_41489_(EnvironmentalFoods.DUCK)));
    public static final RegistryObject<Item> COOKED_DUCK = HELPER.createItem("cooked_duck", () -> new Item(new Item.Properties().m_41489_(EnvironmentalFoods.COOKED_DUCK)));
    public static final RegistryObject<Item> DUCK_EGG = HELPER.createItem("duck_egg", () -> new DuckEggItem(new Item.Properties().m_41487_(16)));
    public static final RegistryObject<Item> TRUFFLE = HELPER.createItem("truffle", () -> new Item(new Item.Properties().m_41489_(EnvironmentalFoods.TRUFFLE)));
    public static final RegistryObject<Item> MUD_BALL = HELPER.createItem("mud_ball", () -> new MudBallItem(new Item.Properties()));
    public static final RegistryObject<Item> YAK_HAIR = HELPER.createItem("yak_hair", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> YAK_PANTS = HELPER.createItem("yak_pants", () -> new YakPantsItem((ArmorMaterial)EnvironmentalTiers.EnvironmentalArmorMaterials.YAK, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final Pair<RegistryObject<Item>, RegistryObject<Item>> WILLOW_BOAT = HELPER.createBoatAndChestBoatItem("willow", EnvironmentalBlocks.WILLOW_PLANKS);
    public static final RegistryObject<Item> WILLOW_FURNACE_BOAT = HELPER.createItem("willow_furnace_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.WILLOW_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> LARGE_WILLOW_BOAT = HELPER.createItem("large_willow_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.LARGE_WILLOW_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<RegistryObject<Item>, RegistryObject<Item>> WISTERIA_BOAT = HELPER.createBoatAndChestBoatItem("wisteria", EnvironmentalBlocks.WISTERIA_PLANKS);
    public static final RegistryObject<Item> WISTERIA_FURNACE_BOAT = HELPER.createItem("wisteria_furnace_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.WISTERIA_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> LARGE_WISTERIA_BOAT = HELPER.createItem("large_wisteria_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.LARGE_WISTERIA_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<RegistryObject<Item>, RegistryObject<Item>> PLUM_BOAT = HELPER.createBoatAndChestBoatItem("plum", EnvironmentalBlocks.PLUM_PLANKS);
    public static final RegistryObject<Item> PLUM_FURNACE_BOAT = HELPER.createItem("plum_furnace_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.PLUM_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> LARGE_PLUM_BOAT = HELPER.createItem("large_plum_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.LARGE_PLUM_BOAT : () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> CATTAIL_FLUFF = HELPER.createItem("cattail_fluff", () -> new ItemNameBlockItem((Block)EnvironmentalBlocks.CATTAIL_SPROUT.get(), new Item.Properties()));
    public static final RegistryObject<Item> DUCKWEED = HELPER.createItem("duckweed", () -> new PlaceOnWaterBlockItem((Block)EnvironmentalBlocks.DUCKWEED.get(), new Item.Properties()));
    public static final RegistryObject<Item> MUSIC_DISC_LEAVING_HOME = HELPER.createItem("music_disc_leaving_home", () -> new BlueprintRecordItem(6, EnvironmentalSoundEvents.MUSIC_DISC_LEAVING_HOME, new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE), 144));
    public static final RegistryObject<Item> MUSIC_DISC_SLABRAVE = HELPER.createItem("music_disc_slabrave", () -> new BlueprintRecordItem(13, EnvironmentalSoundEvents.MUSIC_DISC_SLABRAVE, new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE), 111));
    public static final RegistryObject<Item> LUMBERER_BANNER_PATTERN = HELPER.createItem("lumberer_banner_pattern", () -> new BannerPatternItem(EnvironmentalBannerPatternTags.PATTERN_ITEM_LUMBERER, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> LARGE_LILY_PAD = HELPER.createItem("large_lily_pad", () -> new LargeLilyPadItem(new Item.Properties()));
    public static final RegistryObject<Item> GIANT_LILY_PAD = HELPER.createItem("giant_lily_pad", () -> new GiantLilyPadItem(new Item.Properties()));
    public static final RegistryObject<Item> SLABFISH_BUCKET = HELPER.createItem("slabfish_bucket", () -> new SlabfishBucketItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> KOI_BUCKET = HELPER.createItem("koi_bucket", () -> new KoiBucketItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> YELLOW_HIBISCUS = HELPER.createItem("yellow_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.YELLOW_HIBISCUS.get(), (Block)EnvironmentalBlocks.YELLOW_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final RegistryObject<Item> ORANGE_HIBISCUS = HELPER.createItem("orange_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.ORANGE_HIBISCUS.get(), (Block)EnvironmentalBlocks.ORANGE_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final RegistryObject<Item> RED_HIBISCUS = HELPER.createItem("red_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.RED_HIBISCUS.get(), (Block)EnvironmentalBlocks.RED_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final RegistryObject<Item> PINK_HIBISCUS = HELPER.createItem("pink_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.PINK_HIBISCUS.get(), (Block)EnvironmentalBlocks.PINK_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final RegistryObject<Item> MAGENTA_HIBISCUS = HELPER.createItem("magenta_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.MAGENTA_HIBISCUS.get(), (Block)EnvironmentalBlocks.MAGENTA_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final RegistryObject<Item> PURPLE_HIBISCUS = HELPER.createItem("purple_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.PURPLE_HIBISCUS.get(), (Block)EnvironmentalBlocks.PURPLE_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final RegistryObject<ForgeSpawnEggItem> SLABFISH_SPAWN_EGG = HELPER.createSpawnEggItem("slabfish", () -> EnvironmentalEntityTypes.SLABFISH.get(), 6263617, 13940616);
    public static final RegistryObject<ForgeSpawnEggItem> DUCK_SPAWN_EGG = HELPER.createSpawnEggItem("duck", () -> EnvironmentalEntityTypes.DUCK.get(), 1138489, 16754947);
    public static final RegistryObject<ForgeSpawnEggItem> DEER_SPAWN_EGG = HELPER.createSpawnEggItem("deer", () -> EnvironmentalEntityTypes.DEER.get(), 10057035, 15190442);
    public static final RegistryObject<ForgeSpawnEggItem> REINDEER_SPAWN_EGG = HELPER.createSpawnEggItem("reindeer", () -> EnvironmentalEntityTypes.REINDEER.get(), 7360069, 15388873);
    public static final RegistryObject<ForgeSpawnEggItem> YAK_SPAWN_EGG = HELPER.createSpawnEggItem("yak", () -> EnvironmentalEntityTypes.YAK.get(), 5392966, 8607802);
    public static final RegistryObject<ForgeSpawnEggItem> KOI_SPAWN_EGG = HELPER.createSpawnEggItem("koi", () -> EnvironmentalEntityTypes.KOI.get(), 5392966, 16754947);
    public static final RegistryObject<ForgeSpawnEggItem> TAPIR_SPAWN_EGG = HELPER.createSpawnEggItem("tapir", () -> EnvironmentalEntityTypes.TAPIR.get(), 3684157, 13028046);
    public static final RegistryObject<ForgeSpawnEggItem> ZEBRA_SPAWN_EGG = HELPER.createSpawnEggItem("zebra", () -> EnvironmentalEntityTypes.ZEBRA.get(), 13945798, 3419691);

    public static void setupTabEditors() {
        CreativeModeTabContentsPopulator.mod((String)"environmental").tab(CreativeModeTabs.f_256839_).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42780_}), new Supplier[]{CHERRIES, PLUM}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42581_}), new Supplier[]{VENISON, COOKED_VENISON}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42697_}), new Supplier[]{DUCK, COOKED_DUCK}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_}), new Supplier[]{TRUFFLE}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_}), new Supplier[]{KOI}).tab(CreativeModeTabs.f_256968_).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_186364_}), new Supplier[]{LUMBERER_BANNER_PATTERN}).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42521_}), new Supplier[]{DUCK_EGG}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_}), new Supplier[]{YAK_HAIR}).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_}), new Supplier[]{MUD_BALL}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_}), new Supplier[]{CATTAIL_FLUFF}).tab(CreativeModeTabs.f_256797_).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42521_}), new Supplier[]{MUD_BALL}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42354_}), new Supplier[]{THIEF_HOOD, HEALER_POUCH, ARCHITECT_BELT, WANDERER_BOOTS}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42654_}), new Supplier[]{YAK_PANTS}).tab(CreativeModeTabs.f_256869_).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42459_}), new Supplier[]{KOI_BUCKET}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_220210_}), new Supplier[]{SLABFISH_BUCKET}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_244624_}), new Supplier[]{(Supplier)WILLOW_BOAT.getFirst(), (Supplier)WILLOW_BOAT.getSecond()}).addItemsBefore(EnvironmentalItems.modLoaded((ItemLike)Items.f_244624_, "boatload"), new Supplier[]{WILLOW_FURNACE_BOAT, LARGE_WILLOW_BOAT}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_244624_}), new Supplier[0]).addItemsBefore(EnvironmentalItems.modLoaded((ItemLike)Items.f_244624_, "boatload"), new Supplier[0]).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_244624_}), new Supplier[]{(Supplier)PLUM_BOAT.getFirst(), (Supplier)PLUM_BOAT.getSecond()}).addItemsBefore(EnvironmentalItems.modLoaded((ItemLike)Items.f_244624_, "boatload"), new Supplier[]{PLUM_FURNACE_BOAT, LARGE_PLUM_BOAT}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_244624_}), new Supplier[]{(Supplier)WISTERIA_BOAT.getFirst(), (Supplier)WISTERIA_BOAT.getSecond()}).addItemsBefore(EnvironmentalItems.modLoaded((ItemLike)Items.f_244624_, "boatload"), new Supplier[]{WISTERIA_FURNACE_BOAT, LARGE_WISTERIA_BOAT}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_220217_}), new Supplier[]{MUSIC_DISC_LEAVING_HOME, MUSIC_DISC_SLABRAVE}).tab(CreativeModeTabs.f_256776_).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_271133_}), new Supplier[]{CATTAIL_FLUFF}).tab(CreativeModeTabs.f_256731_).addItemsAlphabetically(ItemStackUtil.is(SpawnEggItem.class), new Supplier[]{SLABFISH_SPAWN_EGG, DUCK_SPAWN_EGG, DEER_SPAWN_EGG, REINDEER_SPAWN_EGG, YAK_SPAWN_EGG, KOI_SPAWN_EGG, TAPIR_SPAWN_EGG, ZEBRA_SPAWN_EGG});
    }

    public static Predicate<ItemStack> modLoaded(ItemLike item, String ... modids) {
        return stack -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static final class EnvironmentalFoods {
        public static final FoodProperties CHERRIES = new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38766_().m_38767_();
        public static final FoodProperties PLUM = new FoodProperties.Builder().m_38760_(5).m_38758_(0.3f).m_38767_();
        public static final FoodProperties VENISON = new FoodProperties.Builder().m_38760_(2).m_38758_(0.3f).m_38757_().m_38767_();
        public static final FoodProperties COOKED_VENISON = new FoodProperties.Builder().m_38760_(6).m_38758_(0.8f).m_38757_().m_38767_();
        public static final FoodProperties DUCK = new FoodProperties.Builder().m_38760_(4).m_38758_(0.1f).effect(() -> new MobEffectInstance(MobEffects.f_19612_, 600, 0), 0.3f).m_38757_().m_38767_();
        public static final FoodProperties COOKED_DUCK = new FoodProperties.Builder().m_38760_(8).m_38758_(0.3f).m_38757_().m_38767_();
        public static final FoodProperties TRUFFLE = new FoodProperties.Builder().m_38760_(16).m_38758_(1.2f).m_38767_();
        public static final FoodProperties KOI = new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38767_();
    }
}

