/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.environmental.client.model.ArchitectBeltModel;
import com.teamabnormals.environmental.client.model.DeerModel;
import com.teamabnormals.environmental.client.model.DuckModel;
import com.teamabnormals.environmental.client.model.HealerPouchModel;
import com.teamabnormals.environmental.client.model.KoiModel;
import com.teamabnormals.environmental.client.model.ReindeerModel;
import com.teamabnormals.environmental.client.model.SlabfishModel;
import com.teamabnormals.environmental.client.model.TapirModel;
import com.teamabnormals.environmental.client.model.ThiefHoodModel;
import com.teamabnormals.environmental.client.model.WandererBootsModel;
import com.teamabnormals.environmental.client.model.YakModel;
import com.teamabnormals.environmental.client.model.ZebraModel;
import com.teamabnormals.environmental.client.renderer.entity.DeerRenderer;
import com.teamabnormals.environmental.client.renderer.entity.DuckRenderer;
import com.teamabnormals.environmental.client.renderer.entity.KoiRenderer;
import com.teamabnormals.environmental.client.renderer.entity.ReindeerRenderer;
import com.teamabnormals.environmental.client.renderer.entity.SlabfishRenderer;
import com.teamabnormals.environmental.client.renderer.entity.TapirRenderer;
import com.teamabnormals.environmental.client.renderer.entity.YakRenderer;
import com.teamabnormals.environmental.client.renderer.entity.ZebraRenderer;
import com.teamabnormals.environmental.client.resources.SlabfishSpriteUploader;
import com.teamabnormals.environmental.common.network.message.C2SZebraJumpMessage;
import com.teamabnormals.environmental.common.network.message.CAcknowledgeEnvironmentalMessage;
import com.teamabnormals.environmental.common.network.message.EnvironmentalLoginMessage;
import com.teamabnormals.environmental.common.network.message.SOpenSlabfishInventoryMessage;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.data.client.EnvironmentalBlockStateProvider;
import com.teamabnormals.environmental.core.data.client.EnvironmentalItemModelProvider;
import com.teamabnormals.environmental.core.data.client.EnvironmentalSpriteSourceProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalAdvancementProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalDatapackBuiltinEntriesProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalLootTableProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalRecipeProvider;
import com.teamabnormals.environmental.core.data.server.modifiers.EnvironmentalAdvancementModifierProvider;
import com.teamabnormals.environmental.core.data.server.modifiers.EnvironmentalChunkGeneratorModifierProvider;
import com.teamabnormals.environmental.core.data.server.modifiers.EnvironmentalLootModifierProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalBannerPatternTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalBiomeTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalBlockTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalEntityTypeTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalItemTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalPaintingVariantTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalSlabfishTypeTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalStructureTagsProvider;
import com.teamabnormals.environmental.core.other.EnvironmentalClientCompat;
import com.teamabnormals.environmental.core.other.EnvironmentalCompat;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.other.EnvironmentalDataSerializers;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import com.teamabnormals.environmental.core.registry.EnvironmentalAttributes;
import com.teamabnormals.environmental.core.registry.EnvironmentalBannerPatterns;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomeModifierTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalFeatures;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMenuTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import com.teamabnormals.environmental.core.registry.EnvironmentalPaintingVariants;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalPlacementModifierTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import com.teamabnormals.environmental.core.registry.EnvironmentalSlabfishConditions;
import com.teamabnormals.environmental.core.registry.EnvironmentalVillagers;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="environmental")
@Mod.EventBusSubscriber(modid="environmental")
public class Environmental {
    public static final String MOD_ID = "environmental";
    public static final String NETWORK_PROTOCOL = "ENV1";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("environmental");
    public static final SimpleChannel PLAY = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("environmental", "play")).networkProtocolVersion(() -> "ENV1").clientAcceptedVersions("ENV1"::equals).serverAcceptedVersions("ENV1"::equals).simpleChannel();
    public static final SimpleChannel LOGIN = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("environmental", "login")).networkProtocolVersion(() -> "ENV1").clientAcceptedVersions("ENV1"::equals).serverAcceptedVersions("ENV1"::equals).simpleChannel();

    public Environmental() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        this.setupPlayMessages();
        EnvironmentalDataProcessors.registerTrackedData();
        REGISTRY_HELPER.register(bus);
        EnvironmentalPaintingVariants.PAINTING_VARIANTS.register(bus);
        EnvironmentalFeatures.FEATURES.register(bus);
        EnvironmentalFeatures.TREE_DECORATORS.register(bus);
        EnvironmentalPlacementModifierTypes.PLACEMENT_MODIFIER_TYPES.register(bus);
        EnvironmentalAttributes.ATTRIBUTES.register(bus);
        EnvironmentalMobEffects.MOB_EFFECTS.register(bus);
        EnvironmentalMenuTypes.MENU_TYPES.register(bus);
        EnvironmentalParticleTypes.PARTICLE_TYPES.register(bus);
        EnvironmentalSlabfishConditions.SLABFISH_CONDITIONS.register(bus);
        EnvironmentalDataSerializers.DATA_SERIALIZERS.register(bus);
        EnvironmentalBiomeModifierTypes.BIOME_MODIFIER_SERIALIZERS.register(bus);
        EnvironmentalBannerPatterns.BANNER_PATTERNS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        bus.addListener(EnvironmentalRegistries::registerRegistries);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            EnvironmentalItems.setupTabEditors();
            EnvironmentalBlocks.setupTabEditors();
            SlabfishSpriteUploader.init(bus);
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EnvironmentalConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            this.setupLoginMessages();
            EnvironmentalCompat.registerCompat();
            EnvironmentalVillagers.registerVillagerTypes();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> EnvironmentalClientCompat.registerClientCompat());
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        EnvironmentalDatapackBuiltinEntriesProvider datapackEntries = new EnvironmentalDatapackBuiltinEntriesProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapackEntries);
        provider = datapackEntries.getRegistryProvider();
        EnvironmentalBlockTagsProvider blockTags = new EnvironmentalBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new EnvironmentalItemTagsProvider(output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalEntityTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalStructureTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalBiomeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalBannerPatternTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalSlabfishTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalRecipeProvider(output));
        generator.addProvider(server, (DataProvider)EnvironmentalAdvancementProvider.create(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalAdvancementModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new EnvironmentalChunkGeneratorModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new EnvironmentalLootTableProvider(output));
        generator.addProvider(server, (DataProvider)new EnvironmentalLootModifierProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new EnvironmentalItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new EnvironmentalBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new EnvironmentalSpriteSourceProvider(output, helper));
    }

    private void setupPlayMessages() {
        PLAY.registerMessage(3, SOpenSlabfishInventoryMessage.class, SOpenSlabfishInventoryMessage::serialize, SOpenSlabfishInventoryMessage::deserialize, SOpenSlabfishInventoryMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        PLAY.registerMessage(4, C2SZebraJumpMessage.class, C2SZebraJumpMessage::serialize, C2SZebraJumpMessage::deserialize, C2SZebraJumpMessage::handle);
    }

    private void setupLoginMessages() {
        LOGIN.messageBuilder(CAcknowledgeEnvironmentalMessage.class, 99, NetworkDirection.LOGIN_TO_SERVER).loginIndex(EnvironmentalLoginMessage::getLoginIndex, EnvironmentalLoginMessage::setLoginIndex).encoder(CAcknowledgeEnvironmentalMessage::encode).decoder(CAcknowledgeEnvironmentalMessage::decode).consumerNetworkThread(HandshakeHandler.indexFirst(CAcknowledgeEnvironmentalMessage::handle)).add();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(EnvironmentalModelLayers.DUCK, DuckModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.DEER, DeerModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.REINDEER, ReindeerModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.KOI, KoiModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.SLABFISH, SlabfishModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.YAK, YakModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.TAPIR, TapirModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.ZEBRA, () -> LayerDefinition.m_171565_((MeshDefinition)ZebraModel.createBodyMesh(CubeDeformation.f_171458_), (int)64, (int)64));
        event.registerLayerDefinition(EnvironmentalModelLayers.THIEF_HOOD, ThiefHoodModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.HEALER_POUCH, HealerPouchModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.ARCHITECT_BELT, ArchitectBeltModel::createBodyLayer);
        event.registerLayerDefinition(EnvironmentalModelLayers.WANDERER_BOOTS, WandererBootsModel::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), SlabfishRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.DUCK.get(), DuckRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.DEER.get(), DeerRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.REINDEER.get(), ReindeerRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.YAK.get(), YakRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.KOI.get(), KoiRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.TAPIR.get(), TapirRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.ZEBRA.get(), ZebraRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.DUCK_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.MUD_BALL.get(), ThrownItemRenderer::new);
    }
}

