/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item.explorer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.teamabnormals.environmental.client.model.ThiefHoodModel;
import com.teamabnormals.environmental.common.item.explorer.ExplorerArmorItem;
import com.teamabnormals.environmental.core.registry.EnvironmentalAttributes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class ThiefHoodItem
extends ExplorerArmorItem {
    private static final String NBT_TAG = "ThiefHoodUses";

    public ThiefHoodItem(Item.Properties properties) {
        super(ArmorItem.Type.HELMET, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> properties) {
                return ThiefHoodModel.INSTANCE;
            }
        });
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.m_7167_(this.m_40402_()));
        UUID uuid = UUID.fromString("1D45B301-E65D-47A2-B63F-6EC5FCAC9316");
        int uses = Math.round(stack.m_41784_().m_128457_(NBT_TAG));
        double increase = 0.15 * (double)this.getIncreaseForUses(uses);
        builder.put((Object)((Attribute)EnvironmentalAttributes.STEALTH.get()), (Object)new AttributeModifier(uuid, "Stealth", increase, AttributeModifier.Operation.ADDITION));
        return slot == this.m_40402_() ? builder.build() : super.m_7167_(slot);
    }

    @SubscribeEvent
    public static void hoodEquippedEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity;
        if ((event.getTo().m_150930_((Item)EnvironmentalItems.THIEF_HOOD.get()) || event.getFrom().m_150930_((Item)EnvironmentalItems.THIEF_HOOD.get())) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            player.refreshDisplayName();
        }
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            ItemStack stack;
            Item item;
            LivingEntity attacker = (LivingEntity)entity2;
            if (entity instanceof Enemy && (item = (stack = attacker.m_6844_(EquipmentSlot.HEAD)).m_41720_()) instanceof ThiefHoodItem) {
                ThiefHoodItem thiefHoodItem = (ThiefHoodItem)item;
                thiefHoodItem.levelUp(stack, attacker);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        if (event.getLookingEntity() != null) {
            double attributeValue = 0.0;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack stack = event.getEntity().m_6844_(equipmentSlot);
                Collection modifiers = stack.m_41638_(equipmentSlot).get((Object)((Attribute)EnvironmentalAttributes.STEALTH.get()));
                if (modifiers.isEmpty()) continue;
                attributeValue += modifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
            }
            if (attributeValue > 0.0) {
                event.modifyVisibility(Math.max(1.0 - attributeValue, 0.0));
            }
        }
    }

    @Override
    public String getUsesTag() {
        return NBT_TAG;
    }

    @Override
    public int[] getLevelCaps() {
        return new int[]{0, 10, 50, 100, 500};
    }
}

