/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item.explorer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.teamabnormals.environmental.client.model.ArchitectBeltModel;
import com.teamabnormals.environmental.common.item.explorer.ExplorerArmorItem;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class ArchitectBeltItem
extends ExplorerArmorItem {
    private static final String NBT_TAG = "ArchitectBeltUses";

    public ArchitectBeltItem(Item.Properties properties) {
        super(ArmorItem.Type.LEGGINGS, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> properties) {
                return ArchitectBeltModel.INSTANCE;
            }
        });
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.m_7167_(this.m_40402_()));
        UUID uuid = UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D");
        int uses = stack.m_41783_().m_128451_(NBT_TAG);
        int increase = this.getIncreaseForUses(uses);
        builder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(uuid, "Reach modifier", (double)increase, AttributeModifier.Operation.ADDITION));
        return slot == this.m_40402_() ? builder.build() : super.m_7167_(slot);
    }

    @SubscribeEvent
    public static void placeBlockEvent(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        BlockState state = event.getPlacedBlock();
        if (entity instanceof Player) {
            ItemStack stack;
            Item item;
            Player player = (Player)entity;
            if (!state.m_60713_(Blocks.f_49990_) && (item = (stack = player.m_6844_(EquipmentSlot.LEGS)).m_41720_()) instanceof ArchitectBeltItem) {
                ((ArchitectBeltItem)item).levelUp(stack, (LivingEntity)player);
            }
        }
    }

    @Override
    public String getUsesTag() {
        return NBT_TAG;
    }

    @Override
    public int[] getLevelCaps() {
        return new int[]{0, 100, 500, 1000, 2500};
    }
}

