/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.projectile;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishOverlay;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class ThrownMudBall
extends ThrowableItemProjectile {
    public ThrownMudBall(EntityType<? extends ThrownMudBall> entity, Level world) {
        super(entity, world);
    }

    public ThrownMudBall(Level worldIn, LivingEntity throwerIn) {
        super((EntityType)EnvironmentalEntityTypes.MUD_BALL.get(), throwerIn, worldIn);
    }

    public ThrownMudBall(Level worldIn, double x, double y, double z) {
        super((EntityType)EnvironmentalEntityTypes.MUD_BALL.get(), x, y, z, worldIn);
    }

    public ThrownMudBall(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends ThrownMudBall>)((EntityType)EnvironmentalEntityTypes.MUD_BALL.get()), world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Slabfish slabby;
            Entity entity = ((EntityHitResult)result).m_82443_();
            entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
            if (entity instanceof Slabfish && (slabby = (Slabfish)entity).getSlabfishOverlay() != SlabfishOverlay.MUDDY) {
                slabby.setSlabfishOverlay(SlabfishOverlay.MUDDY);
            }
            if (entity instanceof Pig) {
                Pig pig = (Pig)entity;
                if (((Boolean)EnvironmentalConfig.COMMON.muddyPigs.get()).booleanValue()) {
                    IDataManager dataManager = (IDataManager)pig;
                    dataManager.setValue(EnvironmentalDataProcessors.IS_MUDDY, (Object)true);
                    dataManager.setValue(EnvironmentalDataProcessors.MUD_DRYING_TIME, (Object)((Integer)dataManager.getValue(EnvironmentalDataProcessors.MUD_DRYING_TIME) + 1200));
                }
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected Item m_7881_() {
        return (Item)EnvironmentalItems.MUD_BALL.get();
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)EnvironmentalItems.MUD_BALL.get());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

