/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.blueprint.core.api.EggLayer;
import com.teamabnormals.environmental.common.entity.ai.goal.DuckSwimGoal;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Duck
extends Animal
implements EggLayer {
    private static final EntityDataAccessor<Integer> EATING = SynchedEntityData.m_135353_(Duck.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float wingRotation;
    private float destPos;
    private float oFlapSpeed;
    private float oFlap;
    private float wingRotDelta = 1.0f;
    private float headLean;
    private float prevHeadLean;
    public int timeUntilNextEgg = this.f_19796_.m_188503_(6000) + 6000;
    public boolean duckJockey;

    public Duck(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(EnvironmentalItemTags.DUCK_FOOD), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new DuckSwimGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EATING, (Object)0);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.85f : sizeIn.f_20378_ * 0.92f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_8107_() {
        super.m_8107_();
        double d0 = this.m_204036_(FluidTags.f_13131_);
        boolean flag = !this.m_6162_() && d0 > 0.3 || this.m_6162_() && d0 > 0.15;
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.m_20096_() || this.f_19798_ ? -1 : 4) * 0.3);
        this.destPos = Mth.m_14036_((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && !flag && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        this.wingRotation += this.wingRotDelta * 2.0f;
        this.prevHeadLean = this.headLean;
        if (this.isEating()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        Vec3 vector3d = this.m_20184_();
        if (!this.m_20096_() && vector3d.f_82480_ < 0.0) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_6084_() && !this.m_6162_() && !this.f_19798_ && !this.isBirdJockey() && --this.timeUntilNextEgg <= 0) {
                this.m_5496_(this.getEggLayingSound(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19998_((ItemLike)this.getEggItem());
                this.timeUntilNextEgg = this.getNextEggTime(this.f_19796_);
            }
            if (this.isEating()) {
                if (this.f_19798_ && !this.m_27593_()) {
                    this.setEatingTime(this.getEatingTime() - 1);
                } else {
                    this.setEatingTime(0);
                }
            } else if (!this.m_27593_() && this.f_19796_.m_188503_(300) == 0 && this.f_19798_) {
                this.setEatingTime(40 + this.f_19796_.m_188503_(20));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getWingRotation(float partialTicks) {
        float f = Mth.m_14179_((float)partialTicks, (float)this.oFlap, (float)this.wingRotation);
        float f1 = Mth.m_14179_((float)partialTicks, (float)this.oFlapSpeed, (float)this.destPos);
        return (Mth.m_14031_((float)f) + 1.0f) * f1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadLean(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevHeadLean, (float)this.headLean);
    }

    public boolean isEating() {
        return this.getEatingTime() > 0;
    }

    public int getEatingTime() {
        return (Integer)this.f_19804_.m_135370_(EATING);
    }

    public void setEatingTime(int eatingTimeIn) {
        this.f_19804_.m_135381_(EATING, (Object)eatingTimeIn);
    }

    public static boolean checkDuckSpawnRules(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(EnvironmentalBlockTags.WATER_ANIMALS_SPAWNABLE_ON) && Duck.m_186209_((BlockAndTintGetter)worldIn, (BlockPos)pos);
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EnvironmentalSoundEvents.DUCK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.DUCK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.DUCK_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_204132_(EnvironmentalItemTags.DUCK_FOOD).test(stack);
    }

    public int m_213860_() {
        return this.isBirdJockey() ? 10 : super.m_213860_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.duckJockey = compound.m_128471_("IsDuckJockey");
        if (compound.m_128441_("EggLayTime")) {
            this.timeUntilNextEgg = compound.m_128451_("EggLayTime");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsDuckJockey", this.duckJockey);
        compound.m_128405_("EggLayTime", this.timeUntilNextEgg);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.isBirdJockey();
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction function) {
        super.m_19956_(passenger, function);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        function.m_20372_(passenger, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.5) + passenger.m_6049_() + 0.0, this.m_20189_() - (double)(0.1f * f1));
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).f_20883_ = this.f_20883_;
        }
    }

    public void setDuckJockey(boolean jockey) {
        this.duckJockey = jockey;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)EnvironmentalEntityTypes.DUCK.get()).m_20615_((Level)world);
    }

    public int getEggTimer() {
        return this.timeUntilNextEgg;
    }

    public void setEggTimer(int time) {
        this.timeUntilNextEgg = time;
    }

    public boolean isBirdJockey() {
        return this.duckJockey;
    }

    public Item getEggItem() {
        return (Item)EnvironmentalItems.DUCK_EGG.get();
    }

    public int getNextEggTime(RandomSource rand) {
        return rand.m_188503_(6000) + 6000;
    }

    public SoundEvent getEggLayingSound() {
        return (SoundEvent)EnvironmentalSoundEvents.DUCK_EGG.get();
    }
}

