/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.slabfish;

import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;

public class SlabbyGrabItemGoal
extends Goal
implements ContainerListener {
    private final Slabfish slabfish;
    private ItemEntity itemEntity;
    private final double moveSpeed;
    private int delayCounter;
    private boolean listening;

    public SlabbyGrabItemGoal(Slabfish animal, double speed) {
        this.slabfish = animal;
        this.moveSpeed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private boolean canPickupItem(Container inventory, ItemStack stack) {
        for (int i = 3; i < inventory.m_6643_(); ++i) {
            ItemStack stackInSlot = inventory.m_8020_(i);
            if (!stackInSlot.m_41619_() && (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackInSlot) || !ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)stack) || stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), inventory.m_6893_()))) continue;
            return true;
        }
        return false;
    }

    public boolean m_8036_() {
        if (!this.slabfish.hasBackpack() || this.slabfish.backpackFull || this.slabfish.m_21827_()) {
            return false;
        }
        List list = this.slabfish.m_9236_().m_45976_(ItemEntity.class, this.slabfish.m_20191_().m_82377_(12.0, 4.0, 12.0));
        ItemEntity item = null;
        double d0 = Double.MAX_VALUE;
        for (ItemEntity item1 : list) {
            double d1;
            if (item1.m_19749_() == this.slabfish || !this.canPickupItem(this.slabfish.slabfishBackpack, item1.m_32055_()) || !((d1 = this.slabfish.m_20280_((Entity)item1)) < d0)) continue;
            d0 = d1;
            item = item1;
        }
        if (item == null) {
            return false;
        }
        this.itemEntity = item;
        return true;
    }

    public boolean m_8045_() {
        return this.slabfish.hasBackpack() && !this.slabfish.backpackFull && this.itemEntity != null && this.itemEntity.m_6084_();
    }

    public void m_8056_() {
        this.delayCounter = 0;
        if (!this.listening) {
            this.listening = true;
            this.slabfish.slabfishBackpack.addListener(this);
        }
    }

    public void m_8041_() {
        this.itemEntity = null;
    }

    public void m_8037_() {
        if (--this.delayCounter <= 0) {
            this.delayCounter = this.m_183277_(10);
            Path path = this.slabfish.m_21573_().m_6570_((Entity)this.itemEntity, 0);
            if (path != null) {
                this.slabfish.m_21573_().m_26573_();
                this.slabfish.m_21573_().m_26536_(path, this.moveSpeed);
            }
        }
    }

    public void m_5757_(Container inventory) {
        ItemStack stack;
        if (this.itemEntity != null && !this.canPickupItem(inventory, stack = this.itemEntity.m_32055_())) {
            this.itemEntity = null;
        }
    }
}

