/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.environmental.common.block.CattailStalkBlock;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;

public class CattailBlock
extends BushBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty FLUFFY = BooleanProperty.m_61465_((String)"fluffy");
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    public static final IntegerProperty CATTAILS = IntegerProperty.m_61631_((String)"cattails", (int)1, (int)3);

    public CattailBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CATTAILS, (Comparable)Integer.valueOf(1))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLUFFY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.m_60824_(level, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.m_6266_(world.m_8055_(pos.m_7495_()), (BlockGetter)world, pos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_204336_(EnvironmentalBlockTags.CATTAIL_PLANTABLE_ON) || state.m_60713_((Block)this) || state.m_60713_((Block)EnvironmentalBlocks.CATTAIL_STALK.get());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        BlockState belowState = level.m_8055_(pos.m_7495_());
        FluidState fluidState = level.m_6425_(pos);
        if (state.m_60713_((Block)this)) {
            return (BlockState)state.m_61122_((Property)CATTAILS);
        }
        if (belowState.m_60713_((Block)this) && (Integer)belowState.m_61143_((Property)CATTAILS) > 1) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(belowState.m_60713_((Block)this)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(level.m_213780_().m_188503_(this.getMaxAge())));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)CATTAILS) < 3 && (Boolean)state.m_61143_((Property)TOP) == false || super.m_6864_(state, context);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CATTAILS, TOP, FLUFFY, WATERLOGGED, AGE});
    }

    protected boolean canGrowInto(BlockState state) {
        return state.m_60713_(Blocks.f_49990_) || state.m_60795_();
    }

    public int getMaxAge() {
        return 2;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < this.getMaxAge() || (Boolean)state.m_61143_((Property)WATERLOGGED) != false || (Boolean)state.m_61143_((Property)FLUFFY) == false && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean notMaxAge;
        if (!((Boolean)state.m_61143_((Property)FLUFFY)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188500_() < 0.1 ? 1 : 0) != 0)) {
            int i = 1;
            while (this.isCattail(level, pos.m_6625_(i)) || this.canGrowFluff(level, pos.m_6625_(i))) {
                if (this.canGrowFluff(level, pos.m_6625_(i))) {
                    BlockState fluffyState = (BlockState)state.m_61124_((Property)FLUFFY, (Comparable)Boolean.valueOf(true));
                    level.m_7731_(pos, fluffyState, 2);
                    level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)fluffyState));
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    break;
                }
                ++i;
            }
        }
        BlockPos abovePos = pos.m_7494_();
        boolean bl = notMaxAge = (Integer)state.m_61143_((Property)AGE) < this.getMaxAge();
        if ((notMaxAge || ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)abovePos, (BlockState)level.m_8055_(abovePos), (random.m_188500_() < 0.1 ? 1 : 0) != 0) && this.canGrowInto(level.m_8055_(abovePos))) {
            BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(abovePos).m_76152_() == Fluids.f_76193_));
            if (notMaxAge) {
                newState = (BlockState)newState.m_61122_((Property)AGE);
            }
            level.m_46597_(abovePos, newState);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)abovePos, (BlockState)level.m_8055_(abovePos));
        }
    }

    public boolean isCattail(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60713_((Block)this) || state.m_60713_((Block)EnvironmentalBlocks.CATTAIL_STALK.get());
    }

    public boolean canGrowFluff(ServerLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(Blocks.f_220864_);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean fluffy = (Boolean)state.m_61143_((Property)FLUFFY);
        ItemStack stack = player.m_21120_(hand);
        if (!fluffy && stack.m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (fluffy && stack.canPerformAction(ToolActions.SHEARS_CARVE)) {
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, (SoundEvent)EnvironmentalSoundEvents.CATTAIL_HARVEST.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                if (level.f_46441_.m_188503_(900) < 5) {
                    level.m_5594_(null, pos, (SoundEvent)EnvironmentalSoundEvents.CATTAIL_MEOW.get(), SoundSource.BLOCKS, 2.0f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f + 1.0f);
                }
                CattailBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get(), 1 + level.f_46441_.m_188503_(((Integer)state.m_61143_((Property)CATTAILS)).intValue())));
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)FLUFFY, (Comparable)Boolean.valueOf(false)));
                stack.m_41622_(1, (LivingEntity)player, p_55287_ -> p_55287_.m_21190_(hand));
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42574_));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            RandomSource random = level.m_213780_();
            if (((Boolean)state.m_61143_((Property)FLUFFY)).booleanValue()) {
                Vec3 offset = state.m_60824_((BlockGetter)level, pos);
                double offsetX = MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random);
                double offsetZ = MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random);
                double x = (double)pos.m_123341_() + offset.m_7096_() + 0.5 + offsetX;
                double y = (double)pos.m_123342_() + offset.m_7098_() + 0.75 + MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.05f), (RandomSource)random);
                double z = (double)pos.m_123343_() + offset.m_7094_() + 0.5 + offsetZ;
                if (random.m_188503_(6 - (Integer)state.m_61143_((Property)CATTAILS)) == 0) {
                    level.m_7106_((ParticleOptions)EnvironmentalParticleTypes.CATTAIL_FLUFF.get(), x, y, z, random.m_188500_() * 0.01 * Math.abs(offsetX) / offsetX, 0.0, random.m_188500_() * 0.01 * Math.abs(offsetZ) / offsetZ);
                }
            }
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrowInto(level.m_8055_(pos.m_7494_())) || (Boolean)state.m_61143_((Property)FLUFFY) == false && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.m_7494_();
        if (!((Boolean)state.m_61143_((Property)FLUFFY)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FLUFFY, (Comparable)Boolean.valueOf(true)), 2);
        } else if (this.canGrowInto(level.m_8055_(abovePos))) {
            int age = Math.min((Integer)state.m_61143_((Property)AGE) + 1, this.getMaxAge());
            level.m_46597_(abovePos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(abovePos).m_76152_() == Fluids.f_76193_)));
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        if (direction != Direction.UP || !facingState.m_60713_((Block)this) && !facingState.m_60713_((Block)EnvironmentalBlocks.CATTAIL_STALK.get())) {
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
            return super.m_7417_(state, direction, facingState, level, pos, facingPos);
        }
        return (BlockState)BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)EnvironmentalBlocks.CATTAIL_STALK.get()).m_49966_()).m_61124_((Property)CattailStalkBlock.BOTTOM, (Comparable)Boolean.valueOf(!level.m_8055_(pos.m_7495_()).m_60713_((Block)EnvironmentalBlocks.CATTAIL_STALK.get())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)FLUFFY)).booleanValue()) {
            Vec3 offset = state.m_60824_((BlockGetter)level, pos);
            double offsetX = MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random);
            double offsetZ = MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random);
            double x = (double)pos.m_123341_() + offset.m_7096_() + 0.5 + offsetX;
            double y = (double)pos.m_123342_() + offset.m_7098_() + 0.75 + MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.05f), (RandomSource)random);
            double z = (double)pos.m_123343_() + offset.m_7094_() + 0.5 + offsetZ;
            if (random.m_188503_(15) == 0) {
                level.m_7106_((ParticleOptions)EnvironmentalParticleTypes.CATTAIL_FLUFF.get(), x, y, z, random.m_188500_() * 0.01 * Math.abs(offsetX) / offsetX, 0.0, random.m_188500_() * 0.01 * Math.abs(offsetZ) / offsetZ);
            }
        }
    }
}

