/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlumBlossomParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private int waterTicks;
    private boolean isInWater;
    private boolean thunder;
    private boolean rain;

    private PlumBlossomParticle(ClientLevel level, double xCoordIn, double yCoordIn, double zCoordIn) {
        super(level, xCoordIn, yCoordIn, zCoordIn);
        this.f_107663_ *= 1.75f;
        this.f_107225_ = 500 + this.f_107223_.m_188503_(200) + this.f_107223_.m_188503_(200);
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.f_107231_ = (float)Math.random() * ((float)Math.PI * 2);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            float mult;
            float f = mult = this.f_107218_ ? 0.02f + this.f_107223_.m_188501_() * 0.1f : 1.0f;
            if (this.thunder) {
                this.f_107215_ -= (double)(0.0125f * mult);
                this.f_107216_ -= (double)(0.0075f * mult);
            } else if (this.rain) {
                this.f_107215_ -= (double)(0.001f * mult);
            }
            this.f_107205_ = false;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ -= (double)0.001f;
            this.f_107216_ = Math.max(this.f_107216_, (double)-0.08f);
            this.f_107204_ = this.f_107231_;
            if (!this.isInWater) {
                this.isInWater = this.f_107208_.m_8055_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_)).m_60819_().m_205070_(FluidTags.f_13131_);
            } else {
                ++this.waterTicks;
            }
            if (!(this.f_107218_ || this.isInWater && this.waterTicks >= 1)) {
                this.f_107231_ += (float)Math.PI * this.rotSpeed * (this.thunder ? 2.6f : (this.rain ? 2.0f : 1.6f));
            }
            if (this.isInWater && this.waterTicks >= 1) {
                this.f_107216_ = 0.0;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PlumBlossomParticle particle = new PlumBlossomParticle(level, x, y, z);
            particle.m_108335_(this.spriteSet);
            if (level.m_45517_(LightLayer.SKY, BlockPos.m_274561_((double)x, (double)y, (double)z)) > 8) {
                particle.rain = level.m_46471_();
                particle.thunder = level.m_46470_();
            }
            return particle;
        }
    }
}

