/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.teamabnormals.environmental.common.entity.animal.Yak;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class YakModel<E extends Yak>
extends QuadrupedModel<E> {
    private static final float RELATIVE_HEAD_Y = 3.0f;
    private static final float ADULT_EAT_OFFSET_MULTIPLIER = 9.0f;
    private static final float CHILD_EAT_OFFSET_MULTIPLIER = 4.5f;
    public ModelPart leftHorn;
    public ModelPart rightHorn;
    public ModelPart snout;
    public ModelPart leftEar;
    public ModelPart rightEar;

    public YakModel(ModelPart root) {
        super(root, false, 10.0f, 5.5f, 2.0f, 2.0f, 24);
        this.leftHorn = this.f_103492_.m_171324_("left_horn");
        this.rightHorn = this.f_103492_.m_171324_("right_horn");
        this.snout = this.f_103492_.m_171324_("snout");
        this.leftEar = this.f_103492_.m_171324_("left_ear");
        this.rightEar = this.f_103492_.m_171324_("right_ear");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171506_(-4.0f, -4.0f, -9.0f, 8.0f, 8.0f, 6.0f, false).m_171514_(72, 0).m_171506_(-4.0f, -4.0f, -9.0f, 8.0f, 8.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn = head.m_171599_("left_horn", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171506_(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, true).m_171514_(0, 42).m_171506_(3.0f, -4.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.m_171423_((float)4.0f, (float)-2.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorn = head.m_171599_("right_horn", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171506_(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, false).m_171514_(0, 42).m_171506_(-5.0f, -4.0f, -1.0f, 2.0f, 3.0f, 2.0f, true), PartPose.m_171423_((float)-4.0f, (float)-2.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition snout = head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(36, 42).m_171506_(-3.0f, -0.7765f, -5.8978f, 6.0f, 4.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171506_(4.0f, -2.0f, -8.0f, 3.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171506_(-7.0f, -2.0f, -8.0f, 3.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171506_(-6.0f, -13.0f, -7.0f, 12.0f, 22.0f, 12.0f, false).m_171514_(0, 0).m_171488_(-6.0f, -13.0f, -15.0f, 12.0f, 22.0f, 20.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-1.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, true), PartPose.m_171423_((float)-5.0f, (float)12.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLeg = root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-3.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, false), PartPose.m_171423_((float)5.0f, (float)12.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-1.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, true), PartPose.m_171423_((float)-5.0f, (float)12.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg = root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-3.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, false), PartPose.m_171423_((float)5.0f, (float)12.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(E yak, float limbSwing, float limbSwingAmount, float ageInTicks, float yaw, float pitch) {
        if (limbSwingAmount == 0.0f && yak.m_20184_().m_82556_() < 1.0E-7) {
            return;
        }
        super.m_6973_(yak, limbSwing, limbSwingAmount, ageInTicks, yaw, pitch);
        float partialTicks = ageInTicks - (float)((Yak)((Object)yak)).f_19797_;
        this.f_103492_.f_104201_ = 3.0f + ((Yak)((Object)yak)).getHeadEatingOffset(partialTicks) * (yak.m_6162_() ? 4.5f : 9.0f);
        this.f_103492_.f_104203_ = ((Yak)((Object)yak)).getHeadPitch(partialTicks);
    }
}

