/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.Tapir;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TapirModel<T extends Tapir>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart snout;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;

    public TapirModel(ModelPart root) {
        super(false, 4.0f, 4.0f, 2.0f, 2.0f, 24.0f);
        this.head = root.m_171324_("head");
        this.snout = this.head.m_171324_("snout");
        this.body = root.m_171324_("body");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -6.0f, 8.0f, 7.0f, 7.0f).m_171514_(30, 9).m_171480_().m_171481_(3.0f, -6.0f, -2.0f, 3.0f, 4.0f, 1.0f).m_171555_(false).m_171514_(30, 9).m_171481_(-6.0f, -6.0f, -2.0f, 3.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)-8.0f));
        head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171481_(-2.0f, -3.0f, -4.0f, 4.0f, 5.0f, 4.0f).m_171514_(46, 1).m_171481_(-2.0f, -3.0f, -6.0f, 4.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-5.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-5.0f, -1.0f, -5.0f, 10.0f, 19.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)-8.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(30, 14).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.m_171419_((float)3.0f, (float)18.0f, (float)-6.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(30, 14).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)-6.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(30, 14).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.m_171419_((float)3.0f, (float)18.0f, (float)6.0f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(30, 14).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void setupAnim(T tapir, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (limbSwingAmount == 0.0f && tapir.m_20184_().m_82556_() < 1.0E-7) {
            return;
        }
        float partialTick = ageInTicks - (float)((Tapir)((Object)tapir)).f_19797_;
        float snoutraiseanim = ((Tapir)((Object)tapir)).getSnoutRaiseAmount(partialTick);
        float shakeheadanim = ((Tapir)((Object)tapir)).getHeadShakeAnim(partialTick);
        float neckangle = ((Tapir)((Object)tapir)).getNeckAngle(partialTick);
        float noanimamount = 1.0f - ((Tapir)((Object)tapir)).getNoAnimAmount(partialTick);
        this.head.f_104201_ = 11.0f;
        this.head.f_104202_ = -8.0f;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) * noanimamount;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.snout.f_104203_ = 0.0f;
        this.snout.f_104204_ = 0.0f;
        this.head.f_104201_ += neckangle;
        this.head.f_104202_ += -neckangle;
        this.head.f_104203_ += neckangle * 0.7f;
        if (((Tapir)((Object)tapir)).isSniffing()) {
            this.head.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.8f)) * 0.015f;
            this.snout.f_104203_ = Mth.m_14031_((float)(ageInTicks * 0.7f)) * Mth.m_14031_((float)(ageInTicks * 0.2f)) * 0.3f;
            this.snout.f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.6f)) * 0.05f;
        } else if (((Tapir)((Object)tapir)).isGrazing()) {
            float sinAgeInTicks = Mth.m_14031_((float)(ageInTicks * 0.5f));
            this.head.f_104203_ += sinAgeInTicks * 0.05f;
            this.snout.f_104203_ = sinAgeInTicks * 0.3f;
        }
        this.snout.f_104203_ += -0.4f * snoutraiseanim;
        if (shakeheadanim > 0.0f) {
            this.head.f_104204_ = Mth.m_14031_((float)(shakeheadanim * (float)Math.PI / 4.0f)) * 0.3f * noanimamount;
        }
        float cosLimbSwing = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float cosLimbSwingPlusPi = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightHindLeg.f_104203_ = cosLimbSwing;
        this.leftHindLeg.f_104203_ = cosLimbSwingPlusPi;
        this.rightFrontLeg.f_104203_ = cosLimbSwingPlusPi;
        this.leftFrontLeg.f_104203_ = cosLimbSwing;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }
}

