/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import traben.entity_model_features.EMFAnimationApi;
import traben.entity_sound_features.ESFConfig;
import traben.entity_sound_features.methods.ESFIsPlayingSoundMethodFactory;
import traben.entity_sound_features.methods.ESFPlaySoundMethodFactory;
import traben.entity_sound_features.properties.PlayingSoundProperty;
import traben.entity_sound_features.properties.SoundRuleIndexProperty;
import traben.entity_sound_features.properties.SoundSuffixProperty;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.features.property_reading.properties.RandomProperties;
import traben.tconfig.TConfigHandler;

public class ESF {
    public static final String MOD_ID = "entity_sound_features";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"entity_sound_features");
    private static TConfigHandler<ESFConfig> configHandler = null;

    @NotNull
    public static ResourceLocation res(String fullPath) {
        return new ResourceLocation(fullPath);
    }

    @NotNull
    public static ResourceLocation res(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static TConfigHandler<ESFConfig> config() {
        if (configHandler == null) {
            configHandler = new TConfigHandler(ESFConfig::new, MOD_ID, "ESF");
            ETF.registerConfigHandler(configHandler);
        }
        return configHandler;
    }

    public static void init() {
        LOGGER.info("[ESF (Entity Sound Features)] initialized.");
        ESF.config();
        ETFApi.registerCustomRandomPropertyFactory((String)MOD_ID, (RandomProperties.RandomPropertyFactory[])new RandomProperties.RandomPropertyFactory[]{RandomProperties.RandomPropertyFactory.of((String)"soundRule", (String)"entity_sound_features.rule_property", SoundRuleIndexProperty::getPropertyOrNull), RandomProperties.RandomPropertyFactory.of((String)"soundSuffix", (String)"entity_sound_features.suffix_property", SoundSuffixProperty::getPropertyOrNull), RandomProperties.RandomPropertyFactory.of((String)"playingSound", (String)"entity_sound_features.config.playingsound.property", PlayingSoundProperty::getPropertyOrNull)});
        EMFAnimationApi.registerCustomFunctionFactory((String)MOD_ID, (String)"playsound", (String)"entity_sound_features.config.playsound.method", ESFPlaySoundMethodFactory::new);
        EMFAnimationApi.registerCustomFunctionFactory((String)MOD_ID, (String)"playingsound", (String)"entity_sound_features.config.playingsound.method", ESFIsPlayingSoundMethodFactory::new);
    }

    public static Screen getConfigScreen(Screen parent) {
        return ESF.getConfigScreen(null, parent);
    }

    public static Screen getConfigScreen(Minecraft ignored, Screen parent) {
        return ETF.getConfigScreen((Screen)parent);
    }

    public static void log(String message) {
        LOGGER.info("[ESF] " + message);
    }

    public static void logError(String message) {
        LOGGER.error("[ESF] " + message);
    }

    public static void logWarn(String message) {
        LOGGER.warn("[ESF] " + message);
    }
}

