/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import java.util.Arrays;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.utils.EMFUtils;

public class EMFBoxData {
    public float[] textureOffset = new float[0];
    public float[] uvDown = new float[0];
    public float[] uvUp = new float[0];
    public float[] uvFront = new float[0];
    public float[] uvBack = new float[0];
    public float[] uvLeft = new float[0];
    public float[] uvRight = new float[0];
    public float[] uvNorth = new float[0];
    public float[] uvSouth = new float[0];
    public float[] uvWest = new float[0];
    public float[] uvEast = new float[0];
    public float[] coordinates = new float[0];
    public float sizeAdd = 0.0f;
    public float sizeAddX = 0.0f;
    public float sizeAddY = 0.0f;
    public float sizeAddZ = 0.0f;

    public void prepare(boolean invertX, boolean invertY, boolean invertZ) {
        try {
            boolean offsetValid;
            if (this.sizeAdd != 0.0f && this.sizeAddX == 0.0f && this.sizeAddY == 0.0f && this.sizeAddZ == 0.0f) {
                this.sizeAddX = this.sizeAdd;
                this.sizeAddY = this.sizeAdd;
                this.sizeAddZ = this.sizeAdd;
            }
            if (invertX) {
                this.coordinates[0] = -this.coordinates[0] - this.coordinates[3];
            }
            if (invertY) {
                this.coordinates[1] = -this.coordinates[1] - this.coordinates[4];
            }
            if (invertZ) {
                this.coordinates[2] = -this.coordinates[2] - this.coordinates[5];
            }
            boolean bl = offsetValid = this.textureOffset.length == 2;
            if (!offsetValid && this.textureOffset.length != 0) {
                throw new IllegalArgumentException("Invalid textureOffset data: " + Arrays.toString(this.textureOffset));
            }
            if (!offsetValid) {
                this.checkAndFixUVLegacyDirections();
                this.validateUV(this.uvDown, "uvDown");
                this.validateUV(this.uvUp, "uvUp");
                this.validateUV(this.uvNorth, "uvNorth");
                this.validateUV(this.uvSouth, "uvSouth");
                this.validateUV(this.uvWest, "uvWest");
                this.validateUV(this.uvEast, "uvEast");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error preparing box data: " + e.getMessage(), e);
        }
    }

    private void validateUV(float[] uv, String name) {
        if (uv.length == 0) {
            return;
        }
        if (uv.length != 4) {
            throw new IllegalArgumentException("Invalid UV data for [" + name + "], must have 4 or 0 values: " + Arrays.toString(uv));
        }
        if (((EMFConfig)EMF.config().getConfig()).enforceOptiFineFloorUVs) {
            uv[0] = (float)Math.floor(uv[0]);
            uv[1] = (float)Math.floor(uv[1]);
            uv[2] = (float)Math.floor(uv[2]);
            uv[3] = (float)Math.floor(uv[3]);
        } else if ((double)uv[0] != Math.floor(uv[0]) || (double)uv[1] != Math.floor(uv[1]) || (double)uv[2] != Math.floor(uv[2]) || (double)uv[3] != Math.floor(uv[3])) {
            EMFUtils.logWarn("Possibly invalid UV data for [" + name + "], all values should usually be integers (whole numbers), because OptiFine floors them, EMF can be set to not floor these values in the OptiFine parity settings: " + Arrays.toString(uv));
        }
        if (((EMFConfig)EMF.config().getConfig()).allowEBEModConfigModify) {
            if (uv[2] == uv[0]) {
                EMFUtils.logWarn("Possibly invalid UV data for [" + name + "], the U width should not be 0, its behaviour is extremely inconsistent between hardware: " + Arrays.toString(uv));
            }
            if (uv[3] == uv[1]) {
                EMFUtils.logWarn("Possibly invalid UV data for [" + name + "], the V height should not be 0, its behaviour is extremely inconsistent between hardware: " + Arrays.toString(uv));
            }
        }
    }

    public void checkAndFixUVLegacyDirections() {
        if (this.uvFront.length == 4) {
            this.uvNorth = this.uvFront;
        }
        if (this.uvBack.length == 4) {
            this.uvWest = this.uvBack;
        }
        if (this.uvLeft.length == 4) {
            this.uvNorth = this.uvLeft;
        }
        if (this.uvRight.length == 4) {
            this.uvEast = this.uvRight;
        }
    }

    public String toString() {
        return "EMF_BoxData{coordinates=" + Arrays.toString(this.coordinates) + ", uvDown=" + Arrays.toString(this.uvDown) + ", uvUp=" + Arrays.toString(this.uvUp) + ", uvNorth=" + Arrays.toString(this.uvNorth) + ", uvSouth=" + Arrays.toString(this.uvSouth) + ", uvWest=" + Arrays.toString(this.uvWest) + ", uvEast=" + Arrays.toString(this.uvEast) + ", textureOffset=" + Arrays.toString(this.textureOffset) + ", sizeAdd=" + this.sizeAdd + "}";
    }
}

