/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.other;

import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.util.EntityUtil;
import com.teamabnormals.endergetic.common.advancement.EECriteriaTriggers;
import com.teamabnormals.endergetic.common.block.CorrockBlock;
import com.teamabnormals.endergetic.common.block.CorrockCrownBlock;
import com.teamabnormals.endergetic.common.block.CorrockCrownStandingBlock;
import com.teamabnormals.endergetic.common.block.CorrockCrownWallBlock;
import com.teamabnormals.endergetic.common.block.CorrockPlantBlock;
import com.teamabnormals.endergetic.common.block.InfestedCorrockBlock;
import com.teamabnormals.endergetic.common.block.SpeckledCorrockBlock;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.item.BolloomBalloonItem;
import com.teamabnormals.endergetic.common.network.entity.S2CUpdateBalloonsMessage;
import com.teamabnormals.endergetic.core.EndergeticExpansion;
import com.teamabnormals.endergetic.core.interfaces.BalloonHolder;
import com.teamabnormals.endergetic.core.other.EEDataProcessors;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="endergetic")
public final class EEEvents {
    private static final AttributeModifier SLOW_BALLOON = new AttributeModifier(UUID.fromString("eb2242e0-d3be-11ea-87d0-0242ac130003"), "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SUPER_SLOW_BALLOON = new AttributeModifier(UUID.fromString("b5c9b111-62b3-40da-b396-f90a138583ad"), "Super slow falling acceleration reduction", -0.075, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier PURPOID_SLOWFALL = new AttributeModifier(UUID.fromString("6bec3438-1392-426b-9173-618fa9499de5"), "Slow falling acceleration reduction from a Purpoid", -0.07, AttributeModifier.Operation.ADDITION);
    public static final Map<Supplier<Block>, Supplier<Block>> PETRIFICATION_MAP = (Map)Util.m_137469_((Object)Maps.newHashMap(), petrifications -> {
        petrifications.put(EEBlocks.END_CORROCK, EEBlocks.PETRIFIED_END_CORROCK);
        petrifications.put(EEBlocks.NETHER_CORROCK, EEBlocks.PETRIFIED_NETHER_CORROCK);
        petrifications.put(EEBlocks.OVERWORLD_CORROCK, EEBlocks.PETRIFIED_OVERWORLD_CORROCK);
        petrifications.put(EEBlocks.END_CORROCK_BLOCK, EEBlocks.PETRIFIED_END_CORROCK_BLOCK);
        petrifications.put(EEBlocks.NETHER_CORROCK_BLOCK, EEBlocks.PETRIFIED_NETHER_CORROCK_BLOCK);
        petrifications.put(EEBlocks.OVERWORLD_CORROCK_BLOCK, EEBlocks.PETRIFIED_OVERWORLD_CORROCK_BLOCK);
        petrifications.put(EEBlocks.SPECKLED_OVERWORLD_CORROCK, EEBlocks.PETRIFIED_SPECKLED_OVERWORLD_CORROCK);
        petrifications.put(EEBlocks.SPECKLED_NETHER_CORROCK, EEBlocks.PETRIFIED_SPECKLED_NETHER_CORROCK);
        petrifications.put(EEBlocks.SPECKLED_END_CORROCK, EEBlocks.PETRIFIED_SPECKLED_END_CORROCK);
        petrifications.put(() -> EEBlocks.END_CORROCK_CROWN.get(), () -> EEBlocks.PETRIFIED_END_CORROCK_CROWN.get());
        petrifications.put(() -> EEBlocks.NETHER_CORROCK_CROWN.get(), () -> EEBlocks.PETRIFIED_NETHER_CORROCK_CROWN.get());
        petrifications.put(() -> EEBlocks.OVERWORLD_CORROCK_CROWN.get(), () -> EEBlocks.PETRIFIED_OVERWORLD_CORROCK_CROWN.get());
        petrifications.put(() -> EEBlocks.END_WALL_CORROCK_CROWN.get(), () -> EEBlocks.PETRIFIED_END_WALL_CORROCK_CROWN.get());
        petrifications.put(() -> EEBlocks.NETHER_WALL_CORROCK_CROWN.get(), () -> EEBlocks.PETRIFIED_NETHER_WALL_CORROCK_CROWN.get());
        petrifications.put(() -> EEBlocks.OVERWORLD_WALL_CORROCK_CROWN.get(), () -> EEBlocks.PETRIFIED_OVERWORLD_WALL_CORROCK_CROWN.get());
        petrifications.put(EEBlocks.INFESTED_CORROCK, EEBlocks.PETRIFIED_INFESTED_CORROCK);
    });

    @SubscribeEvent
    public static void onThrowableImpact(ProjectileImpactEvent event) {
        Projectile projectileEntity = event.getProjectile();
        if (projectileEntity instanceof ThrownPotion) {
            HitResult hitResult;
            ThrownPotion potionEntity = (ThrownPotion)projectileEntity;
            ItemStack itemstack = potionEntity.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List list = PotionUtils.m_43547_((ItemStack)itemstack);
            if (potion == Potions.f_43599_ && list.isEmpty() && (hitResult = event.getRayTraceResult()) instanceof BlockHitResult) {
                BlockHitResult blockraytraceresult = (BlockHitResult)hitResult;
                Level world = potionEntity.m_9236_();
                Direction direction = blockraytraceresult.m_82434_();
                BlockPos blockpos = blockraytraceresult.m_82425_().m_121945_(Direction.DOWN).m_121945_(direction);
                EEEvents.tryToConvertCorrockBlock(world, blockpos);
                EEEvents.tryToConvertCorrockBlock(world, blockpos.m_121945_(direction.m_122424_()));
                for (Direction faces : Direction.values()) {
                    EEEvents.tryToConvertCorrockBlock(world, blockpos.m_121945_(faces));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_) {
            IDataManager dataManager;
            int cooldown;
            boolean isFalling;
            boolean hasABalloon;
            int balloonCount = ((BalloonHolder)entity).getBalloons().size();
            AttributeInstance gravity = entity.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean bl = hasABalloon = balloonCount > 0;
            if (hasABalloon) {
                entity.f_19789_ = 0.0f;
            }
            boolean bl2 = isFalling = entity.m_20184_().f_82480_ <= 0.0;
            if (isFalling && balloonCount < 3 && hasABalloon) {
                if (!gravity.m_22109_(SLOW_BALLOON)) {
                    gravity.m_22118_(SLOW_BALLOON);
                }
            } else if (gravity.m_22109_(SLOW_BALLOON)) {
                gravity.m_22130_(SLOW_BALLOON);
            }
            if (isFalling && balloonCount == 3) {
                if (!gravity.m_22109_(SUPER_SLOW_BALLOON)) {
                    gravity.m_22118_(SUPER_SLOW_BALLOON);
                }
            } else if (gravity.m_22109_(SUPER_SLOW_BALLOON)) {
                gravity.m_22130_(SUPER_SLOW_BALLOON);
            }
            if (isFalling && entity.m_146862_(e -> e instanceof Purpoid)) {
                entity.f_19789_ = 0.0f;
                if (!gravity.m_22109_(PURPOID_SLOWFALL)) {
                    gravity.m_22118_(PURPOID_SLOWFALL);
                }
            } else if (gravity.m_22109_(PURPOID_SLOWFALL)) {
                gravity.m_22130_(PURPOID_SLOWFALL);
            }
            if (balloonCount > 3) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 2, balloonCount - 4, false, false, false));
                if (entity instanceof ServerPlayer) {
                    EECriteriaTriggers.UP_UP_AND_AWAY.trigger((ServerPlayer)entity);
                }
            }
            if (entity instanceof IDataManager && (cooldown = ((Integer)(dataManager = (IDataManager)entity).getValue(EEDataProcessors.CATCHING_COOLDOWN)).intValue()) > 0) {
                dataManager.setValue(EEDataProcessors.CATCHING_COOLDOWN, (Object)(cooldown - 1));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTracked(PlayerEvent.StartTracking event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Entity trackingEntity = event.getTarget();
        if (trackingEntity instanceof BolloomBalloon) {
            BolloomBalloon balloon = (BolloomBalloon)trackingEntity;
            Entity attachedEntity = balloon.getAttachedEntity();
            if (attachedEntity != null) {
                EndergeticExpansion.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CUpdateBalloonsMessage(attachedEntity));
            }
        } else {
            EndergeticExpansion.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CUpdateBalloonsMessage(trackingEntity));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        BalloonHolder holder = (BalloonHolder)event.getEntity();
        if (!holder.getBalloons().isEmpty()) {
            holder.detachBalloons();
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        InteractionHand hand = event.getHand();
        if (event.getFace() != Direction.DOWN && item instanceof ShovelItem && !player.m_5833_()) {
            BlockState newState;
            Object object = state.m_60713_((Block)EEBlocks.POISMOSS.get()) ? ((Block)EEBlocks.POISMOSS_PATH.get()).m_49966_() : (newState = state.m_60713_((Block)EEBlocks.EUMUS_POISMOSS.get()) ? ((Block)EEBlocks.EUMUS_POISMOSS_PATH.get()).m_49966_() : null);
            if (newState != null && level.m_46859_(pos.m_7494_())) {
                level.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, newState, 11);
                event.getItemStack().m_41622_(1, (LivingEntity)player, damage -> damage.m_21190_(hand));
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlayerSwing(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isAttack()) {
            List<BolloomBalloon> balloons;
            LocalPlayer player = ClientInfo.getClientPlayer();
            if (player.m_146909_() > -25.0f) {
                return;
            }
            Entity ridingEntity = player.m_20202_();
            if (ridingEntity instanceof Boat && BolloomBalloonItem.hasNoEntityTarget((Player)player) && EntityUtil.rayTrace((Entity)player, (double)BolloomBalloonItem.getPlayerReach((Player)player), (float)1.0f).m_6662_() == HitResult.Type.MISS && !(balloons = ((BalloonHolder)ridingEntity).getBalloons()).isEmpty()) {
                Minecraft.m_91087_().f_91072_.m_105223_((Player)player, (Entity)balloons.get(player.m_217043_().m_188503_(balloons.size())));
                event.setSwingHand(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_9236_().f_46443_ && entity instanceof Purpoid) {
            Purpoid purpoid = (Purpoid)entity;
            purpoid.updatePull(entity.m_20182_());
        }
    }

    private static void tryToConvertCorrockBlock(Level world, BlockPos pos) {
        BlockState convertedState;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if ((block instanceof CorrockPlantBlock && !((CorrockPlantBlock)block).petrified || block instanceof CorrockBlock || block instanceof SpeckledCorrockBlock || block instanceof InfestedCorrockBlock || block instanceof CorrockCrownBlock && !((CorrockCrownBlock)block).petrified) && (convertedState = EEEvents.convertCorrockBlock(state)) != null) {
            world.m_46597_(pos, convertedState);
        }
    }

    public static BlockState convertCorrockBlock(BlockState state) {
        Block block = state.m_60734_();
        for (Map.Entry<Supplier<Block>, Supplier<Block>> entries : PETRIFICATION_MAP.entrySet()) {
            Block petrifiedBlock = entries.getValue().get();
            if (entries.getKey().get() != block) continue;
            if (block instanceof CorrockPlantBlock) {
                return (BlockState)petrifiedBlock.m_49966_().m_61124_((Property)CorrockPlantBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)CorrockPlantBlock.WATERLOGGED)));
            }
            if (block instanceof CorrockBlock || block instanceof SpeckledCorrockBlock || block instanceof InfestedCorrockBlock) {
                return petrifiedBlock.m_49966_();
            }
            if (block instanceof CorrockCrownStandingBlock) {
                return (BlockState)((BlockState)((BlockState)petrifiedBlock.m_49966_().m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)((Integer)state.m_61143_((Property)CorrockCrownStandingBlock.ROTATION)))).m_61124_((Property)CorrockCrownStandingBlock.UPSIDE_DOWN, (Comparable)((Boolean)state.m_61143_((Property)CorrockCrownStandingBlock.UPSIDE_DOWN)))).m_61124_((Property)CorrockCrownStandingBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)CorrockCrownStandingBlock.WATERLOGGED)));
            }
            return (BlockState)((BlockState)petrifiedBlock.m_49966_().m_61124_((Property)CorrockCrownWallBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)CorrockCrownWallBlock.WATERLOGGED)))).m_61124_((Property)CorrockCrownWallBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)CorrockCrownWallBlock.FACING)));
        }
        return null;
    }
}

