/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.structure;

import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.common.levelgen.structure.structures.EetleNestPieces;
import com.teamabnormals.endergetic.core.registry.EEStructureTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;

public class EetleNestStructure
extends Structure {
    public static final Codec<EetleNestStructure> CODEC = EetleNestStructure.m_226607_(EetleNestStructure::new);

    public EetleNestStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    private static boolean isAreaCarvable(int x, int z, int y, Structure.GenerationContext context) {
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        RandomState randomState = context.f_226624_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        int foundAirBlocks = 0;
        for (int posX = x - 24; posX <= x + 24; ++posX) {
            for (int posZ = z - 24; posZ <= z + 24; ++posZ) {
                NoiseColumn column = chunkGenerator.m_214184_(posX, posZ, levelHeightAccessor, randomState);
                for (int posY = y - 40; posY < y - 8; ++posY) {
                    Block block = column.m_183556_(posY).m_60734_();
                    if (EetleNestPieces.CARVABLE_BLOCKS.contains(block) || block == Blocks.f_50016_ && ++foundAirBlocks < 576) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        BlockPos blockpos = this.m_226582_(context, Rotation.NONE);
        int yPos = blockpos.m_123342_();
        if (yPos >= 60 && EetleNestStructure.isAreaCarvable(blockpos.m_123341_(), blockpos.m_123342_(), yPos, context)) {
            return Optional.of(new Structure.GenerationStub(blockpos, builder -> builder.m_142679_((StructurePiece)new EetleNestPieces.EetleNestPiece(context.f_226625_(), blockpos))));
        }
        return Optional.empty();
    }

    public StructureType<?> m_213658_() {
        return (StructureType)EEStructureTypes.EETLE_NEST_TYPE.get();
    }
}

