/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.puffbug;

import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.TimedEndimation;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import com.teamabnormals.endergetic.api.entity.util.RayTraceHelper;
import com.teamabnormals.endergetic.api.util.GenerationUtils;
import com.teamabnormals.endergetic.common.block.entity.BolloomBudTileEntity;
import com.teamabnormals.endergetic.common.block.entity.PuffBugHiveTileEntity;
import com.teamabnormals.endergetic.common.block.poise.BolloomBudBlock;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugAttachToHiveGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugAttackGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugBoostGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugCreateItemGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugDescentGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugPollinateGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugPullOutGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugRestOnHiveGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugRotateToFireGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugTargetAggressorGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugTeleportToBudGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.ai.PuffBugTeleportToRestGoal;
import com.teamabnormals.endergetic.common.network.entity.puffbug.RotateMessage;
import com.teamabnormals.endergetic.core.EndergeticExpansion;
import com.teamabnormals.endergetic.core.other.EEDataSerializers;
import com.teamabnormals.endergetic.core.other.EEPlayableEndimations;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEItems;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import com.teamabnormals.endergetic.core.registry.EESoundEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class PuffBug
extends Animal
implements Endimatable {
    public static final Predicate<LivingEntity> CAN_ANGER = entity -> {
        if (entity instanceof Player) {
            return entity.m_6084_() && !entity.m_5833_() && !((Player)entity).m_7500_();
        }
        return !(entity instanceof PuffBug) && entity.m_6084_() && !entity.m_5833_() && !entity.m_20145_();
    };
    public static final float SEEKING_FACTOR = 1.1f;
    public static final EntityDimensions PROJECTILE_SIZE = EntityDimensions.m_20398_((float)0.5f, (float)0.5f);
    public static final EntityDimensions PROJECTILE_SIZE_CHILD = EntityDimensions.m_20398_((float)0.26325f, (float)0.26325f);
    private static final EntityDataAccessor<Optional<BlockPos>> HIVE_POS = SynchedEntityData.m_135353_(PuffBug.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Direction> ATTACHED_HIVE_SIDE = SynchedEntityData.m_135353_(PuffBug.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Optional<Vec3>> LAUNCH_DIRECTION = SynchedEntityData.m_135353_(PuffBug.class, EEDataSerializers.OPTIONAL_VEC3D);
    private static final EntityDataAccessor<Optional<Vec3>> FIRE_DIRECTION = SynchedEntityData.m_135353_(PuffBug.class, EEDataSerializers.OPTIONAL_VEC3D);
    private static final EntityDataAccessor<Boolean> FROM_BOTTLE = SynchedEntityData.m_135353_(PuffBug.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INFLATED = SynchedEntityData.m_135353_(PuffBug.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BOOSTING = SynchedEntityData.m_135353_(PuffBug.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(PuffBug.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final TimedEndimation HIVE_LANDING = new TimedEndimation(20, 0);
    public final TimedEndimation HIVE_SLEEP = new TimedEndimation(25, 0);
    private TeleportController teleportController;
    private RotationController rotationController;
    @Nullable
    private BlockPos budPos;
    @Nullable
    private BlockPos pollinationPos;
    @Nullable
    private Direction teleportHiveSide;
    @Nullable
    private Direction desiredHiveSide;
    @Nullable
    private ItemStack stackToCreate;
    @Nullable
    public BlockState stuckInBlockState;
    public boolean stuckInBlock;
    public float prevSpin;
    public float spin;
    public int teleportCooldown;
    public int ticksAwayFromHive;
    public int puffCooldown;

    public PuffBug(EntityType<? extends PuffBug> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new PuffBugMoveController(this);
        this.teleportController = new TeleportController(this);
        this.rotationController = new RotationController(this);
        this.f_21364_ = 2;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HIVE_POS, Optional.empty());
        this.m_20088_().m_135372_(ATTACHED_HIVE_SIDE, (Object)Direction.UP);
        this.m_20088_().m_135372_(LAUNCH_DIRECTION, Optional.empty());
        this.m_20088_().m_135372_(FIRE_DIRECTION, Optional.empty());
        this.m_20088_().m_135372_(COLOR, (Object)-1);
        this.m_20088_().m_135372_(FROM_BOTTLE, (Object)false);
        this.m_20088_().m_135372_(INFLATED, (Object)true);
        this.m_20088_().m_135372_(BOOSTING, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(FIRE_DIRECTION) || key.equals(LAUNCH_DIRECTION)) {
            this.m_6210_();
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PuffBugPullOutGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PuffBugRestOnHiveGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PuffBugAttachToHiveGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PuffBugRotateToFireGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new PuffBugCreateItemGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new PuffBugAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PuffBugTeleportToRestGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new PuffBugPollinateGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new PuffBugDescentGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new PuffBugTeleportToBudGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(9, (Goal)new PuffBugBoostGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new PuffBugTargetAggressorGoal(this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22280_, 0.75).m_22268_(Attributes.f_22282_, (double)0.15f).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void m_8119_() {
        if (this.stuckInBlock) {
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.m_20202_() instanceof Booflo) {
            this.disableProjectile();
            this.removeLaunchDirection();
            this.setInflated(true);
        }
        super.m_8119_();
        this.getRotationController().tick();
        this.keepEffectsAbsorbed();
        this.f_19789_ = 0.0f;
        Vec3 motion = this.m_20184_();
        if (!this.m_9236_().f_46443_) {
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
            if (this.puffCooldown > 0) {
                --this.puffCooldown;
            }
            if (!this.m_20159_() && this.isInflated() && !this.getRotationController().rotating && this.isNoEndimationPlaying() && (this.isBoosting() && RayTraceHelper.rayTrace((Entity)this, 2.0, 1.0f).m_6662_() != HitResult.Type.BLOCK || (this.m_20096_() || this.m_20069_()) && this.puffCooldown <= 0 && this.getPollinationPos() == null && this.getLaunchDirection() == null && this.getFireDirection() == null)) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.PUFF_BUG_PUFF);
                this.m_5496_(this.getPuffSound(), 0.15f, this.m_6100_());
            }
            if (this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_TO) && this.getAnimationTick() == 10 && !this.getTeleportController().hasNoDestination()) {
                this.getTeleportController().bringToDestination();
            } else if (this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_FROM)) {
                this.m_20256_(Vec3.f_82478_);
            }
            if (this.getHivePos() == null) {
                Object hive;
                if (this.m_9236_().m_46467_() % 5L == 0L && this.m_217043_().m_188501_() <= 0.1f && (hive = this.findNewNearbyHive()) != null) {
                    this.addToHive((PuffBugHiveTileEntity)((Object)hive));
                    if (this.isNoEndimationPlaying()) {
                        NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.PUFF_BUG_CLAIM_HIVE);
                    }
                }
                this.ticksAwayFromHive = 0;
            } else if (this.getHive() == null) {
                this.setHivePos(null);
            } else if (this.getAttachedHiveSide() == Direction.UP) {
                ++this.ticksAwayFromHive;
                if (this.ticksAwayFromHive < 1500 && this.m_5448_() == null && this.m_217043_().m_188503_(7500) == 0 && !this.m_27593_() && !this.getHive().isHiveFull()) {
                    for (PuffBug nearbyHiveMembers : this.m_9236_().m_6443_(PuffBug.class, this.m_20191_().m_82400_(9.0), puffbug -> puffbug.getHive() != null && puffbug.getHive() == this.getHive() && this.m_20270_((Entity)puffbug) < 12.0f)) {
                        this.m_27601_(1000);
                        this.m_9236_().m_7605_((Entity)this, (byte)18);
                        nearbyHiveMembers.m_27601_(1000);
                        this.m_9236_().m_7605_((Entity)nearbyHiveMembers, (byte)18);
                        if (!this.m_27593_() && !nearbyHiveMembers.m_27593_()) continue;
                        break;
                    }
                }
            } else {
                this.ticksAwayFromHive = 0;
            }
            if (this.getAttachedHiveSide() != Direction.UP) {
                this.setInflated(false);
            } else if (!this.isInflated() && this.getFireDirection() == null) {
                this.setInflated(true);
            }
            if (this.m_5448_() != null && !CAN_ANGER.test(this.m_5448_())) {
                this.m_6710_(null);
            }
            if (this.isProjectile() && (this.m_204031_(FluidTags.f_13131_, 1.0) || this.m_204031_(FluidTags.f_13132_, 1.0))) {
                this.disableProjectile();
            }
        } else {
            this.prevSpin = this.spin;
            RandomSource rand = this.m_217043_();
            if (this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_PUFF) && this.getAnimationTick() == 5) {
                for (i = 0; i < 3; ++i) {
                    offsetX = MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.1f), (RandomSource)rand);
                    offsetZ = MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.1f), (RandomSource)rand);
                    x = this.m_20185_() + offsetX;
                    y = this.m_20186_() + (double)(rand.m_188501_() * 0.05f) + (double)0.7f;
                    z = this.m_20189_() + offsetZ;
                    this.m_9236_().m_7106_((ParticleOptions)EEParticleTypes.SHORT_POISE_BUBBLE.get(), x, y, z, MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.1f), (RandomSource)rand) + (double)0.05f, (double)(rand.m_188501_() * 0.05f + 0.025f), MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.1f), (RandomSource)rand) + (double)0.05f);
                }
            } else if (this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_TO) && this.getAnimationTick() == 8) {
                for (i = 0; i < 6; ++i) {
                    offsetX = MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.1f), (RandomSource)rand);
                    offsetZ = MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.1f), (RandomSource)rand);
                    x = this.m_20185_() + offsetX;
                    y = this.m_20186_() + (double)(rand.m_188501_() * 0.05f) + (double)0.7f;
                    z = this.m_20189_() + offsetZ;
                    this.m_9236_().m_7106_((ParticleOptions)EEParticleTypes.SHORT_POISE_BUBBLE.get(), x, y, z, MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.15f), (RandomSource)rand) + (double)0.025f, (double)(rand.m_188501_() * 0.025f + 0.025f), MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.15f), (RandomSource)rand) + (double)0.025f);
                }
            } else if (this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_FROM) && this.getAnimationTick() == 5) {
                for (i = 0; i < 6; ++i) {
                    offsetX = MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.1f), (RandomSource)rand);
                    offsetZ = MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.1f), (RandomSource)rand);
                    x = this.m_20185_() + offsetX;
                    y = this.m_20186_() + (double)(rand.m_188501_() * 0.05f) + (double)0.7f;
                    z = this.m_20189_() + offsetZ;
                    this.m_9236_().m_7106_((ParticleOptions)EEParticleTypes.SHORT_POISE_BUBBLE.get(), x, y, z, MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.15f), (RandomSource)rand) + (double)0.025f, (double)(rand.m_188501_() * 0.025f + 0.025f), MathUtil.makeNegativeRandomly((double)(rand.m_188501_() * 0.15f), (RandomSource)rand) + (double)0.025f);
                }
            }
            this.HIVE_LANDING.tick();
            this.HIVE_SLEEP.tick();
            this.HIVE_LANDING.setDecrementing(this.getAttachedHiveSide() == Direction.UP);
            if (this.HIVE_LANDING.isMaxed()) {
                if (this.HIVE_SLEEP.isDecrementing() && this.HIVE_SLEEP.getTick() == 0) {
                    this.HIVE_SLEEP.setDecrementing(false);
                } else if (this.HIVE_SLEEP.isMaxed()) {
                    this.HIVE_SLEEP.setDecrementing(true);
                }
            } else {
                this.HIVE_SLEEP.setDecrementing(true);
            }
            this.spin = this.isProjectile() && this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_FLY) ? (this.spin += 55.0f) : 0.0f;
        }
        if (this.getDesiredHiveSide() != null && this.getHive() != null && this.getDesiredHiveSide() != Direction.DOWN) {
            float degrees;
            this.f_19859_ = degrees = (float)(this.getDesiredHiveSide() == Direction.SOUTH ? 0 : this.getDesiredHiveSide().m_122421_().m_122540_()) * (this.getDesiredHiveSide().m_122434_() == Direction.Axis.Z ? 180.0f : -90.0f);
            this.m_146922_(this.f_19859_);
            this.f_20885_ = this.f_20886_ = degrees;
            this.f_20883_ = this.f_20884_ = degrees;
        }
        if (this.getAttachedHiveSide() != Direction.UP) {
            if (this.getHive() != null) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
                this.m_21573_().m_26573_();
                this.m_7910_(0.0f);
                this.m_5997_(0.0, 0.0025f, 0.0);
                this.m_146922_(this.f_19859_);
                this.f_20885_ = this.f_20886_;
                this.f_20883_ = this.f_20884_;
                if (!this.m_9236_().f_46443_ && !this.isAtCorrectRestLocation(this.getAttachedHiveSide())) {
                    this.setAttachedHiveSide(Direction.UP);
                }
            } else if (!this.m_9236_().f_46443_) {
                this.setAttachedHiveSide(Direction.UP);
            }
        } else if (this.getLaunchDirection() != null || this.getFireDirection() != null) {
            this.m_146922_(0.0f);
            this.f_20885_ = 0.0f;
            this.f_20883_ = 0.0f;
            Vec3 fireDirection = this.getFireDirection();
            if (fireDirection != null) {
                if (this.m_9236_().f_46443_ && !this.stuckInBlock || !this.m_9236_().f_46443_) {
                    this.getRotationController().rotate((float)Mth.m_14175_((double)(fireDirection.m_7098_() - (double)this.m_146908_())), (float)fireDirection.m_7096_() + 90.0f, 0.0f, 5);
                }
                LivingEntity target = this.m_5448_();
                if (!this.stuckInBlock) {
                    if (!this.m_9236_().f_46443_ && target != null && this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_FLY)) {
                        float seekOffset = target.m_20186_() > this.m_20186_() ? 0.0f : 0.5f;
                        Vec3 targetVecNoScale = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - (double)seekOffset - this.m_20186_(), target.m_20189_() - this.m_20189_());
                        Vec3 targetVec = targetVecNoScale.m_82490_((double)1.1f);
                        double motionLength = motion.m_82553_();
                        double targetVecLength = targetVec.m_82553_();
                        float totalVecLength = Mth.m_14116_((float)((float)(motionLength * motionLength + targetVecLength * targetVecLength)));
                        Vec3 newMotion = motion.m_82490_(motionLength / (double)totalVecLength).m_82549_(targetVec.m_82490_(targetVecLength / (double)totalVecLength));
                        float gravityCompensator = totalVecLength <= 4.0f ? 0.05f : 0.1f;
                        this.m_20256_(newMotion.m_82490_((double)0.4f).m_82520_(0.0, (double)gravityCompensator, 0.0));
                    }
                    Vec3 newestMotion = this.m_20184_();
                    float pitch = -((float)(Mth.m_14136_((double)newestMotion.m_7098_(), (double)Mth.m_14116_((float)((float)(newestMotion.m_7096_() * newestMotion.m_7096_() + newestMotion.m_7094_() * newestMotion.m_7094_())))) * 57.2957763671875));
                    float yaw = (float)(Mth.m_14136_((double)newestMotion.m_7094_(), (double)newestMotion.m_7096_()) * 57.2957763671875) - 90.0f;
                    this.setFireDirection(pitch, yaw);
                }
            }
        }
        if (this.isProjectile() && !this.isInflated()) {
            VoxelShape voxelshape;
            BlockPos blockpos = this.m_20183_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!(blockstate.m_60795_() || this.f_19794_ || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
                for (AABB axisalignedbb : voxelshape.m_83299_()) {
                    if (!axisalignedbb.m_82338_(blockpos).m_82390_(this.m_20182_())) continue;
                    this.stuckInBlock = true;
                    break;
                }
            }
            if (this.stuckInBlock && !this.f_19794_) {
                if (!this.m_9236_().f_46443_ && this.stuckInBlockState != blockstate && this.m_9236_().m_45772_(this.m_20191_().m_82400_(0.06))) {
                    this.disableProjectile();
                }
                this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            } else {
                Vec3 positionVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                Vec3 endVec = positionVec.m_82549_(motion);
                BlockHitResult traceResult = this.m_9236_().m_45547_(new ClipContext(positionVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                EntityHitResult entityTraceResult = this.traceEntity(positionVec, endVec);
                if (entityTraceResult != null) {
                    traceResult = entityTraceResult;
                }
                if (traceResult.m_6662_() != HitResult.Type.MISS) {
                    this.onSting((HitResult)traceResult);
                    this.f_19812_ = true;
                }
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        ItemStack newStackToCreate;
        CompoundTag stackToCreate;
        super.m_7378_(compound);
        this.setAttachedHiveSide(Direction.m_122376_((int)compound.m_128445_("AttachedHiveSide")));
        this.setFromBottle(compound.m_128471_("FromBottle"));
        this.teleportCooldown = compound.m_128451_("TeleportCooldown");
        this.ticksAwayFromHive = compound.m_128451_("TicksAwayFromHive");
        if (compound.m_128441_("IsInflated")) {
            this.setInflated(compound.m_128471_("IsInflated"));
        }
        if (compound.m_128425_("HivePos", 10)) {
            this.setHivePos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("HivePos")));
        }
        if (compound.m_128425_("StuckInBlockState", 10)) {
            this.stuckInBlockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("StuckInBlockState"));
        }
        if ((stackToCreate = compound.m_128469_("ItemStackToCreate")) != null && !(newStackToCreate = ItemStack.m_41712_((CompoundTag)stackToCreate)).m_41619_()) {
            this.setStackToCreate(newStackToCreate);
        }
        this.rotationController = this.getRotationController().read(this, compound.m_128469_("Orientation"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("AttachedHiveSide", (byte)this.getAttachedHiveSide().m_122411_());
        compound.m_128379_("FromBottle", this.isFromBottle());
        compound.m_128379_("IsInflated", this.isInflated());
        compound.m_128405_("TeleportCooldown", this.teleportCooldown);
        compound.m_128405_("TicksAwayFromHive", this.ticksAwayFromHive);
        if (this.getHivePos() != null) {
            compound.m_128365_("HivePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getHivePos()));
        }
        if (this.hasStackToCreate()) {
            compound.m_128365_("ItemStackToCreate", (Tag)this.getStackToCreate().m_41739_(new CompoundTag()));
        }
        if (this.stuckInBlockState != null) {
            compound.m_128365_("StuckInBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.stuckInBlockState));
        }
        compound.m_128365_("Orientation", (Tag)this.getRotationController().write(new CompoundTag()));
    }

    @Nullable
    public BlockPos getHivePos() {
        return ((Optional)this.m_20088_().m_135370_(HIVE_POS)).orElse(null);
    }

    public void setHivePos(@Nullable BlockPos pos) {
        this.m_20088_().m_135381_(HIVE_POS, Optional.ofNullable(pos));
    }

    @Nullable
    public PuffBugHiveTileEntity getHive() {
        BlockPos hivePos = this.getHivePos();
        if (hivePos != null) {
            try {
                BlockEntity tileEntity = this.m_9236_().m_7702_(hivePos);
                if (tileEntity instanceof PuffBugHiveTileEntity) {
                    return (PuffBugHiveTileEntity)tileEntity;
                }
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos getBudPos() {
        return this.budPos;
    }

    public void setBudPos(@Nullable BlockPos pos) {
        this.budPos = pos;
    }

    @Nullable
    public BlockPos getPollinationPos() {
        return this.pollinationPos;
    }

    public void setPollinationPos(@Nullable BlockPos pos) {
        this.pollinationPos = pos;
    }

    public boolean canAttachToSide(Direction direction) {
        if (direction == Direction.UP) {
            return false;
        }
        return this.getHive() != null && PuffBugHiveTileEntity.HiveOccupantData.isHiveSideEmpty(this.getHive(), direction);
    }

    public Direction getAttachedHiveSide() {
        return (Direction)this.f_19804_.m_135370_(ATTACHED_HIVE_SIDE);
    }

    public void setAttachedHiveSide(@Nullable Direction side) {
        this.f_19804_.m_135381_(ATTACHED_HIVE_SIDE, (Object)(side == null ? Direction.UP : side));
    }

    @Nullable
    public Direction getTeleportHiveSide() {
        return this.teleportHiveSide;
    }

    public void setTeleportHiveSide(@Nullable Direction side) {
        this.teleportHiveSide = side;
    }

    @Nullable
    public Direction getDesiredHiveSide() {
        return this.desiredHiveSide;
    }

    public void setDesiredHiveSide(@Nullable Direction side) {
        this.desiredHiveSide = side;
    }

    public boolean isFromBottle() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOTTLE);
    }

    public void setFromBottle(boolean value) {
        this.f_19804_.m_135381_(FROM_BOTTLE, (Object)value);
    }

    public boolean isInflated() {
        return (Boolean)this.f_19804_.m_135370_(INFLATED);
    }

    public void setInflated(boolean inflated) {
        this.f_19804_.m_135381_(INFLATED, (Object)inflated);
    }

    public boolean isBoosting() {
        return (Boolean)this.f_19804_.m_135370_(BOOSTING);
    }

    public void setBoosting(boolean boosting) {
        this.f_19804_.m_135381_(BOOSTING, (Object)boosting);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public void setStackToCreate(@Nullable ItemStack stack) {
        this.stackToCreate = stack;
    }

    @Nullable
    public ItemStack getStackToCreate() {
        return this.stackToCreate;
    }

    public boolean hasStackToCreate() {
        return this.getStackToCreate() != null;
    }

    public void setLaunchDirection(float pitch, float yaw) {
        this.f_19804_.m_135381_(LAUNCH_DIRECTION, Optional.of(new Vec3((double)pitch, (double)yaw, 0.0)));
    }

    public void setFireDirection(float pitch, float yaw) {
        this.f_19804_.m_135381_(FIRE_DIRECTION, Optional.of(new Vec3((double)pitch, (double)yaw, 0.0)));
    }

    public void removeLaunchDirection() {
        this.f_19804_.m_135381_(LAUNCH_DIRECTION, Optional.empty());
    }

    public void removeFireDirection() {
        this.f_19804_.m_135381_(FIRE_DIRECTION, Optional.empty());
    }

    @Nullable
    public Vec3 getLaunchDirection() {
        return ((Optional)this.f_19804_.m_135370_(LAUNCH_DIRECTION)).orElse(null);
    }

    @Nullable
    public Vec3 getFireDirection() {
        return ((Optional)this.f_19804_.m_135370_(FIRE_DIRECTION)).orElse(null);
    }

    public boolean hasLevitation() {
        return this.m_21023_(MobEffects.f_19620_);
    }

    public boolean m_20068_() {
        return super.m_20068_() || this.getAttachedHiveSide() != Direction.UP;
    }

    public TeleportController getTeleportController() {
        return this.teleportController;
    }

    public RotationController getRotationController() {
        return this.rotationController;
    }

    public void onEndimationStart(PlayableEndimation endimation, PlayableEndimation oldEndimation) {
        if (endimation == EEPlayableEndimations.PUFF_BUG_PUFF) {
            float pitch = this.m_20160_() ? 1.0f : this.m_146909_();
            float xMotion = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
            float zMotion = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
            Vec3 motion = new Vec3((double)xMotion, (double)0.65f, (double)zMotion).m_82541_();
            if (this.m_5448_() != null && CAN_ANGER.test(this.m_5448_())) {
                motion.m_82490_(2.0);
            }
            this.m_5997_(motion.m_7096_() * (this.m_21051_(Attributes.f_22279_).m_22135_() - (double)0.1f), motion.m_7098_(), motion.m_7094_() * (this.m_21051_(Attributes.f_22279_).m_22135_() - (double)0.1f));
        } else if (endimation == EEPlayableEndimations.PUFF_BUG_TELEPORT_TO) {
            if (!this.m_9236_().f_46443_) {
                this.m_5496_(this.getTeleportSound(false), 0.65f, this.m_6100_());
            }
        } else if (endimation == EEPlayableEndimations.PUFF_BUG_FLY) {
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)EESoundEvents.PUFFBUG_LAUNCH.get(), SoundSource.HOSTILE, 0.25f, this.m_217043_().m_188501_() * 0.35f + 0.75f);
        }
    }

    public void onEndimationEnd(PlayableEndimation endimation, PlayableEndimation newEndimation) {
        if (newEndimation != EEPlayableEndimations.PUFF_BUG_TELEPORT_FROM && endimation == EEPlayableEndimations.PUFF_BUG_TELEPORT_TO) {
            if (!this.m_9236_().f_46443_) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.PUFF_BUG_TELEPORT_FROM);
                this.m_5496_(this.getTeleportSound(true), 0.65f, this.m_6100_());
            }
        } else if (endimation == EEPlayableEndimations.PUFF_BUG_POLLINATE) {
            BolloomBudTileEntity bud;
            BlockEntity te;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 3000));
            if (this.getPollinationPos() != null && (te = this.m_9236_().m_7702_(this.getPollinationPos())) instanceof BolloomBudTileEntity && (bud = (BolloomBudTileEntity)te).canBeOpened()) {
                for (BolloomBudTileEntity.BudSide side : BolloomBudTileEntity.BudSide.values()) {
                    BlockPos sidePos = side.offsetPosition(this.getPollinationPos());
                    if (!this.m_9236_().m_8055_(sidePos).m_60812_((BlockGetter)this.m_9236_(), this.getPollinationPos()).m_83281_()) continue;
                    this.m_9236_().m_46961_(sidePos, true);
                }
                this.m_9236_().m_46597_(this.getPollinationPos(), (BlockState)this.m_9236_().m_8055_(this.getPollinationPos()).m_61124_((Property)BolloomBudBlock.OPENED, (Comparable)Boolean.valueOf(true)));
                bud.startGrowing(this.m_217043_(), bud.calculateFruitMaxHeight(), false);
            }
        }
    }

    public void m_7023_(Vec3 moveDirection) {
        if (this.m_21515_() && this.isInflated()) {
            double gravity = this.hasLevitation() ? -0.005 : 0.005;
            float speed = this.m_20096_() ? 0.01f : 0.025f;
            this.m_19920_(speed, moveDirection);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.75));
            this.m_20256_(this.m_20184_().m_82492_(0.0, gravity, 0.0));
        } else {
            boolean noVerticalMotion;
            if (this.stuckInBlock) {
                this.m_20334_(0.0, this.m_20184_().m_7098_(), 0.0);
            }
            boolean bl = noVerticalMotion = this.isInflated() && (this.getAttachedHiveSide() != Direction.UP || this.getDesiredHiveSide() != null);
            if (noVerticalMotion) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            }
            super.m_7023_(Vec3.f_82478_);
            if (noVerticalMotion) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            }
            if (this.isProjectile()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, (double)0.005f, 0.0));
            }
            if (this.stuckInBlock) {
                this.m_20334_(0.0, this.m_20184_().m_7098_(), 0.0);
            }
        }
    }

    public void addToHive(PuffBugHiveTileEntity hive) {
        hive.addBugToHive(this);
        this.setHivePos(hive.m_58899_());
    }

    @Nullable
    public PuffBugHiveTileEntity findNewNearbyHive() {
        BlockPos pos = this.m_20183_();
        int xyDistance = 16;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-xyDistance, -6, -xyDistance), (BlockPos)pos.m_7918_(xyDistance, 6, xyDistance))) {
            PuffBugHiveTileEntity hive;
            BlockEntity blockEntity;
            if (!blockpos.m_203195_((Position)this.m_20182_(), (double)xyDistance) || this.m_9236_().m_8055_(blockpos).m_60734_() != EEBlocks.PUFFBUG_HIVE.get() || !((blockEntity = this.m_9236_().m_7702_(blockpos)) instanceof PuffBugHiveTileEntity) || (hive = (PuffBugHiveTileEntity)blockEntity).isHiveFull() || this.getHive() != null) continue;
            return hive;
        }
        return null;
    }

    protected void setBottleData(ItemStack bottle) {
        if (this.m_8077_()) {
            bottle.m_41714_(this.m_7770_());
        }
        CompoundTag nbt = bottle.m_41784_();
        if (this.getColor() != -1) {
            nbt.m_128405_("ColorTag", this.getColor());
        }
        nbt.m_128405_("TeleportCooldown", this.teleportCooldown);
        if (!this.m_21220_().isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.m_21220_()) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            nbt.m_128365_("CustomPotionEffects", (Tag)listnbt);
        }
        nbt.m_128379_("IsFromBottle", true);
        nbt.m_128379_("IsChild", this.m_6162_());
    }

    private void keepEffectsAbsorbed() {
        Map activePotionMap = this.m_21221_();
        for (MobEffect effect : activePotionMap.keySet()) {
            if (effect == MobEffects.f_19620_) continue;
            MobEffectInstance effectInstance = (MobEffectInstance)activePotionMap.get(effect);
            activePotionMap.put(effect, new MobEffectInstance(effect, effectInstance.m_19557_() + 1, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_()));
        }
    }

    public void tryToTeleportToHive(BlockPos pos) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        ArrayList avaliablePositions = Lists.newArrayList();
        PuffBugHiveTileEntity hive = this.getHive();
        if (hive == null || hive != null && !hive.canTeleportTo() || this.getAttachedHiveSide() == Direction.UP && Math.sqrt(this.m_20238_(Vec3.m_82512_((Vec3i)pos))) < 5.0 || this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_FROM)) {
            return;
        }
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                for (int z = 0; z < 6; ++z) {
                    positions.m_122190_((Vec3i)pos.m_7918_(x, y, z));
                    if (!this.m_9236_().m_46859_((BlockPos)positions)) continue;
                    avaliablePositions.add(new BlockPos((Vec3i)positions));
                }
            }
        }
        if (!avaliablePositions.isEmpty() && !this.isProjectile()) {
            this.getTeleportController().destination = GenerationUtils.getClosestPositionToPos(avaliablePositions, this.m_20183_());
            this.m_21573_().m_26573_();
            if (!this.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_TO)) {
                this.getTeleportController().processTeleportation();
            }
        }
    }

    private void onSting(HitResult result) {
        HitResult.Type resultType = result.m_6662_();
        if (resultType == HitResult.Type.ENTITY) {
            EntityHitResult entityResult = (EntityHitResult)result;
            Entity entity = entityResult.m_82443_();
            if (entity.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, (LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_())) {
                this.setInflated(true);
                this.removeFireDirection();
                this.stuckInBlock = false;
                if (!this.m_21220_().isEmpty() && entity instanceof LivingEntity) {
                    for (MobEffectInstance effects : this.m_21220_()) {
                        ((LivingEntity)entity).m_7292_(effects);
                    }
                    this.m_21219_();
                }
            }
        } else {
            BlockHitResult blockraytraceresult = (BlockHitResult)result;
            this.stuckInBlockState = this.m_9236_().m_8055_(blockraytraceresult.m_82425_());
            this.stuckInBlock = true;
            Vec3 end = result.m_82450_();
            this.m_6034_(end.m_7096_(), end.m_7098_(), end.m_7094_());
            this.m_20256_(Vec3.f_82478_);
            if (!this.m_9236_().f_46443_) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.PUFF_BUG_LAND);
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)EESoundEvents.PUFFBUG_LAND.get(), SoundSource.HOSTILE, 0.5f, this.m_6100_());
        }
    }

    @Nullable
    private EntityHitResult traceEntity(Vec3 start, Vec3 end) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)start, (Vec3)end, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(0.5), result -> !result.m_5833_() && result.m_6084_() && !(result instanceof PuffBug));
    }

    public void disableProjectile() {
        this.stuckInBlock = false;
        this.setInflated(true);
        this.removeFireDirection();
        this.m_9236_().m_7605_((Entity)this, (byte)38);
    }

    public boolean wantsToRest() {
        return this.ticksAwayFromHive >= 3000;
    }

    public boolean isProjectile() {
        return this.getFireDirection() != null || this.getLaunchDirection() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAtCorrectRestLocation(Direction side) {
        BlockEntity te;
        BlockEntity blockEntity = side == Direction.DOWN ? (this.m_6162_() ? this.m_9236_().m_7702_(this.m_20183_().m_6630_(1)) : this.m_9236_().m_7702_(this.m_20183_().m_6630_(2))) : (te = this.m_6162_() ? this.m_9236_().m_7702_(this.m_20183_().m_121945_(side.m_122424_())) : this.m_9236_().m_7702_(this.m_20183_().m_6630_(1).m_121945_(side.m_122424_())));
        if (te != this.getHive()) {
            return false;
        }
        BlockPos hivePos = this.getHivePos();
        switch (side) {
            case UP: {
                return false;
            }
            case DOWN: {
                float yOffsetDown = 0.5f + (this.m_6162_() ? 0.45f : -0.15f);
                if (!(Vec3.m_272021_((Vec3i)hivePos.m_7495_(), (double)1.0, (double)yOffsetDown, (double)1.0).m_82554_(this.m_20182_()) < 0.25)) return false;
                return true;
            }
        }
        float yOffset = this.m_6162_() ? 0.2f : -0.2f;
        BlockPos sideOffset = hivePos.m_121945_(side);
        if (!this.m_9236_().m_46859_(sideOffset.m_7494_())) return false;
        if (!this.m_9236_().m_46859_(sideOffset.m_7495_())) return false;
        double d = Vec3.m_82528_((Vec3i)sideOffset).m_82520_((double)this.getTeleportController().getOffsetForDirection(side)[0], (double)yOffset, (double)this.getTeleportController().getOffsetForDirection(side)[1]).m_82554_(this.m_20182_());
        float f = this.m_6162_() ? 0.1f : 0.25f;
        if (!(d < (double)f)) return false;
        return true;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new EndergeticFlyingPathNavigator((Mob)this, worldIn);
    }

    public boolean m_35506_() {
        return super.m_35506_() && this.isInflated();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 38) {
            this.stuckInBlock = false;
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double boundingBoxLength = this.m_20191_().m_82309_() * 2.5;
        if (Double.isNaN(boundingBoxLength)) {
            boundingBoxLength = 1.0;
        }
        return distance < (boundingBoxLength = boundingBoxLength * 64.0 * PuffBug.m_20150_()) * boundingBoxLength;
    }

    public Vec3 m_7371_(float partialTicks) {
        BlockPos blockpos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + (double)this.m_20192_()), (double)this.m_20189_());
        if (this.stuckInBlock && !this.isInflated()) {
            Direction verticalOffset;
            boolean rotationFlag = true;
            float[] rotations = this.getRotationController().getRotations(1.0f);
            Direction horizontalOffset = Direction.m_122364_((double)rotations[0]).m_122424_();
            Direction direction = verticalOffset = rotations[1] <= 180.0f && rotations[1] > 100.0f ? Direction.UP : Direction.DOWN;
            if (rotations[1] >= 80.0f && rotations[1] <= 100.0f) {
                rotationFlag = false;
            }
            return this.m_9236_().isAreaLoaded(blockpos, 0) ? Vec3.m_82512_((Vec3i)(rotationFlag ? blockpos.m_121945_(horizontalOffset).m_121945_(verticalOffset) : blockpos.m_121945_(horizontalOffset))) : super.m_7371_(partialTicks);
        }
        return super.m_7371_(partialTicks);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return this.isProjectile() ? 0.0f : size.f_20378_ * 0.5f;
    }

    protected void m_8034_() {
        super.m_8034_();
        Collection effects = this.m_21220_();
        if (!effects.isEmpty()) {
            this.setColor(PotionUtils.m_43564_((Collection)effects));
        } else {
            this.setColor(-1);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)EEItems.PUFF_BUG_SPAWN_EGG.get());
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)EEBlocks.TALL_POISE_BUSH.get()).m_5456_();
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82400_(12.0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (!this.m_6084_() || this.m_5912_()) {
            return InteractionResult.FAIL;
        }
        if (item == Items.f_42590_) {
            this.m_5496_(SoundEvents.f_11771_, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            ItemStack bottle = new ItemStack((ItemLike)EEItems.PUFF_BUG_BOTTLE.get());
            this.setBottleData(bottle);
            if (itemstack.m_41619_()) {
                player.m_21008_(hand, bottle);
            } else if (!player.m_150109_().m_36054_(bottle)) {
                player.m_36176_(bottle, false);
            }
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (!this.hasStackToCreate() && this.hasLevitation()) {
            ItemStack newStackToCreate;
            Object object = item == EEItems.BOLLOOM_FRUIT.get() ? new ItemStack((ItemLike)EEBlocks.BOLLOOM_BUD.get()) : (newStackToCreate = this.m_6898_(itemstack) ? new ItemStack((ItemLike)EEBlocks.PUFFBUG_HIVE.get()) : null);
            if (newStackToCreate != null) {
                this.setStackToCreate(newStackToCreate);
                this.m_142075_(player, hand, itemstack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        RandomSource rng = this.m_217043_();
        if (dataTag != null) {
            int age = dataTag.m_128471_("IsChild") ? -24000 : 0;
            this.m_146762_(age);
            this.teleportCooldown = dataTag.m_128451_("TeleportCooldown");
            this.setFromBottle(dataTag.m_128471_("IsFromBottle"));
            if (dataTag.m_128425_("ColorTag", 3)) {
                this.setColor(dataTag.m_128451_("ColorTag"));
            }
            if (dataTag.m_128441_("CustomPotionEffects")) {
                for (MobEffectInstance effectinstance : PotionUtils.m_43573_((CompoundTag)dataTag)) {
                    this.m_7292_(effectinstance);
                }
            }
        }
        if (reason == MobSpawnType.STRUCTURE) {
            this.ticksAwayFromHive = rng.m_188503_(1500) + 1500;
            if (rng.m_188501_() < 0.1f) {
                this.f_146733_ = -24000;
            }
        } else if ((reason == MobSpawnType.NATURAL || reason == MobSpawnType.SPAWNER) && rng.m_188501_() < 0.05f) {
            int swarmSize = rng.m_188503_(11) + 10;
            Vec3 centeredPos = Vec3.m_82512_((Vec3i)this.m_20183_());
            for (int i = 0; i < swarmSize; ++i) {
                Vec3 spawnPos = centeredPos.m_82520_(MathUtil.makeNegativeRandomly((double)(rng.m_188501_() * 5.5f), (RandomSource)rng), MathUtil.makeNegativeRandomly((double)(rng.m_188501_() * 2.0f), (RandomSource)rng), MathUtil.makeNegativeRandomly((double)(rng.m_188501_() * 5.5f), (RandomSource)rng));
                if (!this.m_9236_().m_46859_(BlockPos.m_274446_((Position)spawnPos))) continue;
                PuffBug swarmChild = (PuffBug)((EntityType)EEEntityTypes.PUFF_BUG.get()).m_20615_(this.m_9236_());
                swarmChild.m_7678_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), 0.0f, 0.0f);
                swarmChild.m_6518_(worldIn, this.m_9236_().m_6436_(BlockPos.m_274446_((Position)spawnPos)), MobSpawnType.EVENT, null, null);
                swarmChild.m_146762_(-24000);
                this.m_9236_().m_7967_((Entity)swarmChild);
            }
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.getHive() == null && !this.isFromBottle() && !this.m_8077_();
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.isFromBottle();
    }

    protected void m_7324_(Entity entity) {
        if (!this.isInflated() && !(entity instanceof PuffBug) && this.isProjectile() && entity.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)this), 5.0f)) {
            this.setInflated(true);
            this.removeFireDirection();
            this.stuckInBlock = false;
            if (!this.m_21220_().isEmpty() && entity instanceof LivingEntity) {
                for (MobEffectInstance effects : this.m_21220_()) {
                    ((LivingEntity)entity).m_7292_(effects);
                }
                this.m_21219_();
            }
        }
        super.m_7324_(entity);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isProjectile() ? (this.m_6162_() ? PROJECTILE_SIZE_CHILD : PROJECTILE_SIZE) : super.m_6972_(pose);
    }

    public boolean m_6673_(DamageSource source) {
        return (this.isProjectile() || this.m_20159_()) && (source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268576_) || source.m_276093_(DamageTypes.f_268613_)) || super.m_6673_(source);
    }

    public boolean m_6147_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.SOUNDS;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)EEEntityTypes.PUFF_BUG.get()).m_20615_(this.m_9236_());
    }

    public SoundEvent getPuffSound() {
        return (SoundEvent)EESoundEvents.PUFFBUG_PUFF.get();
    }

    public SoundEvent getTeleportSound(boolean from) {
        return from ? (SoundEvent)EESoundEvents.PUFFBUG_TELEPORT_FROM.get() : (SoundEvent)EESoundEvents.PUFFBUG_TELEPORT_TO.get();
    }

    public SoundEvent getSleepSound() {
        return (SoundEvent)EESoundEvents.PUFFBUG_SLEEP.get();
    }

    public SoundEvent getItemCreationSound() {
        return (SoundEvent)EESoundEvents.PUFFBUG_CREATE_ITEM.get();
    }

    public SoundEvent getLaunchSound() {
        return (SoundEvent)EESoundEvents.PUFFBUG_LAUNCH.get();
    }

    public SoundEvent getLandSound() {
        return (SoundEvent)EESoundEvents.PUFFBUG_LAND.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EESoundEvents.PUFFBUG_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)EESoundEvents.PUFFBUG_HURT.get();
    }

    static class PuffBugMoveController
    extends MoveControl {
        private final PuffBug puffbug;

        PuffBugMoveController(PuffBug puffbug) {
            super((Mob)puffbug);
            this.puffbug = puffbug;
        }

        public void m_8126_() {
            if (!this.puffbug.isInflated()) {
                this.puffbug.m_7910_(0.0f);
                return;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.puffbug.m_21573_().m_26571_()) {
                double xDistance = this.f_24975_ - this.puffbug.m_20185_();
                double yDistance = this.f_24976_ - this.puffbug.m_20186_();
                double zDistance = this.f_24977_ - this.puffbug.m_20189_();
                double totalDistance = Mth.m_14116_((float)((float)(xDistance * xDistance + yDistance * yDistance + zDistance * zDistance)));
                double verticalVelocity = yDistance / totalDistance;
                float angle = (float)(Mth.m_14136_((double)zDistance, (double)xDistance) * 57.29577951308232) - 90.0f;
                this.puffbug.m_146922_(this.m_24991_(this.puffbug.m_146908_(), angle, 20.0f));
                this.puffbug.f_20883_ = this.puffbug.m_146908_();
                float speed = (float)(this.f_24978_ * this.puffbug.m_21051_(Attributes.f_22280_).m_22135_());
                if (verticalVelocity < 0.0) {
                    this.puffbug.m_7910_(Mth.m_14179_((float)0.125f, (float)this.puffbug.m_6113_(), (float)speed));
                    this.puffbug.m_20256_(this.puffbug.m_20184_().m_82520_(0.0, (double)this.puffbug.m_6113_() * verticalVelocity * 0.05, 0.0));
                    this.puffbug.setBoosting(false);
                } else {
                    this.puffbug.setBoosting(true);
                }
            } else {
                this.puffbug.m_7910_(0.0f);
                this.puffbug.setBoosting(false);
            }
        }
    }

    public static class TeleportController {
        private PuffBug puffbug;
        private Level world;
        @Nullable
        private BlockPos destination;

        TeleportController(PuffBug puffbug) {
            this.puffbug = puffbug;
            this.world = puffbug.m_9236_();
        }

        public void processTeleportation() {
            if (!this.hasNoDestination() && !this.world.f_46443_) {
                this.puffbug.m_21573_().m_26573_();
                NetworkUtil.setPlayingAnimation((Entity)this.puffbug, (PlayableEndimation)EEPlayableEndimations.PUFF_BUG_TELEPORT_TO);
                this.puffbug.teleportCooldown = this.puffbug.m_217043_().m_188503_(300) + 1200;
            }
        }

        protected void bringToDestination() {
            if (!this.world.f_46443_) {
                float zOffset;
                float xOffset;
                Direction side = this.puffbug.getTeleportHiveSide();
                float f = xOffset = side == null || side == Direction.DOWN ? 0.5f : this.getOffsetForDirection(side)[0];
                float yOffset = side == Direction.DOWN ? (this.puffbug.m_6162_() ? 0.45f : -0.15f) : (this.puffbug.m_6162_() ? 0.2f : -0.2f);
                float f2 = zOffset = side == null || side == Direction.DOWN ? 0.5f : this.getOffsetForDirection(side)[1];
                if (side == null) {
                    NetworkUtil.teleportEntity((Entity)this.puffbug, (double)((float)this.destination.m_123341_() + 0.5f), (double)((float)this.destination.m_123342_() + 0.5f), (double)((float)this.destination.m_123343_() + 0.5f));
                } else {
                    NetworkUtil.teleportEntity((Entity)this.puffbug, (double)((float)this.destination.m_123341_() + xOffset), (double)((float)this.destination.m_123342_() + yOffset), (double)((float)this.destination.m_123343_() + zOffset));
                }
                this.destination = null;
                this.puffbug.m_21573_().m_26573_();
                this.puffbug.m_20256_(Vec3.f_82478_);
                if (side != null) {
                    this.puffbug.setDesiredHiveSide(side);
                    this.puffbug.setTeleportHiveSide(null);
                }
            }
        }

        public boolean tryToCreateDesinationTo(BlockPos pos, @Nullable Direction direction) {
            boolean directionFlag;
            boolean bl = directionFlag = direction == null || this.world.m_46859_(pos.m_121945_(direction));
            if (!(direction == null || direction == Direction.DOWN || this.world.m_46859_(pos.m_7494_()) && this.world.m_46859_(pos.m_7495_()))) {
                directionFlag = false;
            }
            if (this.puffbug.f_19797_ > 5 && this.world.m_46859_(pos) && directionFlag && this.hasNoDestination() && this.world.m_45976_(Entity.class, new AABB(pos)).isEmpty()) {
                this.destination = pos;
                return true;
            }
            return false;
        }

        public boolean hasNoDestination() {
            return this.destination == null;
        }

        public boolean canTeleport() {
            return this.destination == null && this.puffbug.teleportCooldown <= 0;
        }

        protected float[] getOffsetForDirection(Direction side) {
            float[] fArray;
            switch (side) {
                default: {
                    float[] fArray2;
                    if (this.puffbug.m_6162_()) {
                        float[] fArray3 = new float[2];
                        fArray3[0] = 0.5f;
                        fArray2 = fArray3;
                        fArray3[1] = 0.85f;
                    } else {
                        float[] fArray4 = new float[2];
                        fArray4[0] = 0.5f;
                        fArray2 = fArray4;
                        fArray4[1] = 0.75f;
                    }
                    return fArray2;
                }
                case SOUTH: {
                    float[] fArray5;
                    if (this.puffbug.m_6162_()) {
                        float[] fArray6 = new float[2];
                        fArray6[0] = 0.5f;
                        fArray5 = fArray6;
                        fArray6[1] = 0.15f;
                    } else {
                        float[] fArray7 = new float[2];
                        fArray7[0] = 0.5f;
                        fArray5 = fArray7;
                        fArray7[1] = 0.25f;
                    }
                    return fArray5;
                }
                case EAST: {
                    float[] fArray8;
                    if (this.puffbug.m_6162_()) {
                        float[] fArray9 = new float[2];
                        fArray9[0] = 0.15f;
                        fArray8 = fArray9;
                        fArray9[1] = 0.5f;
                    } else {
                        float[] fArray10 = new float[2];
                        fArray10[0] = 0.25f;
                        fArray8 = fArray10;
                        fArray10[1] = 0.5f;
                    }
                    return fArray8;
                }
                case WEST: 
            }
            if (this.puffbug.m_6162_()) {
                float[] fArray11 = new float[2];
                fArray11[0] = 0.85f;
                fArray = fArray11;
                fArray11[1] = 0.5f;
            } else {
                float[] fArray12 = new float[2];
                fArray12[0] = 0.75f;
                fArray = fArray12;
                fArray12[1] = 0.5f;
            }
            return fArray;
        }
    }

    public static class RotationController {
        private PuffBug puffbug;
        private float prevYaw;
        private float yaw;
        private float startingYaw;
        private float prevPitch;
        private float pitch;
        private float startingPitch;
        private float setYaw;
        private float setPitch;
        private int tickLength;
        private int ticksSinceNotRotating;
        public boolean rotating;

        RotationController(PuffBug puffbug) {
            this.puffbug = puffbug;
        }

        protected void tick() {
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            if (!this.rotating) {
                ++this.ticksSinceNotRotating;
                if (this.ticksSinceNotRotating > 5) {
                    if (this.setYaw != 0.0f) {
                        this.startingYaw = this.yaw;
                    }
                    if (this.setPitch != 0.0f) {
                        this.startingPitch = this.pitch;
                        if (this.puffbug.isNoEndimationPlaying()) {
                            NetworkUtil.setPlayingAnimation((Entity)this.puffbug, (PlayableEndimation)EEPlayableEndimations.PUFF_BUG_ROTATE);
                        }
                    }
                    this.setYaw = 0.0f;
                    this.setPitch = 0.0f;
                    this.tickLength = this.puffbug.m_20159_() ? 1 : 20;
                }
            }
            this.yaw = this.clamp(this.setYaw - this.startingYaw <= 0.0f, this.yaw + (this.setYaw - this.startingYaw) / (float)this.tickLength, this.startingYaw, this.setYaw);
            this.pitch = this.clamp(this.setPitch - this.startingPitch <= 0.0f, this.pitch + (this.setPitch - this.startingPitch) / (float)this.tickLength, this.startingPitch, this.setPitch);
            this.rotating = false;
        }

        private float clamp(boolean invert, float num, float min, float max) {
            if (invert) {
                return num > max ? num : max;
            }
            if (num < min) {
                return min;
            }
            return num > max ? max : num;
        }

        public void rotate(float yaw, float pitch, float roll, int tickLength) {
            if (this.setYaw != yaw) {
                this.startingYaw = this.yaw;
            }
            if (this.setPitch != pitch) {
                this.startingPitch = this.pitch;
                if (tickLength >= 20 && this.puffbug.isNoEndimationPlaying()) {
                    NetworkUtil.setPlayingAnimation((Entity)this.puffbug, (PlayableEndimation)EEPlayableEndimations.PUFF_BUG_ROTATE);
                }
            }
            this.setYaw = yaw;
            this.setPitch = pitch;
            this.tickLength = tickLength;
            this.rotating = true;
            this.ticksSinceNotRotating = 0;
            if (!this.puffbug.m_9236_().f_46443_) {
                EndergeticExpansion.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.puffbug), (Object)new RotateMessage(this.puffbug.m_19879_(), tickLength, yaw, pitch, roll));
            }
        }

        protected CompoundTag write(CompoundTag compound) {
            compound.m_128350_("Yaw", this.yaw);
            compound.m_128350_("Pitch", this.pitch);
            compound.m_128350_("SetYaw", this.setYaw);
            compound.m_128350_("SetPitch", this.setPitch);
            compound.m_128350_("StartingYaw", this.startingYaw);
            compound.m_128350_("StartingPitch", this.startingPitch);
            compound.m_128405_("TickLength", this.tickLength);
            compound.m_128379_("Rotating", this.rotating);
            return compound;
        }

        protected RotationController read(PuffBug puffbug, CompoundTag compound) {
            RotationController rotationController = new RotationController(puffbug);
            rotationController.yaw = rotationController.prevYaw = compound.m_128457_("Yaw");
            rotationController.pitch = rotationController.prevPitch = compound.m_128457_("Pitch");
            rotationController.setYaw = compound.m_128457_("SetYaw");
            rotationController.setPitch = compound.m_128457_("SetPitch");
            rotationController.startingYaw = compound.m_128457_("StartingYaw");
            rotationController.startingPitch = compound.m_128457_("StartingPitch");
            rotationController.tickLength = compound.m_128451_("TickLength");
            rotationController.rotating = compound.m_128471_("Rotating");
            return rotationController;
        }

        public float[] getRotations(float ptc) {
            return new float[]{Mth.m_14179_((float)ptc, (float)this.prevYaw, (float)this.yaw), Mth.m_14179_((float)ptc, (float)this.prevPitch, (float)this.pitch)};
        }
    }
}

