/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo.ai;

import com.teamabnormals.endergetic.common.entity.bolloom.BolloomFruit;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class BoofloHuntFruitGoal
extends Goal {
    private final Booflo booflo;
    protected int attackTick;
    private final double speedTowardsTarget;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private long lastCanUseCheck;

    public BoofloHuntFruitGoal(Booflo booflo, double speed) {
        this.booflo = booflo;
        this.speedTowardsTarget = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.booflo.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (this.booflo.hasAggressiveAttackTarget()) {
            return false;
        }
        if (!this.booflo.isBoofed()) {
            return false;
        }
        this.path = this.booflo.m_21573_().m_7864_(target.m_20183_(), 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(target) >= this.booflo.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
    }

    public boolean m_8045_() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.booflo.isBoofed()) {
            return false;
        }
        if (!this.booflo.m_21444_(target.m_20183_())) {
            return false;
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
    }

    public void m_8056_() {
        this.booflo.m_21573_().m_26536_(this.path, 1.0);
        this.booflo.m_21561_(true);
        this.delayCounter = 0;
    }

    public void m_8041_() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (!EntitySelector.f_20406_.test(target)) {
            this.booflo.setBoofloAttackTargetId(0);
        }
        this.booflo.m_21561_(false);
        this.booflo.m_21573_().m_26573_();
    }

    public void m_8037_() {
        --this.delayCounter;
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return;
        }
        double distToEnemySqr = this.booflo.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
        this.booflo.m_21563_().m_24950_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 10.0f, 10.0f);
        if (this.delayCounter <= 0 || target.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.booflo.m_217043_().m_188501_() < 0.05f) {
            this.targetX = target.m_20185_();
            this.targetY = target.m_20191_().f_82289_;
            this.targetZ = target.m_20189_();
            this.delayCounter = 4 + this.booflo.m_217043_().m_188503_(7);
            if (distToEnemySqr > 1024.0) {
                this.delayCounter += 5;
            } else if (distToEnemySqr > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.booflo.m_21573_().m_5624_(target, this.speedTowardsTarget)) {
                this.delayCounter += 5;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.tryToCapturePrey(target, distToEnemySqr);
    }

    protected void tryToCapturePrey(Entity prey, double distToEnemySqr) {
        double attackReach = this.getAttackReachSqr(prey);
        if (distToEnemySqr <= attackReach && this.attackTick <= 0) {
            this.attackTick = 20;
            if (prey instanceof BolloomFruit) {
                ((BolloomFruit)prey).onBroken(false);
                this.booflo.setCaughtFruit(true);
                this.booflo.setHungry(false);
                prey.m_146870_();
            }
        }
    }

    protected double getAttackReachSqr(Entity attackTarget) {
        return (this.booflo.m_20205_() * 2.0f * this.booflo.m_20205_() * 2.0f + attackTarget.m_20205_()) * 0.85f;
    }

    public boolean m_183429_() {
        return true;
    }
}

