/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block.entity;

import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import com.teamabnormals.endergetic.common.block.EetleEggBlock;
import com.teamabnormals.endergetic.common.entity.eetle.AbstractEetle;
import com.teamabnormals.endergetic.core.registry.EEBlockEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import com.teamabnormals.endergetic.core.registry.EESoundEvents;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class EetleEggTileEntity
extends BlockEntity {
    private static final Random RANDOM = new Random();
    private final SackGrowth[] sackGrowths;
    private int hatchDelay = -30000 - RANDOM.nextInt(12001);
    private int hatchProgress;
    private boolean bypassesSpawningGameRule;
    public boolean fromBroodEetle;

    public EetleEggTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EEBlockEntityTypes.EETLE_EGG.get(), pos, state);
        this.sackGrowths = new SackGrowth[]{new SackGrowth(), new SackGrowth(), new SackGrowth(), new SackGrowth()};
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EetleEggTileEntity eetleEgg) {
        if (level != null) {
            if (level.f_46443_) {
                for (SackGrowth growth : eetleEgg.sackGrowths) {
                    growth.tick();
                }
            } else if ((((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46134_)).m_46223_() || eetleEgg.bypassesSpawningGameRule) && !level.m_46758_(pos) && level.m_46791_() != Difficulty.PEACEFUL && !((Boolean)eetleEgg.m_58900_().m_61143_((Property)EetleEggBlock.PETRIFIED)).booleanValue()) {
                int delay;
                if (RANDOM.nextFloat() < 0.05f && eetleEgg.hatchDelay < -60 && !level.m_6443_(Player.class, new AABB(pos).m_82400_(1.0), player -> player.m_6084_() && !player.m_6144_() && !player.m_20145_() && !player.m_7500_() && !player.m_5833_()).isEmpty()) {
                    eetleEgg.hatchDelay = -60;
                    level.m_7260_(eetleEgg.m_58899_(), eetleEgg.m_58900_(), eetleEgg.m_58900_(), 3);
                }
                if ((delay = eetleEgg.hatchDelay) < 0) {
                    if (!eetleEgg.bypassesSpawningGameRule && delay > -300 && delay % 5 == 0 && level.m_45976_(AbstractEetle.class, new AABB(eetleEgg.m_58899_()).m_82400_(14.0)).size() >= 7) {
                        delay = -600 - RANDOM.nextInt(201);
                    }
                    eetleEgg.updateHatchDelay(level, ++delay);
                } else if (delay > 0) {
                    eetleEgg.updateHatchDelay(level, --delay);
                } else if (eetleEgg.hatchProgress < 20 && RANDOM.nextFloat() < 0.9f) {
                    level.m_7260_(eetleEgg.m_58899_(), eetleEgg.m_58900_(), eetleEgg.m_58900_(), 3);
                    if (++eetleEgg.hatchProgress >= 20) {
                        level.m_46961_(pos, false);
                        int x = pos.m_123341_();
                        int y = pos.m_123342_();
                        int z = pos.m_123343_();
                        Direction facing = (Direction)state.m_61143_((Property)EetleEggBlock.FACING);
                        float xOffset = facing.m_122429_();
                        float yOffset = facing == Direction.DOWN ? 0.25f : 0.1f;
                        float zOffset = facing.m_122431_();
                        int size = (Integer)state.m_61143_((Property)EetleEggBlock.SIZE);
                        boolean fromBroodEetle = eetleEgg.fromBroodEetle;
                        for (int i = 0; i <= size; ++i) {
                            AbstractEetle eetle;
                            AbstractEetle abstractEetle = eetle = RANDOM.nextFloat() < 0.6f ? (AbstractEetle)((EntityType)EEEntityTypes.CHARGER_EETLE.get()).m_20615_(level) : (AbstractEetle)((EntityType)EEEntityTypes.GLIDER_EETLE.get()).m_20615_(level);
                            if (eetle == null) continue;
                            eetle.markFromEgg();
                            eetle.updateAge(-(RANDOM.nextInt(41) + 120));
                            eetle.m_19890_((float)x + RANDOM.nextFloat() * 0.5f + xOffset * 0.5f * RANDOM.nextFloat(), (float)y + yOffset, (float)z + RANDOM.nextFloat() * 0.5f + zOffset * 0.5f * RANDOM.nextFloat(), RANDOM.nextFloat() * 360.0f, 0.0f);
                            if (fromBroodEetle) {
                                eetle.applyDespawnTimer();
                            }
                            level.m_7967_((Entity)eetle);
                        }
                        if (level instanceof ServerLevel) {
                            ((ServerLevel)level).m_8767_((ParticleOptions)new CorrockCrownParticleData((ParticleType<CorrockCrownParticleData>)((ParticleType)EEParticleTypes.END_CROWN.get()), true), (double)((float)x + 0.5f), (double)((float)y + 0.25f * ((float)size + 1.0f)), (double)((float)z + 0.5f), 5 + size, (double)0.3f, (double)0.1f, (double)0.3f, 0.1);
                        }
                    }
                }
            } else if (eetleEgg.hatchDelay > -80 || eetleEgg.hatchProgress > 0) {
                eetleEgg.hatchProgress = 0;
                eetleEgg.hatchDelay = -80;
                level.m_7260_(pos, eetleEgg.m_58900_(), eetleEgg.m_58900_(), 3);
            }
            if (!level.f_46443_ && RANDOM.nextFloat() <= 0.0025f) {
                level.m_5594_(null, pos, (SoundEvent)EESoundEvents.EETLE_EGG_AMBIENT.get(), SoundSource.BLOCKS, 0.25f + RANDOM.nextFloat() * 0.25f, (float)(0.9 + RANDOM.nextDouble() * 0.1));
            }
        }
    }

    public void updateHatchDelay(Level world, int hatchDelay) {
        int prevDelay = this.hatchDelay;
        this.hatchDelay = hatchDelay;
        if (prevDelay < 0 && hatchDelay >= 0 || prevDelay >= 0 && hatchDelay < 0) {
            world.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getHatchDelay() {
        return this.hatchDelay;
    }

    public void bypassSpawningGameRule() {
        this.bypassesSpawningGameRule = true;
    }

    public SackGrowth[] getSackGrowths() {
        return this.sackGrowths;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        block4: {
            if (this.f_58857_ == null) break block4;
            this.m_142466_(packet.m_131708_());
            if (this.hatchProgress > 0) {
                for (SackGrowth growth : this.sackGrowths) {
                    growth.stage = SackGrowth.Stage.BURSTING;
                    growth.cooldown = Math.max(0, growth.cooldown - 15);
                }
            } else {
                SackGrowth.Stage growthStage = this.hatchDelay >= -60 ? SackGrowth.Stage.HATCHING : SackGrowth.Stage.IDLE;
                for (SackGrowth growth : this.sackGrowths) {
                    growth.stage = growthStage;
                }
            }
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("HatchDelay", this.hatchDelay);
        compound.m_128405_("HatchProgress", this.hatchProgress);
        compound.m_128379_("BypassSpawningGameRule", this.bypassesSpawningGameRule);
        compound.m_128379_("FromBroodEetle", this.fromBroodEetle);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("HatchDelay", 3)) {
            this.hatchDelay = compound.m_128451_("HatchDelay");
        }
        this.hatchProgress = Mth.m_14045_((int)compound.m_128451_("HatchProgress"), (int)0, (int)2);
        this.bypassesSpawningGameRule = compound.m_128471_("BypassSpawningGameRule");
        this.fromBroodEetle = compound.m_128471_("FromBroodEetle");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static class SackGrowth {
        private Stage stage = Stage.IDLE;
        private int cooldown;
        private float prevGrowth;
        private float growth;

        public SackGrowth() {
            this.cooldown += RANDOM.nextInt(21) + 5;
        }

        public void tick() {
            this.prevGrowth = this.growth;
            Stage stage = this.stage;
            if (this.cooldown > 0) {
                --this.cooldown;
                this.growth = Math.max(0.0f, this.growth - stage.growthSpeed);
            } else {
                float maxGrowth = stage.maxGrowth;
                this.growth = Math.min(maxGrowth, this.growth + stage.growthSpeed);
                if (this.growth == maxGrowth) {
                    this.cooldown = (int)((float)this.cooldown + ((float)RANDOM.nextInt(36) + 25.0f) * stage.cooldownMultiplier);
                }
            }
        }

        public float getGrowth(float partialTicks) {
            return 1.0f + Mth.m_14179_((float)partialTicks, (float)this.prevGrowth, (float)this.growth);
        }

        public float getGrowthMultiplied(float partialTicks, float multiplier) {
            return 1.0f + multiplier * Mth.m_14179_((float)partialTicks, (float)this.prevGrowth, (float)this.growth);
        }

        static enum Stage {
            IDLE(0.0075f, 0.15f, 1.0f),
            HATCHING(0.01875f, 0.225f, 0.35f),
            BURSTING(0.0275f, 0.45f, 0.0f);

            private final float growthSpeed;
            private final float maxGrowth;
            private final float cooldownMultiplier;

            private Stage(float growthSpeed, float maxGrowth, float cooldownMultiplier) {
                this.growthSpeed = growthSpeed;
                this.maxGrowth = maxGrowth;
                this.cooldownMultiplier = cooldownMultiplier;
            }
        }
    }
}

