/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.model.purpoid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import com.teamabnormals.endergetic.api.util.ModelUtil;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.entity.purpoid.PurpoidSize;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PurpoidGelModel
extends EndimatorEntityModel<Purpoid> {
    public ModelPart gelLayer;
    private float headScale;

    public PurpoidGelModel(ModelPart root) {
        this.gelLayer = root.m_171324_("gelLayer");
        this.endimator = Endimator.compile((ModelPart)root);
    }

    public static LayerDefinition createPurpoidLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition gelLayer = root.m_171599_("gelLayer", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-8.0f, -16.0f, -8.0f, 16.0f, 16.0f, 16.0f, false), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)96);
    }

    public static LayerDefinition createPurpLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition gelLayer = root.m_171599_("gelLayer", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createPurpazoidLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition gelLayer = root.m_171599_("gelLayer", CubeListBuilder.m_171558_().m_171514_(112, 0).m_171488_(-16.0f, -32.0f, -16.0f, 32.0f, 32.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void parentToHead(ModelPart head) {
        ModelPart gelLayer = this.gelLayer;
        gelLayer.f_104203_ = head.f_104203_;
        gelLayer.f_104204_ = head.f_104204_;
        gelLayer.f_104205_ = head.f_104205_;
        gelLayer.f_104200_ = head.f_104200_;
        gelLayer.f_104201_ = head.f_104201_ + 1.0f;
        gelLayer.f_104202_ = head.f_104202_;
        this.headScale = head.f_233554_;
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.gelLayer.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(Purpoid entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart gelLayer = this.gelLayer;
        gelLayer.f_233555_ = 1.0f;
        gelLayer.f_233554_ = 1.0f;
        gelLayer.f_233553_ = 1.0f;
        PlayableEndimation playingEndimation = entity.getPlayingEndimation();
        Endimation endimation = playingEndimation.asEndimation();
        if (endimation != null) {
            float length;
            float time = ((float)entity.getAnimationTick() + ClientInfo.getPartialTicks()) * 0.05f;
            if (time > (length = endimation.getLength())) {
                time = length;
            }
            this.endimator.apply(endimation, time, Endimator.ResetMode.RESET);
            entity.getEffectHandler().update(endimation, time);
        }
        if (playingEndimation == PlayableEndimation.BLANK) {
            float scaleOffset = Mth.m_14031_((float)((entity.m_6162_() ? limbSwing / 3.0f : limbSwing) * 0.6f)) * Math.min(0.17f, limbSwingAmount * 0.85f);
            float horizontalScaleOffset = Math.max(-0.05f, scaleOffset);
            float baseScale = entity.getSize() == PurpoidSize.NORMAL && entity.getRestOntoAnimationProgress(ClientInfo.getPartialTicks()) > 0.0f ? this.headScale : 1.0f;
            ModelUtil.setScale(this.gelLayer, baseScale + horizontalScaleOffset, baseScale - scaleOffset * 0.5f, baseScale + horizontalScaleOffset);
        }
    }

    public void reset() {
        this.endimator.getPoseMap().forEach((partName, posedPart) -> {
            posedPart.reset();
            posedPart.part.reset();
        });
    }
}

