/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.networking.messages;

import com.elenai.elenaidodge2.client.ED2ClientStorage;
import com.elenai.elenaidodge2.client.animation.DodgeAnimator;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class DodgeAnimationSTCPacket {
    private final String direction;
    private final int id;

    public DodgeAnimationSTCPacket(String direction, int id) {
        this.direction = direction;
        this.id = id;
    }

    public DodgeAnimationSTCPacket(FriendlyByteBuf buf) {
        this.direction = buf.m_130277_();
        this.id = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.direction);
        buf.writeInt(this.id);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft instance = Minecraft.m_91087_();
            Entity player = instance.f_91073_.m_6815_(this.id);
            DodgeAnimationSTCPacket.animatePlayer(DodgeAnimator.DodgeDirection.valueOf(this.direction), (AbstractClientPlayer)player);
        });
        return true;
    }

    public static void animatePlayer(DodgeAnimator.DodgeDirection direction, AbstractClientPlayer player) {
        ModifierLayer<IAnimation> animation;
        if (ED2ClientStorage.isAnimating() && (animation = DodgeAnimator.animationData.get(player)) != null) {
            switch (direction) {
                case FORWARDS: {
                    animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("elenaidodge2", "animation.player.dodge"))));
                    break;
                }
                case LEFT: {
                    animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("elenaidodge2", "animation.player.dodge.left"))));
                    break;
                }
                case RIGHT: {
                    animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("elenaidodge2", "animation.player.dodge.right"))));
                    break;
                }
                case FORWARDS_LEFT: {
                    animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("elenaidodge2", "animation.player.dodge.forwardsleft"))));
                    break;
                }
                case FORWARDS_RIGHT: {
                    animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("elenaidodge2", "animation.player.dodge.forwardsright"))));
                    break;
                }
                case BACKWARDS_LEFT: {
                    animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("elenaidodge2", "animation.player.dodge.backwardsleft"))));
                    break;
                }
                case BACKWARDS_RIGHT: {
                    animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("elenaidodge2", "animation.player.dodge.backwardsright"))));
                    break;
                }
                default: {
                    animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("elenaidodge2", "animation.player.dodge.backwards"))));
                }
            }
        }
    }
}

