/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.networking;

import com.elenai.elenaidodge2.networking.messages.ConfigSyncSTCPacket;
import com.elenai.elenaidodge2.networking.messages.DodgeAnimationSTCPacket;
import com.elenai.elenaidodge2.networking.messages.DodgeEffectsCTSPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ED2Messages {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel network;
        INSTANCE = network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("elenaidodge2", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        network.messageBuilder(ConfigSyncSTCPacket.class, ED2Messages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(ConfigSyncSTCPacket::new).encoder(ConfigSyncSTCPacket::toBytes).consumerMainThread(ConfigSyncSTCPacket::handle).add();
        network.messageBuilder(DodgeAnimationSTCPacket.class, ED2Messages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(DodgeAnimationSTCPacket::new).encoder(DodgeAnimationSTCPacket::toBytes).consumerMainThread(DodgeAnimationSTCPacket::handle).add();
        network.messageBuilder(DodgeEffectsCTSPacket.class, ED2Messages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(DodgeEffectsCTSPacket::new).encoder(DodgeEffectsCTSPacket::toBytes).consumerMainThread(DodgeEffectsCTSPacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToPlayersNearby(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), message);
    }

    public static <MSG> void sendToPlayersNearbyAndSelf(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), message);
    }

    static {
        packetId = 0;
    }
}

